/********
*
*         Program
*
*     Application: Generic Application
*       File Name: CTRLOBJ.PRG
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 12-08-94              Date updated: 12-08-94
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: Definitons for class methods
*
**/


#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif

#ifndef _CTRLOBJ_CH
  #include "CtrlObj.ch"
#endif


/**
*
*          Method
*
*            Name: Init()
*
*       Arguments: nTop    - Numeric Top    postion of Object
*                : nLeft   - Numeric Left   postion of Object
*                : nBottom - Numeric Bottom postion of Object
*                : nRight  - Numeric Right  postion of Object
*    Return Value: None
*        See Also: TObject:Init()
*
*     Description: Initialises all properties to defaults
**/

method Init( nTop, nLeft, nBottom, nRight ), ( nTop, nLeft, nBottom, nRight )
  ::NameID     := 0
  ::HelpID     := 0
  ::HiPos      := 0

  ::bClick     := {|| .t. }
  ::bDblClick  := {|| .t. }
  ::bDragDown  := {|| .t. }
  ::bKeyPress  := {|| .t. }

  ::Color      := SetColor()
  ::lVisible   := .t.
  ::lEnabled   := .t.
  ::RefreshLst := {}
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: Click()
*
*       Arguments: oEvnt - Object of root type TEvent
*    Return Value: self  - Object of type TCtrlObj
*        See Also: TObject class
*
*     Description: This method has been implemented in more of a procedural
*                  manner as opposed to OOPs.  The OOPs approach is to have
*                  a new class which inherits from TCtrlObj but then redefines
*                  the Click method.  The OOPs approach is always available
*                  to the programmer who(of cource knows how to use Class(y))
*                  The other group of programmers are more strictly object
*                  assemblers (VB people).  They can manage with what they
*                  have got.  CA-Clipper's Code Block system is a dream come
*                  true for them.
**/

method Click( oEvnt )
  if ( ::bClick != NIL)
     ::bClick:Eval( ::Parent, self, oEvnt )
  endif
return ( self )


/**
*
*          Method
*
*            Name: DblClick()
*
*       Arguments: oEvnt - Object of root type TEvent
*    Return Value: self  - Object of type TCtrlObj
*        See Also: TObject class
*
*     Description: Read Click Descriptions
**/

method DblClick( oEvnt )
  if ( ::bDblClick != NIL)
     ::bDblClick:Eval( ::Parent, self, oEvnt )
  endif
return ( self )


/**
*
*          Method
*
*            Name: DragDown()
*
*       Arguments: oEvnt - Object of root type TEvent
*    Return Value: self  - Object of type TCtrlObj
*        See Also: TObject class
*
*     Description: Read Click Descriptions
**/

method DragDown( oEvnt )
  if ( ::bDragDown != NIL)
     ::bDragDown:Eval( ::Parent, self, oEvnt )
  endif
return ( self )


/**
*
*          Method
*
*            Name: KeyPress()
*
*       Arguments: oEvnt - Object of root type TEvent
*    Return Value: self  - Object of type TCtrlObj
*        See Also: TObject class
*
*     Description: Read Click Descriptions
**/

method KeyPress( oEvnt )
  if ( ::bKeyPress != NIL)
     ::bKeyPress:Eval( ::Parent, self, oEvnt )
  endif
return ( self )


/**
*
*          Method
*
*            Name: Caption()
*
*       Arguments: Character cCaption
*    Return Value: Character String
*        See Also: ::cCaption Instance Var
*
*     Description: set/gets the Caption value
**/

method Caption( cCaption )
  Local cCurrValue := ::cCaption

  if ( cCaption != NIL )
     if ( ::cCaption != cCaption )
        ::cCaption := cCaption
        ::Height   := 1
        ::HiPos    := At( "&", cCaption )
        if ( ::HiPos > 0 )
           ::HotKey   := ::GetAltKey( SubStr(cCaption, ::HiPos, 1) )
           ::cCaption := StrTran( cCaption, "&", "", 1, 1 )
        endif
        ::Width    := Len( ::cCaption )
     endif
  endif
return ( cCurrValue )


/**
*
*          Method
*
*            Name: Enabled()
*
*       Arguments: Logical state value
*    Return Value: Logical of the previous state
*        See Also: ::Visible, ::lEnabled Inst var
*
*     Description: set/gets the Enabled value
**/

method Enabled( lState )
  Local lStatus := ::lEnabled

  if ( lState != NIL )
     if (::lEnabled != lState )
        ::lEnabled := lState
        ::Add2FrmRLst()
     endif
  endif
return ( lStatus )


/**
*
*          Method
*
*            Name: Move()
*
*       Arguments: nTop  - New Top  position relative to the screen
*                : nLeft - New Left position relative to the screen
*    Return Value: self  - Object of type TCtrlObj
*        See Also: ::TObject:Hide(), ::TObject:Show()
*
*     Description: Moves the object to another screen location
**/

method Move( nTop, nLeft )
  Local cCtrlScr := NIL
  Local lmCsrON  := ::oMD:Set( .f. )

  cCtrlScr := ::oDC:SaveScreen( ::Top(), ::Left(), ::Bottom(), ::Right() )
  ::TObject:Hide()
  ::Top( nTop )
  ::Left( nLeft )
  ::TObject:Show()
  ::oDC:RestScreen( ::Top(), ::Left(), ::Bottom(), ::Right(), cCtrlScr )
  ::oMD:Set( lmcsrON )
return ( self )


/**
*
*          Method
*
*            Name: Show()
*
*    Return Value: NIL
*        See Also: ::Hide()
*
*     Description: Shows the current object if its visiblity is set true
**/

method Show()
  if ( ::Visible )
     ::TObject:Show()
  endif
return NIL


/**
*
*          Method
*
*            Name: Visible()
*
*       Arguments: Logical State value to set
*    Return Value: Logical Status value of previous setting
*        See Also: ::Enabled(), ::lVisible Inst var.
*
*     Description:
*
**/

method Visible( lState )
  Local lStatus := ::lVisible

  if ( lState != NIL )
     if (::lVisible != lState )
        ::lVisible := lState
        ::Add2FrmRLst()
     endif
  endif
return ( lStatus )



/***************************************************************************
*
*   PROTECTED METHODS
*
*/


/**
*
*          Method
*
*            Name: GetAltKey()
*
*       Arguments: cHotKey - Char value (eg chr(K_ALT_M) )
*    Return Value: Numeric value of the HotKey if supported in the Alt Look up table
*
*     Description: return a numeric of the Alt Hot key.
*
**/

method GetAltKey( cHotKey )
  Local aAltLkUP := { 286,304,302,288,274,289,290,291,279,292,293,294,306, ;
                      305,280,281,272,275,287,276,278,303,273,301,277,300  }
  Local cUprKey  := Upper( cHotKey )
  Local nAltRef  := Asc( cUprKey ) - 64            // (ie. A -> 65 - 64 = 1)
  Local nAltKey  := 0

  if ( nAltRef >= 1 .or. nAltRef <= 26 )           // ALT-<Alphas>
     nAltKey := aAltLkUP[ nAltRef ]
  endif
Return ( nAltKey )



/***************************************************************************
*
*   PRIVATE METHODS
*
*/

/**
*
*          Method
*
*            Name: Add2FrmRLst()
*
*    Return Value: NIL
*        See Also: ::reFresh()
*
*     Description: a Control refresh list is stored to determine which control
*                  need updating when that form gets focus again.
**/

method  Add2FrmRLst()
  Local lFound  := .f.
  Local nCntr   := 0
  Local nMaxLen := Len( ::Parent:reFreshLst )
  Local nThisID := ::NameID

  for nCntr := 1 to ( nMaxLen )
      if ( ::Parent:reFreshLst[nCntr]:NameID == nThisID)
         lFound := .t.
         exit
      endif
  next
  if ( !lFound )
    aAdd( ::Parent:reFreshLst, self )
  endif
return NIL
