;
; Program...: ontickA.asm
; Author....: Suzanne Adams, Brenton Farmer
; Date......: 10/10/91
; Purpose...: Assembly routines to replace microsoft runtime routines
;             _dos_getvect, _dos_setvect
;
.model large,c

.code
_getvector proc far interrupt:word
	public	_getvector

	push	sp
	push	bp
	push	si
	push	di
	push	ds
	push	es

	mov	ax, interrupt
	mov	ah, 35h
	int	21h

	mov	dx, es
	mov	ax, bx

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	pop	sp
	ret
_getvector endp


_setvector proc far interrupt:word, ISRroutine:far ptr
	public	_setvector

	push	sp
	push	bp
	push	si
	push	di
	push	ds
	push	es

	mov	ax, interrupt
	mov	ah, 25h
	lds	dx, ISRroutine	; setup ds and dx
	int	21h

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	pop	sp
	ret
_setvector endp



_getindosAddress proc far
	public  _getindosAddress

	push	sp
	push	bp
	push	si
	push	di
	push	ds
	push	es

	mov	ah, 34h
	int	21h

	mov	dx, es
	mov	ax, bx

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	pop	sp
	ret
_getindosAddress endp

end
