/*
**	Program..: ontick.prg
**	Author...: Brenton Farmer
**	Date.....: 10/10/91
**
**	Purpose..: Set of routines to indirectly attach a Clipper function to the
**            system clock interrupt int 8 in order to evaluate the function
**            on a timed interval.
**
*/
#include "inkey.ch"
#define TRUE  .T.
#define FALSE .F.

Static bFunction

#define _TEST
#ifdef _TEST
Function Main()
Local cString0 := "Now Is the Time ...     "
Local cString1 := "Get Test                "
Local nCount, nInt8Key := 255

	cls
	onTick( 1, "ShowTime")

	@10,00 say "Type some stuff:" get cString0
	@11,00 say "Type some more :" get cString1
	read

   DevPos(13,00)
   qout()
   qout("For Loop Tests.  (Press any key to terminate each test)")
   qout("-------------------------------------------------------")

   qout("Inkey()    Test (NO WAIT-STATE)   ")
   nRow := row()
   nCol := col()
	for nCount := 20000 to 1 step -1
      DevPos( nRow, nCol)
      DevOut( nCount)
		nKey := Inkey()
		if ( nKey != 0 .and. nKey != nInt8Key)	// ignore hotkey
			exit
		endif
	next

   qout("HotInkey() Test (WAIT-STATE)      ")
   nRow := row()
   nCol := col()
	for nCount := 20000 to 1 step -1
      DevPos( nRow, nCol)
      DevOut( nCount)

		if ( HotInkey() != 0)
			exit
		endif
	next
   qout()

	onTick()

Return ( NIL)

Function ShowTime()
Local nRow, nCol, nCursor, cColor

	nCursor := setcursor( 0)
	cColor := setcolor("w/n")
	nRow := row()
	nCol := col()
	DevPos( 10,70)
	DevOut( time())
	setpos( nRow, nCol)
	setcolor( cColor)
	setcursor( nCursor)

Return ( NIL)


/*
** Inkey() replacement that is wait-state aware
**
*/
Function HotInkey( nSeconds)
Local nInkey, bHotKey

   While ( TRUE)
		if (( nInkey := if( nSeconds == NIL, inkey(), inkey( nSeconds))) != 0;
			.and. ( bHotKey := setkey( nInKey)) != NIL)
      	eval( bHotKey, procname(2), procline(2), "")
         loop
      endif
		exit
	enddo

Return ( nInKey)
#endif


/*
**	Void onTick( nTime, cUserFunc, [ nHotKey])
**
** Attach/UnAttach a Clipper function to the system time interrupt.
**
**	If the function was called with nTime and cUserFunc values attempt
**	to attach ( cUserFunc) to the system timer so that it is executed
** every nTime seconds.  The system timer is hit 18.2 times ( ticks)
** a second so nTime must be converted into ticks ( int( nTime * 18.2)).
** If ontick() is called without parameters and we have previously attached
** a function unattach it and restore the original int 8 interrupt
** vector.
**
** Arguments:
** nTime			= Time interval to call ( cUserFunc) expressed in seconds.
**	cUserFunc	= Name of Clipper function to execute every nTime seconds
** nHotKey     = Inkey value to be stuffed into the keyboard buffer
**
*/
Function onTick( nTime, cUserFunc, nHotKey)
Static lActive := FALSE

	nHotKey := if( valtype( nHotKey) != "N", 255, nHotKey)

	/*
	** If we have previously redirected the int 8 interrupt vector to our
	** own routine restore it to its original value.  Unlatch our error
	** handler
	*/  
	if ( lActive)
		setkey( nHotKey, NIL)
		C10ckSet( 0, 0)
		lActive := FALSE
	endif

	/*
	**	If the onTick() was called with nTime and cUserFunc values attempt
	**	to attach ( cUserFunc) to the system timer.  Do the following:
	**
	** 1.  Ensure that ( cUserFunc) has been linked in.
	** 2.  Compile cUserFunc into code block bFunction in order to
	**     cut down runtime overhead.
	** 3.  Convert nTime into timer ticks and call the C C10ckSet() function.
	**	4.  Set the lActive flag true.
	*/
	if ( nTime != NIL .and. cUserFunc != NIL)
		if !( type( alltrim( cUserFunc)+"()") == "U")
			bFunction := &("{||" + cUserFunc + "()}")
			setkey( nHotKey, bFunction)
			C10ckSet( int( nTime * 18.2), nHotKey)
			lActive := TRUE
		endif
	endif

Return ( NIL)



