// TMemory Objects use examples
// (C) Antonio Linares, 1993

#define H_B800  47104                 // Video Buffer address
#define H_0410   1040                 // Equipment List
#define H_0417   1047                 // Extended Shift Status
#define H_F000  61440                 // Rom Bios Date Segment
#define H_FFF5  65525                 // Rom Bios Date Offset

//----------------------------------------------------------------------------//

function Main()

   local oMem := TMemory()

   oMem:nSegment = H_B800             // Let's manage the Video Buffer

   SET COLOR TO "W+/B"
   CLS

   @ 0, 0 SAY "This is the Video Buffer"

   oMem:nByte = 33                    // Changing the buffer video !
   oMem:nOffset++
   oMem:nByte = 46                    // Changing Colors!
   oMem:nOffset--

   Alert( oMem:cGetString( 20 ) )     // Taking a string from Video!

   oMem:nSegment = 0                  // Let's go to the equipment list!
   oMem:nOffset  = H_0410             // Have a look at Peter Norton's
                                      // MsDos programmers guide book

   ?
   ? If( oMem:lIsBit( 14 ), "Modem!", "No modem" )

   ? If( oMem:lIsBit( 10 ), 1, 0 ) + ;
     If( oMem:lIsBit( 11 ), 2, 0 ) + ;
     If( oMem:lIsBit( 12 ), 4, 0 )
   ?? " RS232 ports"

   ? If( oMem:lIsBit( 2 ), "Yes, Math Copro", "Sorry, no Math Copro" )

   oMem:nOffset += 3                  // Base memory Size
   ? "Memory Size is... "
   ?? oMem:nWord

   oMem:nSegment = 0                  // I am going to change the ligths
   oMem:nOffset  = H_0417             // of your keyboard...

   oMem:SetBit( 5, .t. )              // Scroll Lock on !
   oMem:SetBit( 6, .t. )              // Num    Lock on !
   oMem:SetBit( 7, .t. )              // Caps   Lock on !
   ?
   ? "Look at the lights of your keyboard..."

   oMem:nSegment = H_F000             // Let's look at the Date of your Rom Bios
   oMem:nOffset  = H_FFF5

   ?
   ? "The Date of your Rom Bios is " + oMem:cGetString( 8 )

   ?
   ?
   ? "Use TMemory Objects with care, they are very powerfull"
   ? "You must know exactly what you are doing"
   ?
   ? "Enjoy!"

   InKey( 0 )

return

//----------------------------------------------------------------------------//
