/***
*  VR.prg
*  Demostration of READ VALID ... user READ Layer
*/

#include "Validrd.ch"

MEMVAR GetList

PROCEDURE Main()
   LOCAL cVar1, cVar2, cVar3

   cVar1 := cVar2 := cVar3 := SPACE(20)

   CLS

   @ 10, 10 SAY "Variable 1" GET cVar1
   @ 11, 10 SAY "Variable 2" GET cVar2
   @ 12, 10 SAY "Variable 3" GET cVar3

   // The following command is equivalent to:
   //
   //   READ VALID (! EMPTY(cVar1)) .AND. (! EMPTY(cVar2)) .AND. ;
   //      (! EMPTY(cVar3))
   //
   READ VALID {|aGets, lUpdated| NoneEmpty(aGets, lUpdated)}

   RETURN

/***
*  NoneEmpty()
*  Return .T. if none of the Gets are empty
*/
STATIC FUNCTION NoneEmpty( aGets, lUpdated )
   LOCAL nGet
   
   // See if there are any empty Gets
   nGet := ASCAN( aGets, {|oGet| EMPTY(oGet:varGet())} )

   // nGet will equal 0 if there were no empty Gets
   RETURN (nGet == 0)
