/***
*  ValidRd.prg
*  Implements READ VALID ...
*
*	Copyright (c) 1990, 1991 Nantucket Corp.  All rights reserved.
*
*	NOTE: compile with /m/n/w
*/

#include "Set.ch"
#include "Inkey.ch"
#include "Getexit.ch"

#define K_UNDO         K_CTRL_U


// state variables for active READ
STATIC BumpTop
STATIC BumpBot
STATIC LastExit
STATIC LastPos
STATIC ActiveGet
STATIC ReadProcName
STATIC ReadProcLine


// format of array used to preserve state variables
#define GSV_KILLREAD     1
#define GSV_BUMPTOP      2
#define GSV_BUMPBOT      3
#define GSV_LASTEXIT     4
#define GSV_LASTPOS      5
#define GSV_ACTIVEGET    6
#define GSV_READVAR      7
#define GSV_READPROCNAME 8
#define GSV_READPROCLINE 9

#define GSV_COUNT        9

/*************************
*
*   READ VALID ..
*
*/

/***
*	ReadValid()
*	Read until condition is true
*/
FUNCTION ReadValid( aGetList, bValid )
	LOCAL oGet
	LOCAL nPos, nLastPos
	LOCAL aSavedGetSysVars

	IF (VALTYPE(READFORMAT()) == "B")
		EVAL(READFORMAT())
	ENDIF

	IF (EMPTY(aGetList))
		// S87 compat.
		SETPOS(MAXROW() - 1, 0)
		RETURN (.F.) // NOTE
	ENDIF

	// preserve state vars
	aSavedGetSysVars := ClearGetSysVars()

	// set these for use in SET KEYs
	ReadProcName := PROCNAME(1)
	ReadProcLine := PROCLINE(1)

	// set initial GET to be read
	nPos := Settle(aGetList, 0)

	DO WHILE (nPos <> 0)

		// get next GET from list and post it as the active GET
		oGet := aGetList[nPos]
		PostActiveGet(oGet)

		// read the GET
		IF (VALTYPE(oGet:reader) == "B")
			EVAL(oGet:reader, oGet) // use custom reader block
		ELSE
			GetReader(oGet) // use standard reader
		ENDIF

      // save current position
      nLastPos := nPos

		// move to next GET based on exit condition
		nPos := Settle(aGetList, nPos)

      // if I am about to exit, check to see if VALID
      // condition is true
      IF (nPos == 0)
         // VALID clause is passed current GetList and
         // whether or not the READ has been changed
         //
         IF (! EVAL(bValid, aGetList, UPDATED()))
            // If it isn't valid, we ain't going nowhere
            //
            nPos := nLastPos
         ENDIF
      ENDIF
	ENDDO

	// restore state vars
	RestoreGetSysVars(aSavedGetSysVars)

	// S87 compat.
	SETPOS(MAXROW() - 1, 0)

	RETURN (UPDATED())



/**************************
*
*	READ services
*
*/



/***
*	Settle()
*
*	Returns new position in array of Get objects, based on
*
*		- current position
*		- exitState of Get object at current position
*
*	NOTE return value of 0 indicates termination of READ
*	NOTE exitState of old Get is transferred to new Get
*/
STATIC FUNCTION Settle( GetList, pos )

	LOCAL exitState


	IF (pos == 0)
		exitState := GE_DOWN
	ELSE
		exitState := GetList[pos]:exitState
	ENDIF


	IF (exitState == GE_ESCAPE .OR. exitState == GE_WRITE)
		RETURN (0) // NOTE
	ENDIF


	IF (exitState <> GE_WHEN)
		// reset state info
		LastPos := pos
		BumpTop := .F.
		BumpBot := .F.

	ELSE
		// re-use last exitState, do not disturb state info
		exitState := LastExit

	ENDIF


	/***
	*	move
	*/
	DO CASE
	CASE (exitState == GE_UP)
		pos --

	CASE (exitState == GE_DOWN)
		pos ++

	CASE (exitState == GE_TOP)
		pos := 1
		BumpTop := .T.
		exitState := GE_DOWN

	CASE (exitState == GE_BOTTOM)
		pos := LEN(GetList)
		BumpBot := .T.
		exitState := GE_UP

	CASE (exitState == GE_ENTER)
		pos ++

	ENDCASE


	/***
	*	bounce
	*/
  // bumped top
	IF (pos == 0)

		IF (! READEXIT() .AND. ! BumpBot)
			BumpTop := .T.
			pos := LastPos
			exitState := GE_DOWN
		ENDIF

	ELSEIF (pos == LEN(GetList) + 1) // bumped bottom

		IF (! READEXIT() .AND. exitState <> GE_ENTER .AND. ! BumpTop)
			BumpBot := .T.
			pos := LastPos
			exitState := GE_UP
		ELSE
			pos := 0
		ENDIF
	ENDIF


	// record exit state
	LastExit := exitState

	IF (pos <> 0)
		GetList[pos]:exitState := exitState
	ENDIF

	RETURN (pos)



/***
*	PostActiveGet()
*	Post active GET for ReadVar(), GetActive().
*/
STATIC PROCEDURE PostActiveGet( get )

	GETACTIVE(get)
	READVAR(GetReadVar(get))

	ShowScoreBoard()

	RETURN



/***
*	ClearGetSysVars()
*	Save and clear READ state variables. Return array of saved values.
*
*	NOTE: 'Updated' status is cleared but not saved (S87 compat.).
*/
STATIC FUNCTION ClearGetSysVars()

	LOCAL saved[GSV_COUNT]


	saved[GSV_KILLREAD] := ReadKill()
	ReadKill(.F.)

	saved[GSV_BUMPTOP] := BumpTop
	BumpTop := .F.

	saved[GSV_BUMPBOT] := BumpBot
	BumpBot := .F.

	saved[GSV_LASTEXIT] := LastExit
	LastExit := 0

	saved[GSV_LASTPOS] := LastPos
	LastPos := 0

	saved[GSV_ACTIVEGET] := GETACTIVE(NIL)

	saved[GSV_READVAR] := READVAR("")

	saved[GSV_READPROCNAME] := ReadProcName
	ReadProcName := ""

	saved[GSV_READPROCLINE] := ReadProcLine
	ReadProcLine := 0

	ReadUpdated(.F.)

	RETURN (saved)



/***
*   RestoreGetSysVars()
*	Restore READ state variables from array of saved values.
*
*	NOTE: 'Updated' status is not restored (S87 compat.).
*/
STATIC PROCEDURE RestoreGetSysVars( saved )

	ReadKill(saved[GSV_KILLREAD])

	BumpTop := saved[GSV_BUMPTOP]

	BumpBot := saved[GSV_BUMPBOT]

	LastExit := saved[GSV_LASTEXIT]

	LastPos := saved[GSV_LASTPOS]

	GETACTIVE(saved[GSV_ACTIVEGET])

	READVAR(saved[GSV_READVAR])

	ReadProcName := saved[GSV_READPROCNAME]

	ReadProcLine := saved[GSV_READPROCLINE]

	RETURN



/***
*	GetReadVar()
*	Set READVAR() value from a GET.
*/
STATIC FUNCTION GetReadVar( get )
	LOCAL name := UPPER(get:name)
	LOCAL i

	/***
	*	The following code includes subscripts in the name returned by
	*	this function, if the get variable is an array element.
	*
	*	Subscripts are retrieved from the get:subscript instance variable.
	*
	*	NOTE: incompatible with Summer 87
	*/

	IF (get:subscript <> NIL)
		FOR i := 1 TO LEN(get:subscript)
			name += "[" + LTRIM(STR(get:subscript[i])) + "]"
		NEXT
	ENDIF

	RETURN (name)


/**********************************
*
*	wacky compatibility services
*
*/


// display coordinates for SCOREBOARD
#define SCORE_ROW      0
#define SCORE_COL      60


/***
*   ShowScoreboard()
*/
STATIC PROCEDURE ShowScoreboard()

	LOCAL nRow, nCol


	IF (SET(_SET_SCOREBOARD))
		nRow := ROW()
		nCol := COL()

		SETPOS(SCORE_ROW, SCORE_COL)
		DISPOUT(IF(SET(_SET_INSERT), "Ins", "   "))
		SETPOS(nRow, nCol)
	ENDIF

	RETURN



/***
*	DateMsg()
*/
STATIC PROCEDURE DateMsg()

	LOCAL nRow, nCol


	IF (SET(_SET_SCOREBOARD))
		nRow := ROW()
		nCol := COL()

		SETPOS(SCORE_ROW, SCORE_COL)
		DISPOUT("Invalid Date")
		SETPOS(nRow, nCol)

		DO WHILE (NEXTKEY() == 0)
		ENDDO

		SETPOS(SCORE_ROW, SCORE_COL)
		DISPOUT("            ")
		SETPOS(nRow, nCol)

	ENDIF

	RETURN

