/***
*  The Data Entry Torment v2.0
*
*/

#define T_CYCLEON   5  // How often?

STATIC nCycle := 1
STATIC saColors
STATIC scBackColor
STATIC slDisabled := .F.

/***
*  TormentOff()
*  Turn off tormentor
*
*/
PROCEDURE TormentOff()
   slDisabled := .T.
   RETURN

/***
*  TormentCycle()
*  Increment cycle count
*
*/
PROCEDURE TormentCycle()
   nCycle++
   RETURN

/***
*  TormentColors( <aColors>, <cBackColor> )
*  Set colors for Tormentor to use
*     <aColors>    - Array of color pairs to cycle through
*     <cBackColor> - Background color (so Gets can be erased)
*/
PROCEDURE TormentColors( aColors, cBackColor )
   saColors := aColors
   scBackColor := cBackColor
   RETURN

/***
*  Torment( @<aGets>, <aColors>, <cBackColor> ) --> .T.
*  Routine to generally cause havoc with data entry
*
*/
FUNCTION Torment( aGets, aColors, cBackColor )
   STATIC lMoved
   STATIC lShouldMove := .F.
   STATIC nLastColor

   IF slDisabled
      RETURN .T.   // NOTE
   ENDIF
   
   // Determine if it is time to activate
   IF (nCycle >= T_CYCLEON)
      // Initialize all variables and set nCycle
      // to zero to activate The Tormentor
      nCycle := 0
      lMoved := .F.
      lShouldMove := ! lShouldMove
      nLastColor := 1
   ENDIF

   // Do tormenting
   IF (nCycle == 0)
      // Buffer screen for instaneous update
      DISPBEGIN()

      IF lShouldMove
         MoveAndErase( aGets, cBackColor, IF(lMoved, -1, 1) )
         lMoved := ! lMoved
      ELSE
         IF nLastColor > LEN(saColors)
            nLastColor := 1
         ENDIF
         ColorGets( aGets, saColors[nLastColor++] )
      ENDIF

      DISPEND()
   ENDIF

   RETURN (.T.)

/***
*  MoveAndErase()
*  Erase gets then move 'em
*
*/
STATIC PROCEDURE MoveAndErase( aGets, cBackColor, nMoveBy )
   LOCAL nGet
   LOCAL nLen := LEN(aGets)
   LOCAL lHasFocus
   LOCAL nBuffLen

   // Erase current gets
   FOR nGet := 1 TO nLen
      // Save focus
      lHasFocus := aGets[nGet]:hasFocus 

      // Set focus so I can find out buffer length (get width)
      aGets[nGet]:setFocus()
      nBuffLen := LEN(aGets[nGet]:buffer)

      // Restore focus
      IF !lHasFocus
         aGets[nGet]:killFocus()
      ENDIF

      // Blank out current get
      @ aGets[nGet]:row,aGets[nGet]:col SAY SPACE(nBuffLen);
         COLOR cBackColor
   NEXT

   // Move 'em
   MoveGets( aGets, 0, nMoveBy )
   RETURN
