/***
*  SetKey.prg
*  Demonstrate the changing of a Get through a SET KEY via
*  GetActive() and direct manipulation of the get object
*
*/

#include "Inkey.ch"

PROCEDURE Main()
   LOCAL cVar1, cVar2, cVar3
   LOCAL GetList := {}

   cVar1 := cVar2 := cVar3 := SPACE(30)

   SET KEY K_CTRL_K TO GetCapFirst

   CLS
   @ 3,0 SAY PADC("SET KEY Modification of a GET Demo", MAXCOL())
   @ 4,0 SAY PADC("(Type Ctrl-K to convert to proper case)", MAXCOL())

   @ 7,0 SAY "Variable 1" GET cVar1
   @ 8,0 SAY "Variable 2" GET cVar2
   @ 9,0 SAY "Variable 3" GET cVar3

   READ

   SET KEY 11 TO

   RETURN

/***
*  GetCapFirst()
*  Capitalize the first letter of every word
*
*/
STATIC PROCEDURE GetCapFirst()
   LOCAL oGet, cString

   // Grab the current get object
   oGet := GetActive()

   // Get the current value of the Get
   cString := oGet:varGet()

   IF VALTYPE(cString) == "C"

      // Convert and put the value back
      oGet:varPut(Proper(cString))
   ENDIF

   RETURN
