/***
*  Help.prg
*  Sample help system that uses help text stored
*  in the Get objects
*
*/

/***
*  Help()
*  The system automatically assigns the F1 key to this
*  procedure which will return help from wherever you are
*  at.
*
*/
PROCEDURE Help( cProc, nLine, cVar )
   LOCAL oGet
   LOCAL cMsg := "No help available from here"

   IF (oGet := GetActive()) != NIL
      IF VALTYPE(oGet:cargo) == "A"

         // Retrieve help text from Get:cargo dictionary
         // In a more "robust" version of this system, some sort
         // of index into a help file would be stored rather than
         // the help text itself.  This would allow easier editing
         // of the help text and allow runtime modification of it.
         //
         cMsg := DictAt(oGet:cargo, "Help Text")
      ENDIF
   ENDIF
   DispMsg(cMsg)

   RETURN
            
/***
*  DispMsg()
*  Display help text (";" = new line)
*
*/
STATIC PROCEDURE DispMsg( cMsg )
   LOCAL nLine
   LOCAL cScreen
   LOCAL nRow, nCol

   SAVE SCREEN TO cScreen
   nRow := ROW()
   nCol := COL()

   CLS
   @ 0, 0 SAY PADC(" Help Screen ", MAXCOL(), "-")

   // Convert semi-colons to CR/LF
   cMsg := STRTRAN( cMsg, ";", CHR(13) + CHR(10) )

   SETPOS(1, 0) 
   FOR nLine := 1 TO MLCOUNT(cMsg, MAXCOL())
      @ ROW()+1, 0 SAY MEMOLINE(cMsg, MAXCOL(), nLine)
   NEXT

   @ MAXROW()-1, 0 SAY PADC(" Press any key to continue ", MAXCOL(), "-")

   CLEAR TYPEAHEAD
   INKEY(0)

   RESTORE SCREEN FROM cScreen
   SETPOS(nRow, nCol)

   RETURN


