/***
*  DynPic.prg
*  Demonstrate the ability to change the picture clause
*  dynamically
*
*/
PROCEDURE Main()
   LOCAL GetList := {}
   LOCAL cName   := SPACE(20)
   LOCAL cIDType := "I"
   LOCAL cSSNo   := SPACE(9)

   SET CONFIRM ON
   SET SCOREBOARD OFF

   CLS
   @ 3,0 SAY PADC( "Member Information" )

   @ 5,0 SAY "Name                   " GET cName
   @ 6,0 SAY "C)ompany or I)ndividual" GET cIDType PICTURE "!" ;
      VALID cIDType $ "CI"
   @ 7,0 SAY "SS# or Tax ID#         " GET cSSNo PICTURE StartPic(cIDType);
      WHEN {|oGet| ChangePic(oGet, cIDType)}

   READ

   RETURN

/***
*  StartPic()
*  Determine what the initial value for the picture should
*  be.
*
*/
STATIC FUNCTION StartPic( cIDType )
   LOCAL cPic

   IF cIDType == "C"
      cPic := "@R 99-99999-99"
   ELSE
      // Default value
      cPic := "@R 999-99-9999"
   ENDIF

   RETURN (cPic)


/***
*  ChangePic()
*  Change picture on the fly from SS# to Tax ID or 
*  vice versa (to be called from WHEN clause).
*
*/
STATIC FUNCTION ChangePic( oGet, cIDType )
   IF cIDType == "C"
      oGet:picture := "@R 99-99999-99"
   ELSE
      oGet:picture := "@R 999-99-9999"
   ENDIF
      
   RETURN (.T.)
