****
*	DateGet.prg
*
*	Compile with /m/n/w

#include "Getexit.ch"

/***
*	DateGetReader()
*
*	Replacement for GetReader(). Logic is identical, except
*	DateGetApplyKey() is used to process keystrokes.
*/
PROCEDURE DateGetReader( oGet )

   // read the GET if the WHEN condition is satisfied
   IF (GetPreValidate(oGet))

      // activate the GET for reading
      oGet:setFocus()

      DO WHILE (oGet:exitState == GE_NOEXIT)

         // check for initial typeout (no editable positions)
         IF (oGet:typeOut)
            oGet:exitState := GE_ENTER
         ENDIF

         // apply keystrokes until exit
         DO WHILE (oGet:exitState == GE_NOEXIT)
            DateGetApplyKey(oGet, INKEY(0))
         ENDDO

         // disallow exit if the VALID condition is not satisfied
         IF (! GetPostValidate(oGet))
            oGet:exitState := GE_NOEXIT
         ENDIF
      ENDDO

      // de-activate the GET
      oGet:killFocus()
   ENDIF

   RETURN


/***
*	DateGetApplyKey()
*
*	Replacement for GetApplyKey(). Performs inc/dec on a date get for '+'
*	and '-' keys, standard behavior otherwise.
*/
STATIC PROCEDURE DateGetApplyKey( oGet, nKey )
   LOCAL cKey := CHR(nKey)

   DO CASE
   CASE (cKey == '+' .AND. oGet:type == 'D')
      oGet:buffer := TRANSFORM(oGet:unTransform() + 1, oGet:picture)
      oGet:changed := .T.
      oGet:display()

   CASE (cKey == '-' .AND. oGet:type == 'D')
      oGet:buffer := TRANSFORM(oGet:unTransform() - 1, oGet:picture)
      oGet:changed := .T.
      oGet:display()

   OTHERWISE
      GetApplyKey(oGet, nKey)

   ENDCASE

   RETURN
