/*
 Ŀ
   MODULE:  objectDB.ch                                    Version 1.01   
 Ĵ
   Copyright (c) 1992 Brian Marasca                                       
   All Rights Reserved.                                                   
 
*/

#include "odberr.ch"

/*****************************************************************************
   Manifest constants.
*****************************************************************************/

#ifndef TRUE
#define TRUE           .T.
#endif

#ifndef FALSE
#define FALSE          .F.
#endif

#define USER_ALREADY_EXISTS      -1
#define CANT_CREATE_RECORD       -2
#define MISSING_PARAMETERS       -3
#define NO_SUCH_USER             -4
#define CANT_DELETE_RECORD       -5

/*****************************************************************************
   Commands.
*****************************************************************************/

#xcommand SET ENCRYPTION KEY TO <(cKey)>                                     ;
       => odSetKey( <(cKey)> )

#xcommand DATA DEFINITION MODULE                                             ;
       => function objectDB

#xcommand END DATA DEFINITION MODULE                                         ;
       => return nil

#xcommand INITIALIZE OBJECTDB                                                ;
       => objectDB()

#xcommand DEFAULT <this> TO <that>                                           ;
       => iif( <this> == nil, <this> := <that>, )

#xcommand DEFINE DATABASE <db> [ON PATH <(path)>]                            ;
          [LOG PATH <(lpath)>]                                               ;
          [<sx: TEST STRUCTURE ON OPEN>]                                     ;
          [ON UPDATE <b>]                                                    ;
       => db():define( <"db">, <"path">, <"lpath">, <.sx.>, <b> )

#xcommand DEFINE TABLE <name> [ALIAS <alias>] [AS <oTab>] [DESC <(ds)>]      ;  
       => [<oTab> :=] table():new( db(), <"name">, <"alias">, <(ds)> )

#xcommand END TABLE [<*x*>]                                                  ;
        =>

#xcommand COLUMN <c1> <t1: NUM, CHAR, DATE, LOG, VLF> [WIDTH <w1>]           ;
          [DECS <d1>] [DESC <(ds)>] [<nn: NOT NULL>]                         ; 
       => column():new( db():toptab(), <"c1">, <"t1">, <w1>, <d1>,           ;
          <(ds)>, <.nn.> )

#xcommand COLUMN <c> NUM ( <w>, <d> ) [DESC <(ds)>] [<nn: NOT NULL>]         ;
       => column():new( db():toptab(), <"c">, "N", <w>, <d>, <(ds)>, <.nn.> )

#xcommand COLUMN <c> CHAR ( <w> ) [DESC <(ds)>] [<nn: NOT NULL>]             ;
       => column():new( db():toptab(), <"c">, "C", <w>,, <(ds)>, <.nn.> )

#xcommand PRIMARY KEY <plist, ...> [ALIAS <pka>] [<cs: CASE SENSITIVE>]      ;
       => index():new( db():toptab(), <"pka">, {<"plist">}, ,<.cs.>, .T. )

#xcommand DEFINE [<u: UNIQUE>] [<cs: CASE SENSITIVE>] INDEX <i> ON <*x*>     ;
       => index():new( db():toptab(), <"i">, {Q_W1 <x>}, {Q_W2 <x>}, <.cs.>, ;
          .F., <.u.> )

#xcommand FOREIGN KEY <fk, ...> REFERENCES TABLE <ref>                       ;
          [<u: CASCADE, NULLIFY, RESTRICT> UPDATES]                          ;
          [<d: CASCADE, NULLIFY, RESTRICT> DELETES]                          ;
          [<i: USE INDEX> [<ia>]]                                            ;
       => rule():new(db():table(<"ref">),{<"fk">},db():toptab(),<"u">,<"d">, ;
          iif( <.i.>, index():new( db():toptab(), <"ia">, {<"fk">}, ,        ;
             db():table( <"ref"> ):primaryKey():lCaseSens, .F.),) )

#xcommand CONNECT DATABASE                                                   ;
       => db():open()

#xcommand DISCONNECT DATABASE                                                ;
       => db():close()

#xcommand CREATE CONTEXT <oCon> FOR TABLE <cTab>                             ;
          [USING INDEX <xI>]                                                 ;
          [<al: NOAUTOLOAD>]                                                 ;
          [CHILD OF <oParent> [ON <cols, ...> ] ]                            ;
       => <oCon> := context():new( db():table( <"cTab"> ), <"xI">, !<.al.> ) ;
       ;  <oCon>:childOf( <oParent>, { <"cols"> } )

#xcommand DESTROY CONTEXT <oCon>                                             ;
       => <oCon>:destroy()

#xcommand BEGIN TRANSACTION                                                  ;
       => db():begin()

#xcommand SAVE TRANSACTION <savepoint>                                       ;
       => db():save( <"savepoint"> )

#xcommand COMMIT TRANSACTION                                                 ;
       => db():commit()

#xcommand ROLLBACK [TRANSACTION] [TO <savepoint>]                            ;
       => db():rollback( <"savepoint"> )

/*****************************************************************************
   Operators and pseudofunctions.

   Q_W1 and Q_W2 with thanks to Chuck Friedel.
*****************************************************************************/

#xtranslate ..<field>           => :flds:<field>:value
#xtranslate ..<field> := <x>    => :flds:<field>:value := <x>
#xtranslate ..<field> IS NULL   => :flds:<field>:isNull
#xtranslate ..<field> == <x>    => :flds:<field>:value == <x>
#xtranslate ..<field> = <x>     => :flds:<field>:value = <x>
#xtranslate ..<field> + <x>     => :flds:<field>:value + <x>
#xtranslate ..<field> - <x>     => :flds:<field>:value - <x>
#xtranslate ..<field> .AND. <x> => :flds:<field>:value .AND. <x>
#xtranslate ..<field> .OR. <x>  => :flds:<field>:value .OR. <x>

#xtranslate  Q_W2 <v>      [,<list,...>]    =>  .F.   [,Q_W2 <list>]
#xtranslate  Q_W2 <v> DESC [,<list,...>]    =>  .T.   [,Q_W2 <list>]
#xtranslate  Q_W1 <v>      [,<list,...>]    =>  <"v"> [,Q_W1 <list>]
#xtranslate  Q_W1 <v> <x>  [,<list,...>]    =>  <"v"> [,Q_W1 <list>]

#xtranslate HELD(<c>, <n>) => db():tabLocked(<c>) .or. db():recLocked(<c>,<n>)
