** first
**
** returns the first atom of a list expression
**
FUNCTION first
PARAMETER input

	list = ALLTRIM(input)

	send = IIF( " " $ list, SUBSTR(list, 1, AT(" ",list)-1), list)

RETURN send

** butfirst
**
** returns all but the first atom of a list string expression
**
FUNCTION butfirst
PARAMETER input

	list = ALLTRIM(input)

	send = IIF( " " $ list, RIGHT(list, LEN(list) - AT(" ", list)), "")

RETURN ALLTRIM(send)

** tail
**
** returns the last atom of a list string expression
**
FUNCTION tail
PARAMETER input

	list = ALLTRIM(input)

	send = IIF( " " $ list, RIGHT(list, LEN(list)-RAT(" ", list)), list)

RETURN send

** item
**
** seeks <expN> atom in a list
**
FUNCTION item
PARAMETERS input,pick

	list = ALLTRIM(input)

	for i = 1 to pick - 1
		list = butfirst(list)
	next

RETURN ALLTRIM(first(list))

** atoms
**
** returns the number of atoms in a list
**
FUNCTION atoms
PARAMETER input

	list = ALLTRIM(input)

	cnt = 0

	DO WHILE .NOT. EMPTY(list)
		list = butfirst(list)
		cnt = cnt + 1
	ENDDO

RETURN cnt

** military
**
** takes a string variable of the form ##:##XX ie, 4:45pm, 5:30am
** and returns a string in military time, ie, 1675, 0550
**
FUNCTION military
PARAMETER t12

	t24 = ALLTRIM(STR(VAL(LEFT(t12,2)) + ;
			 IIF(RIGHT(t12,2) = "AM", 0, 12))) + ;
			 PADL(ALLTRIM(STR((VAL(SUBSTR(t12,4,2)) / 60) * 100)), 2, "0")

	IF LEFT(t24,2) = "12"
		t24 = STUFF(t24,1,2,"24")
	ELSE
		IF LEFT(t24,2) = "24"
			t24 = STUFF(t24,1,2,"12")
		ENDIF
	ENDIF

RETURN VAL(t24)

** dbf_comp
**
** pops up a list of matching records based on spec and
** database name at a specified row and column,
** and returns the selection, if any
**
FUNCTION dbf_comp
PARAMETERS incomplete, row, col, database, field
PRIVATE incomplete, occurrances

	** save the key settings
	**
	f_10 = ON("KEY", "F10")
	ctrl_e = ON("KEY", "CTRL+E")

	** disable the key settings while we're in the popup
	**
	ON KEY LABEL F10
	ON KEY LABEL CTRL+E

	** if we're NOT USing the database, make it so.
	**
	IF NOT(USED(database))
		USE (database) IN SELECT(0)
	ENDIF

	** SELECT the database, save and set its index
	SELECT (database)
	m.save_ord = SET("ORDER")
	id_name = LEFT(database, 4) + "_id"
	SET ORDER TO TAG &id_name

	** TRIM and get the LENgth of the incomplete expression
	**
	inc_trim = ALLTRIM(incomplete)
	inc_len = LEN(inc_trim)


	** if an incomplete expression was typed, restrict the database
	** to those records which begin with that expression
	**
	IF !EMPTY(incomplete)

		SET FILTER TO LEFT(&database..&field, inc_len) = inc_trim
		COUNT FOR LEFT(&database..&field, inc_len) = inc_trim TO occurrances

	ELSE

		occurrances = RECCOUNT()

	ENDIF

	** if we have no matches (occurrances = 0)
	** >>	exit without activating the popup
	**
	** if we have only one match and we are completing
	** a partial entry ( i.e. incomplete is not empty,
	** if the user typed nothing, they probably are expecting
	** a popup, so we don't want to force a choice on them)
	** >>	complete it with the only possible completion
	**
	** Otherwise,
	** >>	activate the popup and process the selection, returning it
	**
	DO CASE
	CASE occurrances = 0

		WAIT WINDOW "No matches found: Press any key..."

	CASE occurrances = 1 && !EMPTY(incomplete)

		LOCATE FOR LEFT(&database..&field, inc_len) = inc_trim
 
		incomplete = &database..&field
		KEYBOARD "{ENTER+LITERAL}"

	CASE occurrances > 1

		DEFINE POPUP complete ;
			FROM row, col;
			PROMPT FIELD &database..&field

		ON SELECTION POPUP complete DEACTIVATE POPUP
		ACTIVATE POPUP complete
		RELEASE POPUP complete

		IF !EMPTY(PROMPT())

			incomplete = PADR(PROMPT(), 35)

			** add a cr to skip to the next field
			**
			KEYBOARD "{ENTER+LITERAL}"

		ENDIF

	ENDCASE

	** restore normality.
	**
	SET FILTER TO
	SET ORDER TO &save_ord

	ON KEY LABEL F10 &f_10
	ON KEY LABEL CTRL+E &ctrl_e

RETURN incomplete


** add_to_dbf
**
** Queries user and adds a new record by calling save_new
**
FUNCTION add_to_dbf
PARAMETERS database, field, value
PRIVATE database, field, response, m.id, value

	response = alert("Not in database. Add? (Y)es/(N)o")
	IF response = "Yes"

		DO save_new WITH database, database + "." + field, value

	ELSE
		
		RETURN SPACE(LEN(value))
			
	ENDIF

RETURN value


** save_new
**
** Inserts a new record in a database
**
PROCEDURE save_new
PARAMETERS database, field, value
PRIVATE database, field, new_id, a_name, value

	a_name = "a_" + database
	id = LEFT(database, 4) + "_id"

	IF !EMPTY(value)			&& if a value was entered
			
		m.&id = new_id(database)

		** make sure the record doesn't already exist
		**
		SELECT (database)
		LOCATE FOR UPPER(&field) = UPPER(value)
		IF FOUND()
		
			WAIT WINDOW "That record already exists. Press any key..."
			RETURN
		
		ELSE
	
			**
			** change it in the dbf
			**
			APPEND BLANK
			GATHER MEMVAR MEMO

		ENDIF

	ENDIF

RETURN


** new_id
**
** generates a unique id for a new record. Also recycles ids which
** have been deleted
**
FUNCTION new_id
PARAMETERS database
PRIVATE id_name, database, n_id, id_assigned, iteration, id
EXTERNAL ARRAY n_id

	** VERY IMPORTANT
	**
	** The primary key id field must be named along this convention:
	**
	**		the first 4 letters of the dbf name + "_id"
	**
	**	i.e.:
	**		SELECT customer
	**		id_name = cust_id
	**
	** Also, there must be an index tag with the same name and of course,
	** index criterion.
	**
	SELECT (database)
	id_name = LEFT(database, 4) + "_id"

	
	IF RECCOUNT() = 0
	
		**
		** If nothing's in the database yet, or the
		** database was emptied by PACK, just
		** use 1 for the lognumber
		**
		m.id = 1
	
	ELSE
			
		**
		** get the highest id and
		** store it in an array, n_id[]
		**
		SELECT MAX(&database..&id_name) ;
			FROM (database) ;
			INTO ARRAY n_id ;

		**
		** loop through all possible ids
		** and if an unused id is found,
		** use it. Otherwise, use n_id[1] + 1
		**
		
		SELECT (database)
		m.save_order = SET("ORDER")
		SET ORDER TO &id_name
		
		iteration = 1
		id_assigned = .f.
		DO WHILE iteration < n_id[1]

			**
			** see if iteration's in use
			**
			SEEK iteration
			IF !FOUND()
		
				**
				** if not, use it, flag log_assigned, and EXIT
				**
				m.id = iteration
				id_assigned = .t.
				EXIT
			
			ELSE
			
				iteration = iteration + 1
				
			ENDIF
		
		ENDDO
		SET ORDER TO &save_order

		IF NOT id_assigned
	
			**
			** use the highest id + 1
			**
			m.id = n_id[1] + 1
	
		ENDIF
	
	ENDIF		

RETURN m.id


** alert
**
** Saves on spr overhead by using wait window to mimic
** a dialogue box.
**
** VARIABLES:
**		message:	message text
**
**		btns:		A list of "buttons" derived from 
**					the message parameter.
**
**		cmp_str:	A string derived from button hot
**					keys which is used to compare
**					user keypresses, consists of the 
**					first letters of each option.
**
**		opts[]:		An array containing the text of all 
**					the possible "button" responses.
**
**		opts_index:	A value which indexes to selected
**					options within opts[].
**
**		cnt:		The count of the number of "buttons".
**
**		yesNo:		The variable that the response
**					goes into.
**
**		loop:		Control variable.
**
**		character:	First letter of a button, used to 
**					compare final single character input 
**					with possible "buttons".
**
**		curr_wind:	The name of the current window at the 
**					time alert was called.
**
**		msg_len:	LENgth of the message variable.
**
**		msg_offset:	Number of screen columns minus the
**					combined sum of the wait_offset and
**					msg_len.
**
**		p_char:		Current prompt character determined
**					as we generate possible prompts and
**					first characters.
**
**		underChar:	The three characters under and 
**					adjacent to the	mouse pointer.
**
**		str_pos:	The position within the string
**					pointed to by the mouse pointer.
**
**		wait_offset:The 3 character offset from left edge 
**					of screen for WAIT WINDOW plus the 1
**					border character and 1 space padding
**					character.
**

FUNCTION alert
PARAMETERS message
	delimiter = "/"
	cmp_str = ""
	msg_len = LEN(message)
	wait_offset = 5
	msg_offset = SCOLS() - (wait_offset + msg_len + 1)
	IF !( "(" $ message)
	
		** no left parentheses = no "buttons"
		**
		btns = ""
		
	ELSE
	
		** get all text from the right of the "(" on
		**
		btns = RTRIM(RIGHT(message, msg_len - ;
				AT("(", message) + 1))

	ENDIF	
	
	** if no buttons, then we use ourself to
	** inform the user of the correct syntax
	**
	IF EMPTY(btns)
	
		** we use a character '[' to get a '('
		** and a ']' to get a ')'
		** without confusing alert.prg
		**
		DO alert WITH ;
			'USAGE: x=alert["Text [O]pt1/O[p]t2"] (O)kay'
		RETURN
		
	ENDIF
	
	** count and save options and first letters
	**
	cnt = 1
	DIMENSION opts[cnt]

	DO WHILE .t.

		** Get the first letter of the option in
		** UPPER() case
		**
		p_char = SUBSTR(btns, AT("(", btns) + 1, 1)
		cmp_str = cmp_str + UPPER(p_char)

		** using delimiter as a delimiter, get the
		** first atom of the list expression btns
		** and put it into opts[cnt]
		** Then, get the butfirst atoms of the list
		** expression btns and put it back into btns
		**
		IF delimiter $ btns

			delim = AT(delimiter, btns)
			opts[cnt] = SUBSTR(btns, 1, delim - 1)
			btns = RIGHT(btns, LEN(btns) - delim)

		ELSE

			opts[cnt] = btns
			btns = ""

		ENDIF

		** strip parentheses from the option
		**
		opts[cnt] = CHRTRAN(opts[cnt], "()", "")

		** check to see if we have anything left
		**
		IF EMPTY(btns)

			** leave the loop
			**	
			EXIT

		ELSE

			** otherwise, increment the counter, and 
			** enlarge the array
			**
			cnt = cnt + 1
			DIMENSION opts[cnt]

		ENDIF	

	ENDDO			

	** WAIT FOR USER INPUT
	**

	** set the input variable
	** and wait until it gets something in the
	** string of first letters
	**
	yesNo = ""
	DO WHILE !(UPPER(yesNo) $ cmp_str)	
	
		** get the user input
		**
		WAIT WINDOW CHRTRAN(message, "[]", "()") TO yesNo
		
		** check for a mouse click and
		** find the position within the string where
		** mouse was clicked
		** 
		str_pos = MCOL("") - msg_offset
		
		** if it's at the second column
		**
		IF MROW("") = 2 AND str_pos > 1
			
			** find the three characters under the mouse
			**
			underChar = SUBSTR(message, str_pos - 1, 3)
			
			** if there's a "("
			**
			IF "(" $ underChar AND AT("(", underchar) < 3
			
				** check to the right of the "("
				**
				yesNo = SUBSTR(underchar, ;
					AT("(", underChar) + 1, 1)
			
			ENDIF
				
			** if there's a ")"
			**
			IF ")" $ underChar AND AT(")", underchar) > 1
			
				** check to the left of the ")"
				**
				yesNo = SUBSTR(underchar, ;
					AT(")", underchar) - 1, 1)
			
			ENDIF

		ENDIF

	ENDDO

	** look into the cmp_str, which directly
	** corresponds to elements in opts[]
	opts_index = AT(UPPER(yesNo), cmp_str)

RETURN opts[opts_index]