;
;****************************************************************
;                                                               *
;        CLIPPER ROUTINE - RETURN NUMBER OF LOGICAL DRIVES      *
;                      By Kelly Mc Tiernan                      *
;                                                               *
;****************************************************************
;
;
;       This routine returns the number of logical drives available
;       on the machine in question. Call with 2 byte string, returns
;       ascii 2 digit value equal to the number of logical drives.
;       use VAL() to convert to numeric.
;
;       NDRV = "  "
;       CALL NUMDSK WITH NDRV
;       N = VAL(NDRV)
;
PUBLIC  numdsk
;
dos             EQU     21h             ; DOS interupt
seldsk          EQU     0Eh             ; select disk function
curdsk          EQU     19h             ; return currently selected disk
;
        _PROG SEGMENT BYTE
        ASSUME  CS:_PROG
;
numdsk  PROC    FAR
        push    bp                      ; standard setup, param's
        mov     bp,sp                   ;
        push    es                      ;
        cld                             ; assure direction
        les     di,dword ptr [bp + 6]   ; address of return string
        mov     ah,curdsk               ; get currently selected disk
        int     dos                     ;
        mov     dl,al                   ; reselect it to get number
        mov     ah,seldsk               ; of logical drives
        int     dos                     ;
        mov     ah,0                    ; for conversion to ascii string
        aam                             ; al -> (ascii) ax = aam + 3030h 
        add     ax,3030h                ;
        xchg    ah,al                   ; for stosw, i.e. - LB,HB reverse
        stosw                           ; return number of logical drives
        pop     es                      ; restore state
        pop     bp                      ;
        ret
numdsk  ENDP
_PROG   ENDS
        END
