// NTXDir
//
// Author : ShaunB..  (Shaun Botha [CI$ 70043,2641])
// Purpose: Emulate DOS's DIR command but with special handling for NTX files -
//          index expression for each NTX file
// Compile: Clipper NTXDIR /n/m/w
// Link   : Blinker / RTLink fi NTXDIR
// Notes  : This is 'fame-ware' - copy as much as you want, modify all you want,
//          distribute all you want.  Just include my name as the original
//          author.

#include "fileio.ch"
#include "directry.ch"

#define BLOCKSZ	512
#define EXPOFS		22
#define NULL		chr(0)


procedure main(cSpec, cSwitch)
	local aFiles, x
	local cBase, cExt, cSize, cDate, cTime, nTotSize
	local dLUpd, nRecs, lPaged, nRows, lAborted, cExpr

	// Fix our parameters
	if cSpec != nil
		cSpec := upper(cSpec)
	endif
	if cSwitch != nil
		cSwitch := upper(cSwitch)
	else
		cSwitch := ""
	endif

	// Determine whether display is to be paged
	lPaged := .f.
	if cSpec == "/P"
		lPaged := .t.
		cSpec := ""
		cSwitch := ""
	endif
	if cSwitch == "/P"
		lPaged := .t.
	endif

	// Default to "*.*"
	if empty(cSpec)
		cSpec := "*.*"
	endif

	// Just some blurb
	? "NTXDIR v1.0 (c) 1993 ShaunB.."
	?

	if cSpec == "/?"
		? "Displays a directory similar to that of DOS's DIR command.  In addition"
		? "the program will display the index expression of Clipper NTX files."
		?
		? "Note: This program does not support path names in NTX files (yet)."
		?
		? "usage: NTXDIR [file_spec] [/P]"
		?
		quit
	endif

	?


	lAborted := .f.
	aFiles := directory(cSpec, "HSD")      // Get all files
	nRows    := 0                          // Initialize row count for pages

	// Figure total size of files
	nTotSize := 0
	aeval(aFiles, {|f| nTotSize += f[F_SIZE] })

	for x := 1 to len(aFiles)
		if inkey() == 27
			lAborted := .t.
			exit
		endif

		nRows++
		cBase := cExt := ""                 // Init these vars

		// Treat directories differently to 'normal' files
		if at("D", aFiles[x, F_ATTR]) != 0
			cSize := padr("<DIR>", 8)
			cBase := aFiles[x, F_NAME]
		else
			if at(".", aFiles[x, F_NAME]) != 0
				cBase := left(aFiles[x, F_NAME], at(".", aFiles[x, F_NAME])-1)
				cExt  := substr(aFiles[x, F_NAME], at(".", aFiles[x, F_NAME])+1)
			else
				cBase := aFiles[x, F_NAME]
			endif
			cSize := ltrim(str(aFiles[x, F_SIZE]))
			cSize := padl(cSize, 8)
		endif

		// Get date and time - convert time to look like DOS
		cDate := dtoc(aFiles[x, F_DATE])
		cTime := left(aFiles[x, F_TIME], 5) + iif(val(left(aFiles[x, F_TIME], 2)) < 12, "a", "p")

		// Show the info
		if lPaged
			if nRows > maxRow()
				?? "Press any key to continue or [Esc] to quit"
				if inkey(0) == 27
					lAborted := .t.
					?
					exit
				endif
				?
				nRows := 0
			endif
		endif
		?? padr(cBase, 9), padr(cExt, 3), cSize, cDate, cTime

		// If this is a NTX file then show the index expression
		if at(".NTX", aFiles[x, F_NAME]) != 0
			// Show the expression - if it's longer than what's still available
			// on the screen show it on the next line
			cExpr := ntxExpr(aFiles[x, F_NAME])
			if len(cExpr) <= (maxCol() - col()-3)
				?? ".." + cExpr
			else
				? ".." + cExpr
				nRows++
			endif
		endif
		?
	next x

	// Show some summary info
	if lAborted
		? "*Process aborted*"
	endif
	? padl(ltrim(str(len(aFiles))), 10) + " file(s) " + padl(ltrim(str(nTotSize)),8) + " bytes used"
return


// Return the index expression for a NTX file
static function ntxExpr(cFile)
	local nHandle, cBuff, cExpr, x

	cExpr := "*Unknown*"
	cBuff := space(BLOCKSZ)

	// Open the file as READONLY, SHARED
	if (nHandle := fopen(cFile, FO_READ + FO_SHARED)) != -1
		// The expression starts at byte 22 in the file
		if fseek(nHandle, EXPOFS, FS_SET) == EXPOFS
			// Read a block big enough to accomodate the index expression
			if fread(nHandle, @cBuff, BLOCKSZ) == BLOCKSZ
				// The expression is terminated by a NULL character
				cExpr := left(cBuff, at(NULL, cBuff)-1)
			else
				cExpr := "Read error in NTX file"
			endif
		else
			cExpr := "Seek error in NTX file"
		endif

		// Close the file
		fclose(nHandle)
	else
		cExpr := "Could not open NTX file"
	endif
return cExpr
