*** Simplex Minimization Module ***
*
*   Copyright 1992 by Noroton River Software
*
*   Peter H. Vanderwaart
*   29 Friar Tuck Lane
*   Stamford, CT 06907
*
*   (203) 322-4721
***********************************

#define TRUE        .T.
#define FALSE       .F.

FUNCTION NRS_min(bError, aLocus, aStep, aStop)
LOCAL nProbDim, nSimpDim, aSimplex, aValue, aCentroid, aReflect, aExpand
LOCAL aContract, aScale, nLow, nHigh, S_flag, nPass, nFract, nCoFract
LOCAL nIdx, nJdx, aStopMult, nStopStep
LOCAL nAlpha := 1.9985, nCoAlpha := .9985
LOCAL nBeta := 1.95, nCoBeta := 0.95
LOCAL nGamma := .5015, nCoGamma := .4985
LOCAL nReflVal, nExpnVal, nContVal, nScalVal

nProbDim := LEN(aLocus)
nSimpDim := nProbDim + 1
aSimplex := ARRAY(nSimpDim)
aValue   := ARRAY(nSimpDim)
aCentroid:= ARRAY(nProbDim)
aReflect := ARRAY(nProbDim)
aExpand  := ARRAY(nProbDim)
aContract:= ARRAY(nProbDim)
aScale   := ARRAY(nProbDim)
aStopMult:= ARRAY(nProbDim)

FOR nIdx = 1 TO nSimpDim
   aSimplex[nIdx] := ACLONE(aLocus)
NEXT

nJdx := 1
IF aStep == NIL
   FOR nIdx = 2 TO nSimpDim
      aSimplex[nIdx][nJdx] := 1.1 * aSimplex[nIdx][nJdx]
      nJdx++
   NEXT
ELSE
   FOR nIdx = 2 TO nSimpDim
      aSimplex[nIdx][nJdx] := aSimplex[nIdx][nJdx] + aStep[nJdx]
      nJdx++
   NEXT
ENDIF

IF aStop == NIL
   FOR nJdx = 1 TO nProbDim
      aStopMult[nJdx] := 1.0
   NEXT
ELSE
   FOR nJdx = 1 TO nProbDim
      aStopMult[nJdx] := 1.0 / IIF(aStop[nJdx] == 0, 1, aStop[nJdx])
   NEXT
ENDIF

nIdx := 1
AEVAL(aSimplex,{ | x | aValue[nIdx] := EVAL(bError, x) , nIdx++ } )

DO WHILE TRUE

   nHigh := nLow := nIdx := 1
   FOR nIdx := 2 TO nSimpDim
      IF  aValue[nIdx] < aValue[nLow] ; nLow := nIdx
      ELSEIF  aValue[nIdx] > aValue[nHigh] ; nHigh := nIdx ; ENDIF
   NEXT

   nStopStep := 0
   FOR nJdx = 1 TO nProbDim
      nStopStep += aStopMult[nJdx];
                 * ABS(aSimplex[nHigh][nJdx] - aSimplex[nLow][njdx])
   NEXT
   IF nStopStep < 1 ; EXIT ; ENDIF

   // Calculate Centroid
   FOR nJdx = 1 TO nProbDim
      aCentroid[nJdx] := -aSimplex[nHigh][nJdx]
      FOR nIdx = 1 TO nSimpDim
         aCentroid[nJdx] += aSimplex[nIdx][nJdx]
      NEXT
      aCentroid[nJdx] /= nProbDim
   NEXT

   // Reflection
   FOR nJdx = 1 TO nProbDim
      aReflect[nJdx] := nAlpha * aCentroid[nJdx]  ;
                      - nCoAlpha * aSimplex[nHigh][nJdx]
   NEXT
   nReflVal := EVAL(bError,aReflect)

   IF nReflVal < aValue[nLow]

      // Expansion
      FOR nJdx = 1 TO nProbDim
         aExpand[nJdx] := nBeta * aReflect[nJdx]  ;
                        - nCoBeta * aCentroid[nJdx]

      NEXT
      nExpnVal := EVAL(bError,aExpand)
      IF nExpnVal < nReflVal
         aSimplex[nHigh] := ACLONE(aExpand)
         aValue[nHigh] :=nExpnVal
      ELSE
         aSimplex[nHigh] := ACLONE(aReflect)
         aValue[nHigh] :=nReflVal
      ENDIF
      LOOP

   ELSEIF nReflVal < aValue[nHigh]
     aSimplex[nHigh] := ACLONE(aReflect)
     aValue[nHigh] :=nReflVal
     LOOP
   ENDIF

  // Contraction
   FOR nJdx = 1 TO nProbDim
      aContract[nJdx] := nGamma * aCentroid[nJdx]  ;
                       + nCoGamma * aSimplex[nHigh][nJdx]
   NEXT
   nContVal := EVAL(bError,aContract)

   IF nContVal < aValue[nLow]

      // Expansion
      FOR nJdx = 1 TO nProbDim
         aExpand[nJdx] := nBeta * aContract[nJdx]  ;
                        - nCoBeta * aCentroid[nJdx]

      NEXT
      nExpnVal := EVAL(bError,aExpand)
      IF nExpnVal < nContVal
         aSimplex[nHigh] := ACLONE(aExpand)
         aValue[nHigh] :=nExpnVal
      ELSE
         aSimplex[nHigh] := ACLONE(aContract)
         aValue[nHigh] :=nContVal
      ENDIF
      LOOP

   ELSEIF nContVal < aValue[nHigh]
     aSimplex[nHigh] := ACLONE(aContract)
     aValue[nHigh] :=nContVal
     LOOP
   ENDIF

   // Scale Down - This section does not follow book.

  S_flag := FALSE
  nFract := -1.0
  FOR nPass = 1 TO 5
     nFract := -0.5 * nFract
     nCoFract := 1.0 - nFract
     FOR nIdx = 1 TO nSimpDim
        IF nIdx == nLow ; LOOP ; ENDIF
        FOR nJdx = 1 TO nProbDim
           aScale[nJdx] := nFract * aSimplex[nIdx][nJdx]  ;
                            + nCoFract * aSimplex[nLow][nJdx]
        NEXT
        nScalVal := EVAL(bError,aScale)

        IF nScalVal < aValue[nHigh]
          aSimplex[nHigh] := ACLONE(aScale)
          aValue[nHigh] :=nScalVal
          S_flag := TRUE
          EXIT
        ENDIF
     NEXT
     IF S_flag ; EXIT ; ENDIF
  NEXT
  IF .NOT. S_flag ; EXIT ; ENDIF


ENDDO
RETURN aSimplex[nLow]

