

bFtn := {|z| 100.0*(z[1]^2 - z[2])^2 + (1.0 - z[1])^2}
aLoc := { -1.2, 1 }
aStp := { 0.1, 0.1}
aCri := {0.0001, 0.0001}
a := NRS_min(bFtn, aLoc, , aCri)

?str(a[1],20,10)
?str(a[2],20,10)


bFtn := { |z| Fcstxmpl(z[1], z[2], z[3]) }
aLoc := { 0.25, 0.25, 0.5}
aStp := { 0.05, 0.05, 0.05 }
aCri := {0.005, 0.005, 0.005}

a := NRS_min(bFtn, aLoc, , aCri)

?str(a[1],20,10)
?str(a[2],20,10)
?str(a[3],20,10)

RETURN NIL

FUNCTION FCSTXMPL(A,B,C)


// array example
// data is 16 values beginning 1988, Q1

LOCAL Series := {  317,  194,  312,  316, ;
                   460,  395,  392,  447, ;
                   538,  570,  600,  565, ;
                   626,  690,  680,  673}
LOCAL Seas := { 1,1,1,1}
LOCAL I_per, nConstant, nTrend, nYear, nPeriod, nStd
LOCAL nActYear, nActPer, nForecast

FcstPeriod(4)
FcstConBlk( { | x | nConstant:= x },{ |  | nConstant})
FcstTrndBlk({ | x | nTrend   := x },{ |  | nTrend   })
FcstYearBlk({ | x | nYear    := x },{ |  | nYear    })
FcstPerBlk ({ | x | nPeriod  := x },{ |  | nPeriod  })
FcstActBlk( NIL                    ,{ |  | Series[I_per]})
FcstStdBlk( { | x | nStd     := x },{ |  | nStd     })
FcstDtBlk(  { | x,y | nYear := x,     nPeriod := y  })

FcstSeasBlk({ | i,x | Seas[i] := x},{ | i | Seas[i]})

FcstAlpha(A)
FcstBeta(B)
FcstGamma(C)

// Determine Initial model parameters.
// Initial model date is period before start of data, i.e. 1987, Q4.
nYear := 1987
nPeriod := 4


// Trend estimate is difference between average for first year and
// average for second year, divided by four.

nTrend := 0.25 * (0.25 * (Series[5]+Series[6]+Series[7]+Series[8])  ;
                - 0.25 * (Series[1]+Series[2]+Series[3]+Series[4]))

// Constant estimate is average for first year, minus 2.5 * nTrend to
// it to 'reset' q4, previous year

nConstant := 0.25 * (Series[1]+Series[2]+Series[3]+Series[4]) - 2.5 * nTrend

// Seasonal estimates are derived from the model and first year's data.

FOR I_per = 1 TO 4
   Seas[I_per] := Series[I_per] / (nConstant + I_per * nTrend)
NEXT

// Standard deviation estimate is arbitrary 10% of first value

nStd := 0.1 * Series[1]

// Run the 16 data values through the model to refine the model constants

nActYear := 1988
nActPer  := 1
FOR I_per = 1 to 16
   FcstPerPost(nActYear, nActPer, Series[I_per])
   IF nActPer < 4
      nActPer++
   ELSE
      nActYear++
      nActPer := 1
   ENDIF
NEXT

RETURN nStd
