FIELD m_actual, m_std, m_const, m_trend, m_date IN FCSTTEST
FIELD m_seas01, m_seas02, m_seas03, m_seas04 IN FCSTTEST


FcstPeriod(4)
FcstConBlk({ | x | m_const := x },{ |  | m_const })
FcstTrndBlk({ | x | m_trend := x },{ |  | m_trend})
FcstYearBlk({ | x | m_date := STR(x,4,0)+RIGHT(m_date,2) }, ;
            { |   | VAL(LEFT(m_date,4)) })
FcstPerBlk({ | x | m_date := LEFT(m_date,4)+STR(x,2,0) }, ;
              { |   | VAL(RIGHT(m_date,2)) })
FcstActBlk( { | x | m_actual := x }, { |  | m_actual})
FcstStdBlk( { | x | m_std := x }, { |  | m_std})
FcstDtBlk( { | x,y | m_date:= STR(x,4,0)+STR(y,2,0)})

S_array := ARRAY(4)
S_ARRAY[1] := { | x | m_seas01 := x }
S_ARRAY[2] := { | x | m_seas02 := x }
S_ARRAY[3] := { | x | m_seas03 := x }
S_ARRAY[4] := { | x | m_seas04 := x }

G_array := ARRAY(4)
G_ARRAY[1] := { |  | m_seas01 }
G_ARRAY[2] := { |  | m_seas02 }
G_ARRAY[3] := { |  | m_seas03 }
G_ARRAY[4] := { |  | m_seas04 }
FcstSeasBlk(S_array,G_array)


USE Fcsttest INDEX Fcsttest NEW
USE FcstSale INDEX FcstSale NEW
SELECT FcstSale

DO WHILE .NOT. EOF()
   SELECT Fcsttest
   SEEK FcstSale->brand
*  IF EOF()
*  ENDIF
   T_year   := VAL(LEFT(FcstSale->date,4))
   T_period := VAL(RIGHT(FcstSale->date,2))
   FcstPerPost(T_year,T_period,FcstSale->sales)
   SELECT FcstSale
   SKIP
ENDDO



SELECT Fcsttest
GO TOP
DO WHILE .NOT. EOF()
   nActual := FcstGetAct()
   nForecast := FcstFcst(1992,2,4)

   ?brand,STR(nActual,8,2)
   FOR I = 1 to 4
      ?? STR(nForecast[i],9,2)
   NEXT
   SKIP
ENDDO

CLOSE DATABASES
A_example()
RETURN
FUNCTION A_EXAMPLE()


// array example
// data is 16 values beginning 1988, Q1

LOCAL Series := { 1020, 1180, 1254, 1315, ;
                  1418, 1579, 1645, 1724, ;
                  1830, 1967, 2061, 2118, ;
                  2225, 2386, 2439, 2519}
LOCAL Seas := { 1,1,1,1}
LOCAL I_per, nConstant, nTrend, nYear, nPeriod, nStd
LOCAL nActYear, nActPer, nForecast

FcstPeriod(4)
FcstConBlk( { | x | nConstant:= x },{ |  | nConstant})
FcstTrndBlk({ | x | nTrend   := x },{ |  | nTrend   })
FcstYearBlk({ | x | nYear    := x },{ |  | nYear    })
FcstPerBlk ({ | x | nPeriod  := x },{ |  | nPeriod  })
FcstActBlk( NIL                    ,{ |  | Series[I_per]})
FcstStdBlk( { | x | nStd     := x },{ |  | nStd     })
FcstDtBlk(  { | x,y | nYear := x,     nPeriod := y  })

FcstSeasBlk({ | i,x | Seas[i] := x},{ | i | Seas[i]})


// Determine Initial model parameters.
// Initial model date is period before start of data, i.e. 1987, Q4.
nYear := 1987
nPeriod := 4


// Trend estimate is difference between average for first year and
// average for second year, divided by four.

nTrend := 0.25 * (0.25 * (Series[5]+Series[6]+Series[7]+Series[8])  ;
                - 0.25 * (Series[1]+Series[2]+Series[3]+Series[4]))

// Constant estimate is average for first year, minus 2.5 * nTrend to
// it to 'reset' q4, previous year

nConstant := 0.25 * (Series[1]+Series[2]+Series[3]+Series[4]) - 2.5 * nTrend

// Seasonal estimates are derived from the model and first year's data.

FOR I_per = 1 TO 4
   Seas[I_per] := Series[I_per] / (nConstant + I_per * nTrend)
NEXT

// Standard deviation estimate is arbitrary 10% of first value

nStd := 0.1 * Series[1]

// Run the 16 data values through the model to refine the model constants

nActYear := 1988
nActPer  := 1
FOR I_per = 1 to 16
   FcstPerPost(nActYear, nActPer, Series[I_per])
   IF nActPer < 4
      nActPer++
   ELSE
      nActYear++
      nActPer := 1
   ENDIF
NEXT

// Compute Forecast

   nForecast := FcstFcst(1992,1,4)

// Print result

FOR I_per = 1 TO 4
   J_per := 12 + I_per
   ?STR(Series[J_per],6,0), STR(nForecast[I_per],6,0),;
    STR(nForecast[I_per] - Series[J_per],6,0)
NEXT

?
? '          Constant = ', STR(nConstant,8,2)
? '             Trend = ', STR(nTrend,8,2)
? 'Standard Deviation = ', STR(nStd,8,2)
?
RETURN
