*** Forecast Module ***
*
*   Copyright 1992 by Noroton River Software
*
*   Peter H. Vanderwaart
*   29 Friar Tuck Lane
*   Stamford, CT 06907
*
*   (203) 322-4721
***********************

#define TRUE        .T.
#define FALSE       .F.

// Default Values

STATIC nPeriod := 12                // Model periods per year

STATIC nAlpha  := .15               // Smoothing coeffecient for model constant
STATIC nBeta   := .15               // Smoothing coeffecient for model trend
STATIC nGamma  := .50               // Smoothing coeffecient for model seasonal
STATIC nCoAlpha  := .85             // Compliment  of Alpha
STATIC nCoBeta   := .85             //     "       "  Beta
STATIC nCoGamma  := .50             //     "       "  Gamma

STATIC nFcstYear                    //Forecast model year
STATIC nFcstPeriod                  //Forecast model period of year

STATIC SetActual   := { | x | nActData:= x}
STATIC bGetActual  := { |   | nActData}

STATIC bSetConst   := { | x | nConstant:= x}
STATIC bGetConst   := { |   | nConstant}

STATIC bSetTrend   := { | x | nTrend:= x}
STATIC bGetTrend   := { |   | nTrend}

STATIC bSetYear    := { | x | nYear:= x}
STATIC bGetYear    := { |   | nYear}

STATIC bSetPeriod  := { | x | nPer:= x}
STATIC bGetPeriod  := { |   | nPer}

STATIC SetDate     := { | x,y | dDate:= STR(x,4,0)+STR(y,2,0)}

STATIC SetSeas     := { | i , x | nSeas:= x}
STATIC GetSeas     := { | i | nSeas}

STATIC SetStd      := { | x | std:= x}
STATIC bGetStd     := { |   | std}

FUNCTION FcstPeriod(i)
LOCAL L_flag := FALSE
IF ASCAN({ 4, 12, 13, 52 }, i ) <> 0
   nPeriod := i
   nAlpha := 2.0 / (nPeriod + 2)
   nBeta  := nAlpha
   nGamma := .5
   nCoAlpha := 1.0 - nAlpha
   nCoBeta  := 1.0 - nBeta
   nCoGamma := 1.0 - nGamma
   L_flag := TRUE
ENDIF
RETURN L_flag

FUNCTION FcstAlpha(x)
LOCAL L_flag := TRUE
IF x > 0 .AND. x < 1 ; nAlpha := x ; nCoAlpha := 1.0 - nAlpha
ELSE ; L_flag := FALSE ; ENDIF
RETURN L_flag

FUNCTION FcstBeta(x)
LOCAL L_flag := TRUE
IF x > 0 .AND. x < 1 ; nBeta := x ; nCoBeta := 1.0 - nBeta
ELSE ; L_flag := FALSE ; ENDIF
RETURN L_flag

FUNCTION FcstGamma(x)
LOCAL L_flag := TRUE
IF x > 0 .AND. n < 1 ; nGamma := x ; nCoGamma := 1.0 - nGamma
ELSE ; L_flag := FALSE ; ENDIF
RETURN L_flag

FUNCTION FcstActBlk(bSet,bGet)
IF VALTYPE(bSet) == 'B'     ; SetActual := bSet
ELSEIF VALTYPE(bSet) == 'U' ; SetActual := NIL  ; ENDIF
IF VALTYPE(bGet) == 'B'     ; bGetActual := bGet ; ENDIF
RETURN NIL

FUNCTION FcstStdBlk(bSet,bGet)
IF VALTYPE(bSet) == 'B'     ; SetStd := bSet
ELSEIF VALTYPE(bSet) == 'U' ; SetStd := NIL  ; ENDIF
IF VALTYPE(bGet) == 'B'     ; bGetStd := bGet ; ENDIF
RETURN NIL

FUNCTION FcstConBlk(bSet,bGet)
IF VALTYPE(bSet) == 'B' ; bSetConst := bSet ; ENDIF
IF VALTYPE(bGet) == 'B' ; bGetConst := bGet ; ENDIF
RETURN NIL

FUNCTION FcstTrndBlk(bSet,bGet)
IF VALTYPE(bSet) == 'B' ; bSetTrend := bSet ; ENDIF
IF VALTYPE(bGet) == 'B' ; bGetTrend := bGet ; ENDIF
RETURN NIL

FUNCTION FcstSeasBlk(bSet,bGet)
IF VALTYPE(bSet) $ 'AB' ; SetSeas := bSet ; ENDIF
IF VALTYPE(bGet) $ 'AB' ; GetSeas := bGet ; ENDIF
RETURN NIL

FUNCTION FcstYearBlk(bSet,bGet)
IF VALTYPE(bSet) == 'B' ; bSetYear := bSet ; ENDIF
IF VALTYPE(bGet) == 'B' ; bGetYear := bGet ; ENDIF
RETURN NIL

FUNCTION FcstPerBlk(bSet,bGet)
IF VALTYPE(bSet) == 'B' ; bSetPeriod := bSet ; ENDIF
IF VALTYPE(bGet) == 'B' ; bGetPeriod := bGet ; ENDIF
RETURN NIL

FUNCTION FcstDtBlk(bSet)
IF VALTYPE(bSet) == 'B'     ; SetDate := bSet
ELSEIF VALTYPE(bSet) == 'U' ; SetDate := NIL  ; ENDIF
RETURN NIL

FUNCTION FcstSetAct(x)
IF VALTYPE(SetActual) == 'B' ; EVAL(SetActual,x) ; ENDIF
RETURN NIL

FUNCTION FcstGetAct()
RETURN EVAL(bGetActual)

FUNCTION FcstSetStd(x)
IF VALTYPE(SetStd) == 'B' ; EVAL(SetStd,x) ; ENDIF
RETURN NIL

FUNCTION FcstGetStd()
RETURN EVAL(bGetStd)

FUNCTION FcstSetCon(x)
RETURN EVAL(bSetConst,x)

FUNCTION FcstGetCon()
RETURN EVAL(bGetConst)

FUNCTION FcstGetTrnd()
RETURN EVAL(bGetTrend)

FUNCTION FcstSetTrnd(x)
RETURN EVAL(bSetTrend,x)

FUNCTION FcstSetSeas(i,x)
IF VALTYPE(SetSeas) == 'B'
   RETURN EVAL(SetSeas,i,x)
ELSEIF VALTYPE(SetSeas) == 'A'
   RETURN EVAL(SetSeas[i],x)
ENDIF
RETURN NIL

FUNCTION FcstGetSeas(i)
IF VALTYPE(GetSeas) == 'B'
   RETURN EVAL(GetSeas,i)
ELSEIF VALTYPE(GetSeas) == 'A'
   RETURN EVAL(GetSeas[i])
ENDIF
RETURN NIL

FUNCTION FcstSetDate(year, per)
IF VALTYPE(SetDate) == 'B' ; EVAL(SetDate,year,per) ; ENDIF
RETURN NIL

FUNCTION FcstPerPost(nActYear, nActPeriod, nActual)
LOCAL nPerDiff, nOldConst, nOldTrend, nOldSeas[nPeriod]
LOCAL nNewConst, nNewTrend, nNewSeas, nActDeSeas, nAdj
LOCAL I, nOldVar, nNewVar, nSeasTot

// Compute number of periods between model date and update date

nPerDiff := nPeriod * (nActYear - EVAL(bGetYear)) + (nActPeriod - EVAL(bGetPeriod))

// IF nPerDiff <= 0 , return: not new data.

IF nPerDiff <= 0 ; RETURN NIL ; ENDIF

// Get current constant and trend from model

nOldConst := EVAL(bGetConst)
nOldTrend := EVAL(bGetTrend)
FOR I = 1 TO nPeriod
   nOldSeas[I]  := FcstGetSeas(I)
NEXT

// if nPerDiff > 0 (i.e. skipping month(s) ), update constant

IF nPerDiff > 1
   nOldConst := nOldConst + (nPerDiff -1) * nOldTrend
ENDIF

// If standard deviation is being posted, compute and post.
   IF VALTYPE(SetStd)== 'B'
      nOldVar := EVAL(bGetStd)
      nNewVar := nAlpha * (nActual - (nOldConst+nOldTrend))^ 2 ;
                 + nCoAlpha * nOldVar
      FcstSetStd(nNewVar^0.5)
   ENDIF

// Compute deseasonalized actual

nActDeSeas := nActual / IIF(nOldSeas[nActPeriod]>0, nOldSeas[nActPeriod], 1.0)

// Smooth Constant, Trend, Seasonal

nNewConst := nAlpha * nActDeSeas + nCoAlpha * (nOldConst + nOldTrend)
nNewTrend := nBeta * (nNewConst - nOldConst) + nCoBeta * nOldTrend
nNewSeas  := nGamma * (nActual / IIF(nNewConst>0, nNewConst,1.0)) ;
            + nCoGamma * nOldSeas[nActPeriod]

// Renormalize seasonals

   nSeasTot := nNewSeas
   FOR I = 1 TO nPeriod
      IF I <> nActPeriod
        nSeasTot += nOldSeas[I]
      ENDIF
   NEXT

   nAdj := nPeriod / IIF(nSeasTot>0,nSeasTot,1.0)
   IF nAdj == 0 ; nAdj := 1 ; ENDIF

// Post Changes

EVAL(bSetConst,nNewConst/nAdj)
EVAL(bSetTrend,nNewTrend/nAdj)
FOR I = 1 TO nPeriod
   IF I == nActPeriod
      FcstSetSeas(I, nAdj * nNewSeas)
   ELSE
      FcstSetSeas(I, nAdj * nOldSeas[I])
   ENDIF
NEXT
FcstSetDate(nActYear, nActPeriod)
FcstSetAct(nActual)
RETURN NIL

FUNCTION FcstFcst(nYear, nPer, nEst)
LOCAL nModYear, nModPer, nModConst, nModTrend
LOCAL nPerDiff, nForecast, nFcst, I

// Get current year of model

nModYear := EVAL(bGetYear)
nModPer  := EVAL(bGetPeriod)

// GET current model constant and trend

nModConst := EVAL(bGetConst)
nModTrend := EVAL(bGetTrend)

// Advance model to period before start of forecast

nPerDiff := nPeriod * (nYear - nModYear) + (nPer - nModPer)

nModConst := nModconst + (nPerDiff- 1) * nModTrend

// Compute forecast(s)

IF nEst <= 1
   nForecast := (nModConst+nModTrend) * FcstGetSeas(nPer)
ELSE
   nForecast := Array(0)
   I = 1
   DO WHILE i <= nEst
      nFcst := (nModConst +(I * nModTrend)) * FcstGetSeas(nPer)
      AADD(nForecast,nFcst)
      nPer := IIF(nPer < Nperiod, ++nPer, 1)
      I++
   ENDDO
ENDIF
RETURN nForecast

