* Help support the Clipper Development Community by letting your customers
* know what their applications were developed with.  Include one of the 
* following Nantucket(tm) Logos on the closing screen of your applications.  
* This will benefit all Clipper developers by increasing end-user awareness, 
* and will distance our products from "dBASE" by establishing Clipper as a 
* solid, independant developement environment.
parameters USECOLOR
USECOLOR= iif( type( "USECOLOR" ) = "U", iscolor(), ;
          iif( USECOLOR $ "COLOR,COLOUR", .T., ;
          iif( USECOLOR $ "B&W,BLACK,WHITE,LCD,PLASMA", .F., ;
               iscolor() )))
set cursor OFF

setcolor( iif( USECOLOR, "W/B", "N/W" ))
* Sample code to demonstrate the Logo's...
scroll( 0, 0, 24, 79, 0 )
@ 2, 5 say "Attention Clipper Developers!"
setcolor( iif( USECOLOR, "R/BG", "W/N" ))
scroll( 5, 4, 18, 75, 0 )
putMsg( " " )
putMsg( "Please help support the Clipper Development Community by incorporating" )
putMsg( "the following Nantucket(tm) Clipper Logo's into the closing screens of" )
putMsg( "your applications, user documentation, and promotional materials." )
putMsg( " " )
putMsg( "This will help us all by raising end-user awareness of Clipper and the" )
putMsg( "quality software which can be produced with it." )
putMsg( " " )
putMsg( "You will now be presented with a series of Logo's. The DEMO will pause" )
putMsg( "for appx. 30 seconds between each Logo, or until you press a key." )
putMsg( " " )
putMsg( "Press any key to continue" )
putMsg( " " )
keyhit()

setcolor( iif( USECOLOR, "B/BG", "W/N" ))
scroll( 0, 0, 24, 79, 0 )
@ 1,  0 say "by Steve Klingler"
@ 2,  0 say "Full Size Clipper Logo"
NanLogo( 4, 1 )              && Full-Size Nantucket Logo
@ 2, 45 say "Small Clipper Logo"
SNanLogo( 4, 44 )            && "Small" Nantucket Logo
keyhit()

setcolor( iif( USECOLOR, "B/BG", "W/N" ))
scroll( 0, 0, 24, 79, 0 )
@ 1,  0 say "by Steve Klingler"
@ 2,  0 say "Tiny Clipper Logo"
TNanLogo( 4, 1 )              && Full-Size Nantucket Logo
@ 2, 45 say "Tiny2 Clipper Logo"
T2NanLogo( 4, 44 )            && "Small" Nantucket Logo
keyhit()

setcolor( iif( USECOLOR, "B/BG", "W/N" ))
scroll( 0, 0, 24, 79, 0 )
@ 1,  0 say "by Jussi Seppl" 
@ 2,  0 say "Full Screen Clipper Logo"
@ 5,  0 say "Press any key when ready..."
keyhit()
JSClipLogo()
keyhit()

setcolor( iif( USECOLOR, "B/BG", "W/N" ))
scroll( 0, 0, 24, 79, 0 )
@ 1,  0 say "by Clayton Neff"
@ 2,  0 say "Smaller Clipper Logo"
CNSNanLogo( 4, 20 )
keyhit()

setcolor( iif( USECOLOR, "B/BG", "W/N" ))
scroll( 0, 0, 24, 79, 0 )
@ 1,  0 say "by J. David Reynolds" 
@ 2,  0 say "Rotating Logo"  
ClipperLogo()
keyhit()

setcolor( iif( USECOLOR, "B/BG", "W/N" ))
scroll( 0, 0, 24, 79, 0 )
@ 1,  0 say "by Mike Takahashi"
@ 2,  0 say "Dropdown Clipper Logo"
@ 5,  0 say "Press any key when ready..."
keyhit()
NAN_DROP()
keyhit()

setcolor( iif( USECOLOR, "B/BG", "W/N" ))
scroll( 0, 0, 24, 79, 0 )
@ 2, 1 say "Developed with:"
NanLogo( 4, 1 )              && Full-Size Nantucket Logo

set cursor ON
@ 23, 79 say ""
return


function keyhit
    inkey( 30 )
return (.T.)


function putMsg
    parameters msgText
    scroll( 5, 4, 18, 75, 1 )
    @ 18, 5 say msgText
    inkey( .5 )
return (.T.)


* NanLogo(): Displays a Nantucket Logo on the screen along with
*            a short message promoting Clipper applications.
*      Size: The displayed Logo is 17 rows long and 40 columns wide.
*     Usage: NanLogo( row, col ) where row and col are the upper
*            left coordinates for the Logo.  If omited they 
*            defalut to the current screen position.
*    Author: Written by Steve Klingler of Programming Solutions, Inc.
*            SLC, UT.  CIS ID: 73320,3117
*      Note: Nantucket, Clipper, and the Nantucket Logo are 
*            trademarks of Nantucket Copr.
function NanLogo
    parameters top, left        && Logo Top and Left coordinates
    private prevColor, logoColor, textColor, sloganColor, regColor
    prevColor= setcolor()
    logoColor= iif( USECOLOR, "B/G", "W/N" )
    textColor= iif( USECOLOR, "W+/G", "W/N" )
    sloganColor= iif( USECOLOR, "N/G", "W/N" )
    regColor=  iif( USECOLOR, "N/B", "N/W" )
    if ( type( "top" ) # 'N' )&& Verify that the values were passed
        top= row()
    endif
    if ( type( "left" ) # 'N' )
        left= col()
    endif
    setcolor( textColor )   
    @ top +  0, left say "Nantucket                        Clipper"
    setcolor( logoColor )   
    @ top +  1, left say ""
    @ top +  2, left say "                              "
    @ top +  3, left say ""
    @ top +  4, left say "                         "
    @ top +  5, left say ""
    @ top +  6, left say "                    "
    @ top +  7, left say ""
    @ top +  8, left say "               "
    @ top +  9, left say ""
    @ top + 10, left say "          "
    @ top + 11, left say ""
    @ top + 12, left say "     "
    @ top + 13, left say ""
    @ top + 14, left say ""
    @ top + 15, left say ""
    @ top + 16, left say ""
    setcolor( sloganColor )
    @ top +  2, left + 19 say "Professional Software"
    @ top +  4, left + 23 say "Utilizing Clipper"
    @ top +  6, left + 30 say "Technology"
    setcolor( regColor )
    @ top + 16, left + 10 say "(R) Nantucket Corp"
    setcolor( prevColor )
return (.T.)


* SNanLogo(): Displays a smalefter "abbreviated" Nantucket Logo on the screen  
*             along with a short message promoting Clipper applications.
*       Size: The displayed Logo is 15 rows long and 34 columns wide.
*      Usage: SNanLogo( row, col ) where row and col are the upper
*             left coordinates for the Logo.  If omited they 
*             defalut to the current screen position.
*     Author: Written by Steve Klingler of Programming Solutions, Inc.
*             SLC, UT.  CIS ID: 73320,3117
*       Note: Nantucket, Clipper, and the Nantucket Logo are 
*             trademarks of Nantucket Copr.
function SNanLogo
    parameters top, left        && Logo Top and Left coordinates
    private prevColor, logoColor, textColor, sloganColor, regColor
    prevColor= setcolor()
    logoColor= iif( USECOLOR, "B/G", "W/N" )
    textColor= iif( USECOLOR, "W+/G", "W/N" )
    sloganColor= iif( USECOLOR, "N/G", "W/N" )
    regColor=  iif( USECOLOR, "N/B", "N/W" )
    if ( type( "top" ) # 'N' )&& Verify that the values were passed
        top= row()
    endif
    if ( type( "left" ) # 'N' )
        left= col()
    endif
    setcolor( textColor )   
    @ top +  0, left say "Nantucket                  Clipper"
    setcolor( logoColor )
    @ top +  1, left say ""
    @ top +  2, left say "                         "
    @ top +  3, left say ""
    @ top +  4, left say "                    "
    @ top +  5, left say ""
    @ top +  6, left say "               "
    @ top +  7, left say ""
    @ top +  8, left say "          "
    @ top +  9, left say ""
    @ top + 10, left say "     "
    @ top + 11, left say ""
    @ top + 12, left say ""
    @ top + 13, left say ""
    @ top + 14, left say ""
    setcolor( sloganColor )
    @ top +  2, left + 13 say "Professional Software"
    @ top +  4, left + 17 say "Utilizing Clipper"
    @ top +  6, left + 24 say "Technology"
    setcolor( regColor )
    @ top + 14, left + 7 say "(R) Nantucket Corp"
    setcolor( prevColor )
return (.T.)


* TNanLogo(): Displays a tiny "abbreviated" Nantucket Logo on the screen  
*             along with a short message promoting Clipper applications.
*       Size: The displayed Logo is 13 rows long and 29 columns wide.
*      Usage: SNanLogo( row, col ) where row and col are the upper
*             left coordinates for the Logo.  If omited they 
*             defalut to the current screen position.
*     Author: Written by Steve Klingler of Programming Solutions, Inc.
*             SLC, UT.  CIS ID: 73320,3117
*       Note: Nantucket, Clipper, and the Nantucket Logo are 
*             trademarks of Nantucket Copr.
function TNanLogo
    parameters top, left        && Logo Top and Left coordinates
    private prevColor, logoColor, textColor, sloganColor, regColor
    prevColor= setcolor()
    logoColor= iif( USECOLOR, "B/G", "W/N" )
    textColor= iif( USECOLOR, "W+/G", "W/N" )
    sloganColor= iif( USECOLOR, "N/G", "W/N" )
    regColor=  iif( USECOLOR, "N/B", "N/W" )
    if ( type( "top" ) # 'N' )&& Verify that the values were passed
        top= row()
    endif
    if ( type( "left" ) # 'N' )
        left= col()
    endif
    setcolor( textColor )   
    @ top +  0, left say "Nantucket             Clipper"
    setcolor( logoColor )
    @ top +  1, left say ""
    @ top +  2, left say "                    "
    @ top +  3, left say ""
    @ top +  4, left say "               "
    @ top +  5, left say ""
    @ top +  6, left say "          "
    @ top +  7, left say ""
    @ top +  8, left say "     "
    @ top +  9, left say ""
    @ top + 10, left say ""
    @ top + 11, left say ""
    @ top + 12, left say ""
    setcolor( sloganColor )
    @ top +  2, left + 12 say "Utilizing Clipper"    
    @ top +  4, left + 19 say "Technology"
    setcolor( regColor )
    @ top + 12, left + 5 say "(R) Nantucket Corp"
    setcolor( prevColor )
return (.T.)


* T2NanLogo(): Displays a tiny "abbreviated" Nantucket Logo on the screen
*             along with a short message promoting Clipper applications.
*       Size: The displayed Logo is 10 rows long and 23 columns wide.
*      Usage: SNanLogo( row, col ) where row and col are the upper
*             left coordinates for the Logo.  If omited they 
*             defalut to the current screen position.
*     Author: Written by Steve Klingler of Programming Solutions, Inc.
*             SLC, UT.  CIS ID: 73320,3117
*       Note: Nantucket, Clipper, and the Nantucket Logo are 
*             trademarks of Nantucket Copr.
function T2NanLogo
    parameters top, left        && Logo Top and Left coordinates
    private prevColor, logoColor, textColor, sloganColor, regColor
    prevColor= setcolor()
    logoColor= iif( USECOLOR, "B/G", "W/N" )
    textColor= iif( USECOLOR, "W+/G", "W/N" )
    sloganColor= iif( USECOLOR, "N/G", "W/N" )
    regColor=  iif( USECOLOR, "N/B", "N/W" )
    if ( type( "top" ) # 'N' )&& Verify that the values were passed
        top= row()
    endif
    if ( type( "left" ) # 'N' )
        left= col()
    endif
    setcolor( textColor )   
    @ top +  0, left say "Nantucket       Clipper"
    setcolor( logoColor )      
    @ top +  1, left say ""
    @ top +  2, left say "              "
    @ top +  3, left say ""
    @ top +  4, left say "         "
    @ top +  5, left say ""
    @ top +  6, left say "    "
    @ top +  7, left say ""
    @ top +  8, left say ""
    @ top +  9, left say ""
    @ top + 10, left say ""
    * no room for logo here!
    * setcolor( sloganColor )
    * @ top +  2, left + 14 say "Utilizing"
    * @ top +  4, left + 16 say   "Clipper"
    setcolor( regColor )
    @ top + 10, left + 1 say "(R) Nantucket Corp"
    setcolor( prevColor )
return (.T.)



FUNCTION JSClipLogo
   *------------------------------------------------------------------
   *  Description:   Draws Nantucket Logo and a message box stating
   *                 that the application is written in Clipper.
   *                 You might wish to add a few lines for restoring
   *                 the color settings, though if used as an exit 
   *                 routine they are not required.
   *
   *  Parameters.:   none
   *
   *  Returns....:   void
   *
   *  Depends on.:
   *
   *  Author.....:   Jussi Seppl, 22.08.1989    (European date)
   *
   *------------------------------------------------------------------

   PRIVATE  VOID,;                     && still waiting for a preprocessor ...
            lcClogo, ;                 && logo color
            lcClogoTxt, ;              && logo text
            lcCshadow, ;               && shadow color
            lcCmsg                     && message box color


   VOID=       .T.
   lcClogo=    "B/G"
   lcClogoTxt= "+W/G"
   lcCshadow=  "+N/N"
   lcCmsg=     "N/W"

   SET COLOR TO
   CLEAR
   
   * ..... Draw shadow for Clipper logo
   SETCOLOR( lcCshadow)
   @  1 ,77 SAY ""
   @  2 ,77 SAY ""
   @  3 ,77 SAY ""
   @  4 ,77 SAY ""
   @  5 ,77 SAY ""
   @  6 ,77 SAY ""
   @  7 ,77 SAY ""
   @  8 ,77 SAY ""
   @  9 ,77 SAY ""
   @ 10 ,77 SAY ""
   @ 11 ,77 SAY ""
   @ 12 ,77 SAY ""
   @ 13 ,77 SAY ""
   @ 14 ,77 SAY ""
   @ 15 ,77 SAY ""
   @ 16 ,77 SAY ""
   @ 17 ,77 SAY ""
   @ 18 ,77 SAY ""
   @ 19 ,39 SAY ""

   * ..... Draw logo
   SETCOLOR( lcClogo)
   @ 0, 37 CLEAR TO 18, 76
   @  3, 37 SAY ""
   @  4, 37 SAY "                              "
   @  5, 37 SAY ""
   @  6, 37 SAY "                         "
   @  7, 37 SAY ""
   @  8, 37 SAY "                    "
   @  9, 37 SAY ""
   @ 10, 37 SAY "               "
   @ 11, 37 SAY ""
   @ 12, 37 SAY "          "
   @ 13, 37 SAY ""
   @ 14, 37 SAY "     "
   @ 15, 37 SAY ""
   @ 16, 37 SAY ""
   @ 17, 37 SAY ""
   @ 18, 37 SAY ""
   
   SETCOLOR( lcClogoTxt)
   @  1, 38 SAY "Nantucket"
   @  1, 69 SAY "Clipper"

   * ..... Draw shadow for the message box
   SETCOLOR( lcCshadow)
   @  5, 32 SAY ""
   @  6, 32 SAY ""
   @  7, 32 SAY ""
   @  8, 32 SAY ""
   @  9, 32 SAY ""
   @ 10, 32 SAY ""
   @ 11, 32 SAY ""
   @ 12, 32 SAY ""
   @ 13,  2 SAY ""


   * ..... Say message
   SETCOLOR( lcCmsg)
   @  4, 0 CLEAR TO 12, 31
   @  5, 1 SAY "This application was developed"
   @  7, 3 SAY "using Clipper, the ultimate"
   @  9, 3 SAY "database management system"
   @ 11, 5 SAY "for personal computers."
   
   SET COLOR TO
   @ 22,  6 SAY "Nantucket, the Nantucket Logo and Clipper are registered trademarks;"
   @ 23, 20 SAY "McMax and Nantucket News are trademarks;"
   @ 24, 10 SAY "Nantucket Support is a service mark of Nantucket Corporation"

RETURN( VOID)
* ClipLogo() ---------------------------------------------------------


* CNSNanLogo(): Displays a smalefter "abbreviated" Nantucket Logo on the screen  
*             along with a short message promoting Clipper applications.
*       Size: The displayed Logo is 15 rows long and 34 columns wide.
*      Usage: SNanLogo( row, col ) where row and col are the upper
*             left coordinates for the Logo.  If omited they 
*             defalut to the current screen position.
*-----        << I added a check to make sure they do not exceed maximums.>>
*     Author: Written by Steve Klingler of Programming Solutions, Inc.
*             SLC, UT.  CIS ID: 73320,3117
*-----        <<Modified by Clayton Neff, CIS ID: 72007,302>>
*-----        <<NOTE: Steve did all the REAL work.  All I did was make his
*-----                small logo smaller and moved the support text outside
*-----                the logo proper.>>
*       Note: Nantucket, Clipper, and the Nantucket Logo are 
*             trademarks of Nantucket Copr.
function CNSNanLogo
   parameters top, left        && Logo Top and Left coordinates
   private prevColor, logoColor, textColor, regColor
   prevColor= setcolor()
   logoColor= iif( USECOLOR, "B/G", "W/N" )
   textColor= iif( USECOLOR, "W+/G", "W+/N" )
   regColor=  iif( USECOLOR, "N/B", "N/W" )
   if ( type( "top" ) # 'N' )&& Verify that the values were passed
       top= row()
   endif
   if ( type( "left" ) # 'N' )
       left= col()
   endif
   top = min( top, 11 )
   left = min( left, 56 )

   @ top +  0, left say " Professional  Software "
   @ top +  1, left say "        Utilizing       "
   setcolor( textColor )   
   @ top +  2, left say "Nantucket        Clipper"
   setcolor( logoColor )
   @ top +  3, left say ""
   @ top +  4, left say "                "
   @ top +  5, left say ""
   @ top +  6, left say "           "
   @ top +  7, left say ""
   @ top +  8, left say "      "
   @ top +  9, left say ""
   @ top + 10, left say " "
   @ top + 11, left say ""
   @ top + 12, left say ""
   setcolor( regColor )
   @ top + 12, left say "  (R) Nantucket Corp"
   setcolor( prevColor )
   @ top + 13, left say "       Technology       "
return (.T.)


******************************************************************************
** ClipperLogo()
** J. David Reynolds, 08/89
******************************************************************************
FUNCTION ClipperLogo
PRIVATE _Row, _Col, _Delay
_Row   = 07
_Col   = 27
_Delay = 5
PARAMETERS _Row, _Col, _Delay

PRIVATE _LastColor, _Logo[10], _Ogol[10]

_LastColor = SETCOLOR("B/BG")

_Logo[01] = ""
_Logo[02] = "      Brought to you "
_Logo[03] = ""
_Logo[04] = "         by       "
_Logo[05] = ""
_Logo[06] = "  Clipper (R)  "
_Logo[07] = ""
_Logo[08] = "            "
_Logo[09] = "  Clipper is a trademark  "
_Logo[10] = " of Nantucket Corporation "

_Ogol[01] = ""
_Ogol[02] = " uoy ot thguorB      "
_Ogol[03] = ""
_Ogol[04] = "       yb         "
_Ogol[05] = ""
_Ogol[06] = "  (R) reppilC  "
_Ogol[07] = ""
_Ogol[08] = "            "
_Ogol[09] = "  kramedart a si reppilC  "
_Ogol[10] = " noitaroproC tekcutnaN fo "

SET CURSOR OFF

RotateLogo(_Row, _Col, _Logo, _LastColor, .T.)

RotateLogo(_Row, _Col, _Ogol, _LastColor, .T.)

RotateLogo(_Row, _Col, _Logo, _LastColor, .F.)

SETCOLOR(_LastColor)

INKEY(_Delay)

SET CURSOR ON

RETURN(.T.)


******************************************************************************
** RotateLogo()
** J. David Reynolds, 08/89
******************************************************************************
FUNCTION RotateLogo
PARAMETERS _Row, _Col, _Logo, _LastColor, _AllTheWay

PRIVATE i

FOR i = 1 TO 13
  @ _Row + 00,_Col + (13 - i) SAY LEFT(_Logo[01], i) + RIGHT(_Logo[01], i)
  @ _Row + 01,_Col + (13 - i) SAY LEFT(_Logo[02], i) + RIGHT(_Logo[02], i)
  @ _Row + 02,_Col + (13 - i) SAY LEFT(_Logo[03], i) + RIGHT(_Logo[03], i)
  @ _Row + 03,_Col + (13 - i) SAY LEFT(_Logo[04], i) + RIGHT(_Logo[04], i)
  @ _Row + 04,_Col + (13 - i) SAY LEFT(_Logo[05], i) + RIGHT(_Logo[05], i)
  @ _Row + 05,_Col + (13 - i) SAY LEFT(_Logo[06], i) + RIGHT(_Logo[06], i)
  @ _Row + 06,_Col + (13 - i) SAY LEFT(_Logo[07], i) + RIGHT(_Logo[07], i)
  @ _Row + 07,_Col + (13 - i) SAY LEFT(_Logo[08], i) + RIGHT(_Logo[08], i)
  @ _Row + 08,_Col + (13 - i) SAY LEFT(_Logo[09], i) + RIGHT(_Logo[09], i)
  @ _Row + 09,_Col + (13 - i) SAY LEFT(_Logo[10], i) + RIGHT(_Logo[10], i)
  INKEY()
NEXT i

IF _AllTheWay

  FOR i = 13 TO 1 STEP -1
    SETCOLOR(_LastColor)
    SCROLL(_Row, _Col, _Row + 09, _Col + (12 - i), 0)
    SCROLL(_Row, _Col + (13 + i), _Row + 09, _Col + 25, 0)
    SETCOLOR("B/BG")
    @ _Row + 00,_Col + (13 - i) SAY LEFT(_Logo[01], i) + RIGHT(_Logo[01], i)
    @ _Row + 01,_Col + (13 - i) SAY LEFT(_Logo[02], i) + RIGHT(_Logo[02], i)
    @ _Row + 02,_Col + (13 - i) SAY LEFT(_Logo[03], i) + RIGHT(_Logo[03], i)
    @ _Row + 03,_Col + (13 - i) SAY LEFT(_Logo[04], i) + RIGHT(_Logo[04], i)
    @ _Row + 04,_Col + (13 - i) SAY LEFT(_Logo[05], i) + RIGHT(_Logo[05], i)
    @ _Row + 05,_Col + (13 - i) SAY LEFT(_Logo[06], i) + RIGHT(_Logo[06], i)
    @ _Row + 06,_Col + (13 - i) SAY LEFT(_Logo[07], i) + RIGHT(_Logo[07], i)
    @ _Row + 07,_Col + (13 - i) SAY LEFT(_Logo[08], i) + RIGHT(_Logo[08], i)
    @ _Row + 08,_Col + (13 - i) SAY LEFT(_Logo[09], i) + RIGHT(_Logo[09], i)
    @ _Row + 09,_Col + (13 - i) SAY LEFT(_Logo[10], i) + RIGHT(_Logo[10], i)
    INKEY()
  NEXT i

ENDIF && _AllTheWay

**
* Nan_Drop(): Drops a Nantucket Logo from the top of the screen along with
*            a short message promoting Clipper applications.
*
*     Usage: Nan_Drop()
*
*     Author: Written by Steve Klingler of Programming Solutions, Inc.
*             SLC, UT.  CIS ID: 73320,3117
*             This is a modified version of Steve Klinglers' NanLogo()
*             Modifications done by Mike Takahashi.
*             Uploaded by George Passidakis. (CIS 72406,2627)
*
*      Note: Nantucket, Clipper, and the Nantucket Logo are
*            trademarks of Nantucket Copr.
**
FUNCTION nan_drop
moldcolor=SETCOLOR()
musecolor=ISCOLOR()
SET CURS off
c_logo=IIF(musecolor,"B/G","W/N")
c_toptext=IIF(musecolor,"W+/G","W/N")
c_slogan=IIF(musecolor,"N/G","W/N")
SET COLOR TO
CLEAR
SET COLOR TO w+/n
@ 00,32 SAY "(R) Nantucket Corp."
DROPLINE(22)
SET COLOR TO &c_logo
@ 00,20 SAY ""
DROPLINE(20)
@ 00,20 SAY ""
DROPLINE(19)
@ 00,20 SAY ""
DROPLINE(18)
@ 00,20 SAY ""
DROPLINE(17)
@ 00,20 SAY "     "
DROPLINE(16)
@ 00,20 SAY ""
DROPLINE(15)
@ 00,20 SAY "          "
DROPLINE(14)
@ 00,20 SAY ""
DROPLINE(13)
@ 00,20 SAY "               "
DROPLINE(12)
@ 00,20 SAY ""
DROPLINE(11)
@ 00,20 SAY "                    "
SET COLOR TO &c_slogan
@ 00,50 SAY "Technology"
DROPLINE(10)
SET COLOR TO &c_logo
@ 00,20 SAY ""
DROPLINE(09)
@ 00,20 SAY "                         "
SET COLOR TO &c_slogan
@ 00,43 SAY "Utilizing Clipper"
DROPLINE(08)
SET COLOR TO &c_logo
@ 00,20 SAY ""
DROPLINE(07)
@ 00,20 SAY "                              "
SET COLOR TO &c_slogan
@ 00,39 SAY "Professional Software"
DROPLINE(06)
SET COLOR TO &c_logo
@ 00,20 SAY ""
DROPLINE(05)
SET COLOR TO &c_toptext
@ 00,20 SAY "Nantucket                        Clipper"
DROPLINE(04)
SET COLOR TO w+/n
@ 00,32 SAY "Developed with:"
DROPLINE(02)
SET COLOR TO &moldcolor
RETURN('')
**
FUNCTION dropline
PARAMETERS p_endline
moldline=SAVESCREEN(0,20,0,60)
mcurrcolor=SETCOLOR()
SET COLOR TO
FOR mcounter=1 TO p_endline
    @ mcounter-1,20 CLEAR TO mcounter-1,60
    RESTSCREEN(mcounter,20,mcounter,60,moldline)
NEXT
SET COLOR TO &mcurrcolor
RETURN('')

