/***
*	NOTE: compile with /m/n/w
*/

#include "Set.ch"
#include "Inkey.ch"
#include "Getexit.ch"

#define K_UNDO          K_CTRL_U

#define K_PLUS          43       // Plus  Key
#define K_MINUS         45       // Minus Key

/***
*       NewGetReader()
*
*       NonStandard modal read of a single GET.
*       Allows +/- keys to change date field.
*       To use, Add the following Line after each get
*
*       ATail( GetList ):Reader := {|x| NGR(x) }
*
*       you could also code it like,
*
*       GetList[ Len( GetList ) ]:Reader := {|x| NGR(x) }
*
*       You should link compile and link this into your programs with GetSys
*       i.e.
*       RTLink fi YourProg,GetSys,NGR
*
*       If you do not link in Getsys, you get a lot of linker warning, why i am
*       not sure, but who am i to argue with RTLink.
*
*       Most (?all?) of this code has been shamelessly plagiarised from a work by
*       Lindsay McCann ( CIS ID 73770,1515). Lindsay's version is a file "NuGets.Zip"
*
*       The code has been adapted for Clipper 5.01 and uses the New Export Instance
*       Variable "reader" to replace the existing Get Reader, rather than modify GetSys.
*
*       This program has been tested at great lenght (at least 5 minutes) and
*       seems to work. Try the program with caution. As i live outside the
*       Juristication of the Court of The United States of America, you are unlikely
*       to be able to sue me if it trashes your Hard Disk, or worse.
*
*       Some on the contents MAY be copyrighted by Nantucket.
*
*/

proc NGR( get )


	// read the GET if the WHEN condition is satisfied
	if ( GetPreValidate(get) )

		// activate the GET for reading
		get:SetFocus()

		while ( get:exitState == GE_NOEXIT )

			// check for initial typeout (no editable positions)
			if ( get:typeOut )
				get:exitState := GE_ENTER
			end

			// apply keystrokes until exit
			while ( get:exitState == GE_NOEXIT )
				GetApplyKey( get, Inkey(0) )
			end

			// disallow exit if the VALID condition is not satisfied
			if ( !GetPostValidate(get) )
				get:exitState := GE_NOEXIT
			end

		end

		// de-activate the GET
		get:KillFocus()

	end

return

/***
*	GetApplyKey()
*	Apply a single Inkey() keystroke to a GET.
*
*	NOTE: GET must have focus.
*/

static proc GetApplyKey(get, key)

Static nLastKey , mul

local cKey
local bKeyBlock
Local dt,nm

        nLastKey := IIF( ValType( nLastKey ) != 'N' , 0 , nLastKey )
        mul      := IIF( ValType( mul      ) != 'N' , 0 , mul      )

	// check for SET KEY first
	if ( (bKeyBlock := SetKey(key)) <> NIL )

		GetDoSetKey(bKeyBlock, get)
		return									// NOTE

	end

	do case
	case ( key == K_UP )
		get:exitState := GE_UP

	case ( key == K_SH_TAB )
		get:exitState := GE_UP

	case ( key == K_DOWN )
		get:exitState := GE_DOWN

	case ( key == K_TAB )
		get:exitState := GE_DOWN

	case ( key == K_ENTER )
		get:exitState := GE_ENTER

	case ( key == K_ESC )
		if ( Set(_SET_ESCAPE) )
			get:undo()
			get:exitState := GE_ESCAPE
		end

	case ( key == K_PGUP )
		get:exitState := GE_WRITE

	case ( key == K_PGDN )
		get:exitState := GE_WRITE

	case ( key == K_CTRL_HOME )
		get:exitState := GE_TOP


#ifdef CTRL_END_SPECIAL

	// both ^W and ^End go to the last GET
	case (key == K_CTRL_END)
		get:exitState := GE_BOTTOM

#else

	// both ^W and ^End terminate the READ (the default)
	case (key == K_CTRL_W)
		get:exitState := GE_WRITE

#endif


	case (key == K_INS)
		Set( _SET_INSERT, !Set(_SET_INSERT) )
                SSb()

	case (key == K_UNDO)
		get:Undo()

	case (key == K_HOME)
		get:Home()

	case (key == K_END)
		get:End()

	case (key == K_RIGHT)
		get:Right()

	case (key == K_LEFT)
		get:Left()

	case (key == K_CTRL_RIGHT)
		get:WordRight()

	case (key == K_CTRL_LEFT)
		get:WordLeft()

	case (key == K_BS)
		get:BackSpace()

	case (key == K_DEL)
		get:Delete()

	case (key == K_CTRL_T)
		get:DelWordRight()

	case (key == K_CTRL_Y)
		get:DelEnd()

	case (key == K_CTRL_BS)
		get:DelWordLeft()

        case (get:type == "D" .and. (Key == K_PLUS .or. Key == K_MINUS))
                mul := iif(nLastkey==Key, ++mul, 10)
                nm=-(Key-44)*int(mul/10)
                get:assign()
                dt=get:VarGet()
                dt=iif(empty(dt),date(),dt)
                get:VarPut(dt+nm)
                get:updateBuffer()

	otherwise

		if (key >= 32 .and. key <= 255)

			cKey := Chr(key)

			if (get:type == "N" .and. (cKey == "." .or. cKey == ","))
				get:ToDecPos()

			else
				if ( Set(_SET_INSERT) )
					get:Insert(cKey)
				else
					get:Overstrike(cKey)
				end

				if (get:typeOut .and. !Set(_SET_CONFIRM) )
					if ( Set(_SET_BELL) )
						?? Chr(7)
					end

					get:exitState := GE_ENTER
				end

			end

		end

        endcase

        nLastKey := Key

return


// display coordinates for SCOREBOARD
#define SCORE_ROW		0
#define SCORE_COL		60


/***
*   SSb()
*
*   This is the ShowScoreboard routine from GetSys, as it's a static function
*   in GetSys, it can't be seen here. I renamed it just in case.
*
*/

static proc SSb()

local nRow, nCol


    if ( Set(_SET_SCOREBOARD) )
        nRow := Row()
        nCol := Col()

		SetPos(SCORE_ROW, SCORE_COL)
		DispOut( if(Set(_SET_INSERT), "Ins", "   ") )
        SetPos(nRow, nCol)
	end

return
