*:*****************************************************************************
*:
*: Procedure file: C:\UTILS\UTIL_DBF.PRG
*:
*:         System: No Frill Utils for Clipper
*:         Author: John Wright
*:      Copyright (c) 1990-1993, John Wright
*:  Last modified: 04/01/93      9:37
*:
*:  Procs & Fncts: JDWMAKE()
*:
*:         Set by: UTILS.PRG                         
*:
*:          Calls: CENTER()           (function  in UTILS.PRG)
*:               : BOX_IT()           (function  in UTILS.PRG)
*:               : JDWMAKE()          (function  in UTIL_DBF.PRG, called from Achoice())
*:
*:           Uses: TEMPFILE.DBF       
*:
*:    Other Files: AUTO_DBF.TXT
*:
*:      Documented 08/08/93 at 10:32                SNAP!  version 5.02
*:*****************************************************************************
* Create code to do a CREATE a database file if it is not found in the current
* directory.  This requires an actual database to copy the structure from.
* 08/06/88 - Created
* 03/28/89 - put the IF FILE statement in code too.
* 03/23/90 - call USE command instead of CLOSE DATA
* 04/01/93 - fixed a bug with incorrect memory variable
CLEAR

numfiles=ADIR("*.dbf")

IF numfiles > 0
   DECLARE Files[numfiles]
   ADIR("*.dbf",Files)
   ASORT(Files)
ELSE
   Center("Cannot find any database files in the current directory.",10)
   @ 20,0
   WAIT "Unable to process...  press any key"
   RETURN
ENDIF

STORE 0 TO jdw_done
STORE 80 TO jdw_dflt
STORE 3 TO jdw_ind
STORE "Y" TO ans

box_it("MAKE PROGRAM CODE TO CREATE DATABASE FILES",3)
@  8,19 SAY "Enter number of columns to indent code: " GET jdw_ind PICT '9'
IF FILE("auto_dbf.txt")
   @ 14,19 SAY "Do you want to overwrite AUTO_DBF.TXT? " GET ans PICT 'Y'
   @ 16,19 SAY "This will erase any previous code in the file."
ENDIF
READ

IF ans <> "Y" .OR. LASTKEY() = 27
   RETURN
ENDIF

STORE 7+numfiles TO B
IF B > 20
   STORE 20 TO B
ENDIF
SET ALTERNATE TO auto_dbf.txt

@  8,1 CLEAR TO 19,79
@  8,14 SAY "Press Enter to process a database."
IF numfiles > 1
   @ 10,14 SAY "Move through the list with the"
   @ 11,14 SAY "cursor keys."
   @ 13,14 SAY "Press [Esc] to exit."
ELSE
   @ 10,14 SAY "Press [Esc] to exit."
ENDIF
@ 7,54 TO B+1,67
DO WHILE LASTKEY() <> 27
   chosen=ACHOICE(8,55,B,66,Files,.T.,"jdwmake")
ENDDO

SET ALTERNATE TO
IF jdw_done = 0
   ERASE auto_dbf.txt
ENDIF

IF FILE("TEMPFILE.DBF")
   ERASE tempfile.dbf
ENDIF

RETURN

*!*****************************************************************************
*!
*!       Function: JDWMAKE()
*!
*!      Called by: UTIL_DBF.PRG                      
*!
*!          Calls: CENTER()           (function  in UTILS.PRG)
*!
*!           Uses: TEMPFILE.DBF       
*!
*!*****************************************************************************
FUNCTION jdwmake
PARAMETERS mode, c_chosen, w_posit

IF mode = 3
   IF LASTKEY() = 27
      RETURN 0
   ENDIF
   IF LASTKEY() <> 13
      RETURN 2
   ENDIF
ELSE
   RETURN 2
ENDIF

STORE Files[c_chosen] TO jdw_dbf
USE (jdw_dbf)
COPY TO tempfile STRUCTURE EXTENDED
USE tempfile

SET CONSOLE OFF
SET ALTERNATE ON

?'IF .NOT. FILE("'+jdw_dbf+'")'
?SPACE(jdw_ind)+'CREATE TEMPFILE.DBF'

DO WHILE .NOT. EOF()
   
   ?SPACE(jdw_ind)+'APPEND BLANK'
   ?SPACE(jdw_ind)+'REPL FIELD_NAME WITH "'+TRIM(field_name)+'"'
   ??', FIELD_TYPE WITH "'+field_type+'"'
   ??', FIELD_LEN WITH '+LTRIM(STR(field_len))
   
   IF field_dec <> 0
      ??', ;'
      ?SPACE(jdw_ind)+'FIELD_DEC WITH '+LTRIM(STR(field_dec))
   ENDIF
   
   SKIP
   
ENDDO

?SPACE(jdw_ind)+'USE'
?SPACE(jdw_ind)+'CREATE '+jdw_dbf+' FROM TEMPFILE'
?SPACE(jdw_ind)+'ERASE TEMPFILE.DBF'
?'ENDIF'
?""
?""

SET ALTERNATE OFF
SET CONSOLE ON

STORE jdw_done+1 TO jdw_done
@ 22,0
IF jdw_done = 1
   Center("1 database done!",22)
ELSE
   Center(LTRIM(STR(jdw_done))+" databases done!",22)
ENDIF

USE
RETURN 2

*: EOF: UTIL_DBF.PRG
