*:*****************************************************************************
*:
*: Procedure file: C:\UTILS\UTILLOAD.PRG
*:
*:         System: No Frill Utils for Clipper
*:         Author: John Wright
*:      Copyright (c) 1990-1993, John Wright
*:  Last modified: 11/09/92      9:08
*:
*:  Procs & Fncts: JDWLOAD()
*:
*:         Set by: UTILS.PRG                         
*:
*:          Calls: CENTER()           (function  in UTILS.PRG)
*:               : BOX_IT()           (function  in UTILS.PRG)
*:               : JDWLOAD()          (function  in UTILLOAD.PRG, called from Achoice())
*:
*:    Other Files: AUTOLOAD.TXT
*:
*:      Documented 08/08/93 at 10:32                SNAP!  version 5.02
*:*****************************************************************************
* 11/09/92 - Changed to include alias and Clipper 5 support
CLEAR
numfiles=ADIR("*.dbf")

IF numfiles > 0
   DECLARE Files[numfiles]
   ADIR("*.dbf",Files)
   ASORT(Files)
ELSE
   Center("Cannot find any database files in the current directory.",10)
   @ 20,0
   WAIT "Unable to process...  press any key"
   RETURN
ENDIF

STORE 0 TO jdw_done
STORE 80 TO jdw_dflt
STORE "m_" TO jdw_pref
STORE "Y" TO ans

jdw_clp5 = IF( GETE("PRG_TYPE")="CLIP5", .T., .F. )

box_it("MAKE PROGRAM CODE TO LOAD DATABASE FIELDS",3)
@  8,19 SAY "Enter the prefix for memory variables: " GET jdw_pref
@ 10,19 SAY "  Use Clipper 5 assignment statements? " GET jdw_clp5 PICT 'Y'
IF FILE("AUTOLOAD.txt")
   @ 14,19 SAY "Do you want to overwrite AUTOLOAD.TXT? " GET ans PICT 'Y'
   @ 16,19 SAY "This will erase any previous code in the file."
ENDIF
READ

IF ans <> "Y" .OR. LASTKEY() = 27
   RETURN
ENDIF

STORE LTRIM(TRIM(jdw_pref)) TO jdw_pref
STORE 7+numfiles TO B
IF B > 20
   STORE 20 TO B
ENDIF
SET ALTERNATE TO AUTOLOAD.txt

@  8,1 CLEAR TO 19,79
@  8,14 SAY "Press Enter to process a database."
IF numfiles > 1
   @ 10,14 SAY "Move through the list with the"
   @ 11,14 SAY "cursor keys."
   @ 13,14 SAY "Press [Esc] to exit."
ELSE
   @ 10,14 SAY "Press [Esc] to exit."
ENDIF
@ 7,54 TO B+1,67
DO WHILE LASTKEY() <> 27
   chosen=ACHOICE(8,55,B,66,Files,.T.,"JDWLOAD")
ENDDO

SET ALTERNATE TO
IF jdw_done = 0
   ERASE AUTOLOAD.txt
ENDIF

RETURN

*!*****************************************************************************
*!
*!       Function: JDWLOAD()
*!
*!      Called by: UTILLOAD.PRG                      
*!
*!          Calls: CENTER()           (function  in UTILS.PRG)
*!
*!*****************************************************************************
FUNCTION JDWLOAD
PARAMETERS mode, c_chosen, w_posit

IF mode = 3
   IF LASTKEY() = 27
      RETURN 0
   ENDIF
   IF LASTKEY() <> 13
      RETURN 2
   ENDIF
ELSE
   RETURN 2
ENDIF

STORE SUBSTR(Files[c_chosen],1,AT(".",Files[c_chosen])-1 ) TO jdw_dbf
USE (jdw_dbf)

SET CONSOLE OFF
SET ALTERNATE ON

* Create a LOCAL statement for the variables
IF jdw_clp5
   nLoop = 0
   nMaxLen = 0
   FOR X = 1 TO FCOUNT()
      nLoop = nLoop + 1
      IF nLoop = 1
         ?"LOCAL "
      ELSE
         ??", "
         IF nLoop = 6
            nLoop = 0
         ENDIF
      ENDIF
      ??jdw_pref+LOWER(FIELD(X))
      IF LEN( FIELD(X) ) > nMaxLen
         nMaxLen = LEN( FIELD(X) )
      ENDIF
   NEXT
   ?""
ENDIF

FOR X = 1 TO FCOUNT()
   IF jdw_clp5
      ?jdw_pref+LOWER(FIELD(X)) + SPACE( nMaxLen - LEN(FIELD(X)) )
      ??" := "+LOWER(jdw_dbf+"->"+FIELD(X))
   ELSE
      ?"STORE "+LOWER(FIELD(X))+" TO "+jdw_pref+LOWER(FIELD(X))
   ENDIF
NEXT

?""
?""

SET ALTERNATE OFF
SET CONSOLE ON

STORE jdw_done+1 TO jdw_done
@ 22,0
IF jdw_done = 1
   Center("1 database done!",22)
ELSE
   Center(LTRIM(STR(jdw_done))+" databases done!",22)
ENDIF

CLOSE DATABASE
RETURN 2

*: EOF: UTILLOAD.PRG
