*:*****************************************************************************
*:
*:        Program: C:\UTILS\UTIL_NTX.PRG
*:
*:         System: No Frill Utils for Clipper
*:         Author: John Wright
*:      Copyright (c) 1990-1993, John Wright
*:  Last modified: 11/09/92      9:23
*:
*:      Called by: UTILS.PRG                         
*:
*:           Uses: &CDBFNAME          
*:
*:        Indexes: &NTX_FILE          
*:
*:      Documented 08/08/93 at 10:32                SNAP!  version 5.02
*:*****************************************************************************
* PROGRAM...:  INDEX.PRG
* AUTHOR....:  Alan Mulquinn
* DATE......:  May 15, 1985
* NOTICE....:  Copyright (C) 1985, Nantucket Inc.
* NOTES.....:  Produces Clipper .NTX (Index) files

* REVISONS..:  John Wright - 09/14/87
*              Added ability to display NTX value.
*              Dates sorted using DTOS not DTOC.

* Revised - 08/06/88 - ability to Escape from screen
* Revised - 11/09/92 - took out macro use...

STORE SPACE(8) TO db,nt

CLEAR
SET CONFIRM ON
* If command line argument exists, check to see that it's a valid
* file name.  If not, quit program.
IF db <> SPACE(8)
   cDbfName=UPPER(db)
   cFileName= cDbfName+".DBF"
   IF .NOT. FILE(cFileName)
      ? cFileName +" does not exist"
      ? "Returning to DOS"
      RETURN
   ENDIF
   @ 10, 47 SAY cDbfName PICT "@!"
ENDIF

* If file name is valid or no name is given print initial screen
frame = "ͻȺ"
@ 6,26,8,53 BOX frame
@ 8,28 SAY "CLIPPER INDEXING UTILITY"
@ 1,0,7,79 BOX frame
stat_line = ""
SET COLOR TO 0/7
com_line="INDEX ON "
@ 23,0 SAY com_line + SPACE(79-LEN(com_line))
SET COLOR TO 7/0,0/7,0
@ 10, 20 SAY "Name of file to index....:"
* If no file name provided in command line prompt for one and check
* validity
IF db = SPACE(8)
   DO WHILE .T.
      cDbfName=SPACE(8)
      @ 10, 47 GET cDbfName PICT "@!"
      READ
      IF LASTKEY() = 27
         RETURN
      ENDIF
      cDbfName= TRIM(cDbfName)
      cFileName= cDbfName+".DBF"
      IF .NOT. FILE(cFileName)
         @ 21, 0
         @ 21, 27 SAY cFileName +" does not exist"
      ELSE
         EXIT
      ENDIF
   ENDDO
ENDIF
* reset default drive if necessary so that .NTX is on same drive
* as .DBF
IF SUBSTR(cDbfName,2,1)=":"
   start=3
   drive=SUBSTR(cDbfName,1,1)
   SET DEFAULT TO &drive
ELSE
   start=1
ENDIF
@ 21,0
@ 22,3 SAY "Indexing: "+cFileName
USE &cDbfName
* erase smaller box
@ 6,26,8,53 BOX ""
@ 7,20 SAY REPL("",35)
add_on=""
A=1
ROW = 2
COL = 3
* get fieldnames and print in box
DO WHILE A < 26
   FOR X = A TO A+4
      @ ROW,COL SAY FIELDNAME(X)
      ROW=ROW+1
   NEXT
   IF "" = FIELDNAME(X)
      EXIT
   ELSE
      ROW=2
      A=A+5
      COL=COL+15
   ENDIF
ENDDO

IF nt <> SPACE(8)
   ntx_file=UPPER(nt)+SPACE(8)
ELSE
   ntx_file=cDbfName+SPACE(8)
ENDIF
ntx_file=SUBSTR(ntx_file,1,8)

over_write="N"
DO WHILE .T.
   @ 11,27 SAY "NTX file name.....:"
   @ 11,47  GET ntx_file PICT "@!"
   READ
   IF LASTKEY() = 27
      RETURN
   ENDIF
   IF start = 3
      ntx_file=drive+":"+ntx_file
   ENDIF
   IF FILE(NTX_FILE+".NTX")
      STORE "Y" TO jdw_view
      @ 13,18 SAY "NTX file exists... view index key? " GET jdw_view PICT "Y"
      READ
      @ 13,0
      IF jdw_view = "Y"
         USE (cDbfName) INDEX (ntx_file)
         STORE INDEXKEY(0) TO chk_key
         @ 13,10 SAY "Index key: "+chk_key
         USE (cDbfName)
      ENDIF
      @ 16,15 SAY "File already exists....Overwrite? " GET over_write PICT "Y"
      READ
      @ 12,0 CLEAR TO 22,80
      IF over_write = "Y"
         EXIT
      ELSE
         ntx_file=SPACE(8)
      ENDIF
   ELSE
      EXIT
   ENDIF
ENDDO
@ 16,0
ROW=12
FIELD="f"
index_size=0
cmd_size=21
field_cnt=0
DO WHILE "" <> TRIM(FIELD) .AND. index_size<=100 .AND. cmd_size<=254
   @ ROW,23 SAY "    Index field.......:"
   DO WHILE .T. .AND. "" <> TRIM(FIELD)
      FIELD=SPACE(10)
      @ ROW,47 GET FIELD PICT "!!!!!!!!!!"
      READ
      @ 21,0
      FIELD=TRIM(FIELD)
      DO CASE
      CASE FIELD="RECNO()"
         FIELD="STR(RECNO(),10)"
         field_cnt=field_cnt+1
         index_size=index_size+10
         EXIT
      CASE TYPE("&field")="U" .AND. "" <> FIELD
         @ 21,0
         @ 21,27 SAY "Field does not exist"
      CASE TYPE("&field")="M"
         @ 21,0
         @ 21,20 SAY "Do you really want to index a memo field?"
      CASE TYPE("&field")="L"
         @ 21,0
         @ 21,27 SAY "Logical fields cannot be indexed"
      OTHERWISE
         DO CASE
         CASE TYPE("&field")="N"
            * STR() with no parameters returns field length &
            * decimals in Clipper
            index_size=index_size+LEN(STR(&field))
            field_cnt=field_cnt+1
            FIELD="STR(&field)"
            EXIT
         CASE TYPE("&field")="D"
            FIELD="DTOS(&field)"
            index_size=index_size+8
            field_cnt=field_cnt+1
            EXIT
         OTHERWISE
            IF ""=TRIM(FIELD)
               add_on=" TO "+ntx_file
               EXIT
            ELSE
               index_size=index_size+LEN(&field)
               field_cnt=field_cnt+1
               EXIT
            ENDIF
         ENDCASE
      ENDCASE
   ENDDO
   stat_line=stat_line+"+"+TRIM(FIELD)
   * If first field print on command line without "+" otherwise
   * add a "+"
   IF "INDEX ON" = TRIM(com_line)
      com_line=com_line+TRIM(FIELD)
   ELSE
      com_line=com_line+"+"+TRIM(FIELD)
      * If command line larger than 78 scroll it off left side of screen
      wide =LEN(com_line)
      IF wide > 78
         com_line=SUBSTR(com_line,wide-78)
      ENDIF
   ENDIF
   SET COLOR TO 0/7
   @ 23,0 SAY com_line + SPACE(79-LEN(com_line))
   SET COLOR TO 7/0
   ROW=ROW+1
   cmd_size=LEN(stat_line)+21
   @ 22,55 SAY "key field size="+STR(index_size,3)
ENDDO
*Put finishing touches on command line
IF LEN(com_line) > 78
   com_line=SUBSTR(com_line,LEN(add_on)+1)+add_on
ELSE
   com_line=SUBSTR(com_line,1,LEN(com_line)-1)+add_on
ENDIF
SET COLOR TO 0/7
@ 23,0 SAY com_line + SPACE(79-LEN(com_line))
SET COLOR TO 7/0
IF index_size = 0
   CLEAR
   ? "No field specified for index key"
   ? "Returning to DOS"
   RETURN
ENDIF
IF index_size > 100
   CLEAR
   ? "Index key greater than 100 - Indexing aborted"
   ? "Returning to DOS"
   RETURN
ENDIF
IF cmd_size > 254
   CLEAR
   ? "Command line too long - Indexing aborted"
   ? "Returning to DOS"
   RETURN
ENDIF
*  If field date or numeric and only field, strip functions
IF field_cnt=1 .AND. "DTOC(" $ stat_line
   stat_line=SUBSTR(stat_line,7,AT(")",stat_line)-7)
   com_line="INDEX ON "+stat_line+add_on
   SET COLOR TO 0/7
   @ 23,0 SAY com_line + SPACE(79-LEN(com_line))
   SET COLOR TO 7/0
ELSE
   IF field_cnt=1 .AND. "STR(" $ stat_line
      stat_line=SUBSTR(stat_line,6,AT(")",stat_line)-6)
      com_line="INDEX ON "+stat_line+add_on
      SET COLOR TO 0/7
      @ 23,0 SAY com_line + SPACE(79-LEN(com_line))
      SET COLOR TO 7/0
   ELSE
      stat_line=SUBSTR(stat_line,2,LEN(stat_line)-2)
   ENDIF
ENDIF
records = STR(LASTREC())
INDEX ON &stat_line TO &ntx_file
CLOSE DATABASES
RETURN


*: EOF: UTIL_NTX.PRG
