*:*****************************************************************************
*:
*: Procedure file: C:\UTILS\UTIL_DD.PRG
*:
*:         System: No Frill Utils for Clipper
*:         Author: John Wright
*:      Copyright (c) 1990-1993, John Wright
*:  Last modified: 04/16/91     10:36
*:
*:  Procs & Fncts: SR_MAKE()
*:
*:         Set by: UTILS.PRG                         
*:
*:          Calls: CENTER()           (function  in UTILS.PRG)
*:               : BOX_IT()           (function  in UTILS.PRG)
*:               : SR_MAKE()          (function  in UTIL_DD.PRG, called from Achoice())
*:
*:           Uses: TEMPFILE.DBF       
*:
*:    Other Files: AUTO_DD.TXT
*:               : AUTO_DBF.TXT
*:
*:      Documented 08/08/93 at 10:32                SNAP!  version 5.02
*:*****************************************************************************
* Create code for MASTER.CFG file and the Data Dictionary.
* This requires an actual database to read the structure from.
* 04/15/91 - Created this code
*
CLEAR

numfiles=ADIR("*.dbf")

IF numfiles > 0
   DECLARE Files[numfiles]
   ADIR("*.dbf",Files)
   ASORT(Files)
ELSE
   Center("Cannot find any database files in the current directory.",10)
   @ 20,0
   WAIT "Unable to process...  press any key"
   RETURN
ENDIF

STORE 0 TO jdw_done
STORE 80 TO jdw_dflt
STORE "Y" TO ans

box_it("CREATE TEXT FILE WITH DBF STRUCTURES",3)
IF FILE("auto_dd.txt")
   @ 10,19 SAY "Do you want to overwrite AUTO_DD.TXT? " GET ans PICT 'Y'
   @ 12,19 SAY "This will erase any previous code in the file."
   READ
ENDIF

IF ans <> "Y" .OR. LASTKEY() = 27
   RETURN
ENDIF

STORE 7+numfiles TO B
IF B > 20
   STORE 20 TO B
ENDIF
SET ALTERNATE TO auto_dd.txt

@  8,1 CLEAR TO 19,79
@  8,14 SAY "Press Enter to process a database."
IF numfiles > 1
   @ 10,14 SAY "Move through the list with the"
   @ 11,14 SAY "cursor keys."
   @ 13,14 SAY "Press [Esc] to exit."
ELSE
   @ 10,14 SAY "Press [Esc] to exit."
ENDIF
@ 7,54 TO B+1,67
DO WHILE LASTKEY() <> 27
   chosen=ACHOICE(8,55,B,66,Files,.T.,"sr_make")
ENDDO

SET ALTERNATE ON
?""
SET ALTERNATE OFF
SET ALTERNATE TO

IF jdw_done = 0
   ERASE auto_dbf.txt
ENDIF

IF FILE("TEMPFILE.DBF")
   ERASE tempfile.dbf
ENDIF

RETURN

*!*****************************************************************************
*!
*!       Function: SR_MAKE()
*!
*!      Called by: UTIL_DD.PRG                       
*!
*!          Calls: CENTER()           (function  in UTILS.PRG)
*!
*!           Uses: TEMPFILE.DBF       
*!
*!*****************************************************************************
FUNCTION sr_make
PARAMETERS mode, c_chosen, w_posit

IF mode = 3
   IF LASTKEY() = 27
      RETURN 0
   ENDIF
   IF LASTKEY() <> 13
      RETURN 2
   ENDIF
ELSE
   RETURN 2
ENDIF

STORE Files[c_chosen] TO jdw_dbf
USE (jdw_dbf)
COPY TO tempfile STRUCTURE EXTENDED
USE tempfile

SET CONSOLE OFF
SET ALTERNATE ON

DO WHILE .NOT. EOF()
   
   ?LOWER(LEFT(jdw_dbf,LEN(jdw_dbf)-4))+CHR(250)
   ??LOWER(TRIM(field_name))+CHR(250)
   ??LOWER(TRIM(field_type))+CHR(250)
   ??LTRIM(STR(field_len))+CHR(250)
   ??LTRIM(STR(field_dec))+CHR(250)
   ??"<< comment >>"+CHR(250)+CHR(250)
   SKIP
   
ENDDO

SET ALTERNATE OFF
SET CONSOLE ON

STORE jdw_done+1 TO jdw_done
@ 22,0
IF jdw_done = 1
   Center("1 database done!",22)
ELSE
   Center(LTRIM(STR(jdw_done))+" databases done!",22)
ENDIF

USE
RETURN 2

*: EOF: UTIL_DD.PRG
