*:*****************************************************************************
*:
*: Procedure file: C:\UTILS\UTILS.PRG
*:
*:         System: No Frill Utils for Clipper
*:         Author: John Wright
*:      Copyright (c) 1990-1993, John Wright
*:  Last modified: 11/09/92      9:31
*:
*:  Procs & Fncts: BOX_IT()
*:               : CENTER()
*:               : LSTR()
*:
*:          Calls: UTIL_VEW.PRG
*:               : BOX_IT()           (function  in UTILS.PRG)
*:               : CENTER()           (function  in UTILS.PRG)
*:               : UTILLOAD.PRG
*:               : UTIL_RPL.PRG
*:               : UTIL_DD.PRG
*:               : UTIL_DBF.PRG
*:               : UTIL_NTX.PRG
*:               : UTIL_KEY.PRG
*:               : MEMFEDIT.PRG
*:
*:      Documented 08/08/93 at 10:32                SNAP!  version 5.02
*:*****************************************************************************
* 08/06/88   No-frill utilities to make programming in Clipper easier.
* 11/20/88 - Added ability to create menu code for light bar
* 04/16/89 - View database records of more than 128 fields
* 08/04/89 - Incorporated program to edit MEM files (Nantucket News)
* 03/23/90 - Made minor changes to some programs
* 05/23/90 - Documented the system using SNAP
* 04/16/91 - Added ability to create DBF data dictionary format for use
*            with the Stride Rite MASTER.CFG file.
* 10/09/91 - Added ability to load fields into memory variables.

STORE PCOUNT() TO cmd_args       && command line arguments to view a database
IF cmd_args > 0
   DO CASE
   CASE cmd_args = 3
      PARAMETERS cmd1,cmd2,cmd3
      DO util_vew WITH cmd1,cmd2,cmd3
   CASE cmd_args = 2
      PARAMETERS cmd1,cmd2
      STORE "1" TO cmd3
      DO util_vew WITH cmd1,cmd2,cmd3
   CASE cmd_args = 1
      PARAMETERS cmd1
      STORE "1" TO cmd2,cmd3
      DO util_vew WITH cmd1,cmd2,cmd3
   ENDCASE
   QUIT
ELSE
   RELEASE cmd_args
ENDIF

STORE 0 TO choice
SET CONFIRM ON
SET WRAP ON

DO WHILE LASTKEY() <> 999
   
   SET MESSAGE TO 24 Center
   
   CLEAR
   @ 01,00,23,79 BOX ""
   box_it("CLIPPER PROGRAMMING UTILITES",3)
   @ 08,23,18,56 BOX "͸Գ "
   CENTER(" [Esc] to exit ",18,23,56)
   @ 10,26 PROMPT "1 - Load fields to variables";
      MESSAGE "Generate program code to load fields into memory variables"
   @ 11,26 PROMPT "2 - Replacing records";
      MESSAGE "Generate REPLACE statement for memory variables"
   @ 12,26 PROMPT "3 - DBF structures";
      MESSAGE "Generate Data Dictionary text for DBF file structures"
   @ 13,26 PROMPT "4 - Creating databases";
      MESSAGE "Generate code to create database files from in PRG"
   @ 14,26 PROMPT "5 - Index databases";
      MESSAGE "Create index files (NTX) for database files"
   @ 15,26 PROMPT "6 - Key pressed";
      MESSAGE "Find the values of INKEY() and LASTKEY()"
   @ 16,26 PROMPT "7 - Edit MEM files";
      MESSAGE "Convert MEM to TXT file and modify items"
   MENU TO choice
   
   DO CASE
   CASE choice = 0
      CLEAR
      QUIT
   CASE choice = 1
      DO utilload
   CASE choice = 2
      DO util_rpl
   CASE choice = 3
      DO util_dd
   CASE choice = 4
      DO util_dbf
   CASE choice = 5
      DO util_ntx
   CASE choice = 6
      DO util_key
   CASE choice = 7
      * Have to get rid of this variable or else it will be added
      * to the MEM file that is edited...
      RELEASE choice
      DO memfedit
      STORE 7 TO choice
   ENDCASE
   
ENDDO

RETURN


************************>>>  USER DEFINED FUNCTIONS  <<<**********************

*!*****************************************************************************
*!
*!       Function: BOX_IT()
*!
*!      Called by: UTILS.PRG                         
*!               : UTILLOAD.PRG                      
*!               : UTIL_RPL.PRG                      
*!               : UTIL_DD.PRG                       
*!               : UTIL_DBF.PRG                      
*!
*!*****************************************************************************
FUNCTION box_it
* Center a message on the screen and put a box around it
PARAMETERS jdw_txt,jdw_row
SETCOLOR("N/W")
jdw_txt = LTRIM(TRIM(jdw_txt))
jdw_left = INT(LEN(jdw_txt) / 2)
* adjust box if it is not even
jdw_right = IF(LEN(jdw_txt) = jdw_left*2,jdw_left-1,jdw_left)
* the extra spaces fill in the screen color if it is different
@ jdw_row+1,39-jdw_left SAY " "+jdw_txt+" "
@ jdw_row,(38-jdw_left),jdw_row+2,(42+jdw_right) BOX "͸Գ"
SETCOLOR("W/N")
RETURN("")


*!*****************************************************************************
*!
*!       Function: CENTER()
*!
*!      Called by: UTILS.PRG                         
*!               : UTILLOAD.PRG                      
*!               : UTIL_RPL.PRG                      
*!               : UTIL_DD.PRG                       
*!               : UTIL_DBF.PRG                      
*!               : JDWLOAD()          (function  in UTILLOAD.PRG, called from Achoice())
*!               : JDWREPL()          (function  in UTIL_RPL.PRG, called from Achoice())
*!               : SR_MAKE()          (function  in UTIL_DD.PRG, called from Achoice())
*!               : JDWMAKE()          (function  in UTIL_DBF.PRG, called from Achoice())
*!
*!*****************************************************************************
FUNCTION Center
* Syntax: CENTER( <expC> , <expN1> [,<expN2>] [,<expN3>] )
* Variables: expC  = Character String to center, expN1 = Row
* Optional=>   expN2 = left-end column, expN3 = right-end column
* Returnd: @ say on expN1, between expN3 and expN2, the String ExpC.
* Example: CENTER("test",5,10,70) will display on line 5,
*          centered between 10 and 70 the word "test"
IF PCOUNT() = 2
   PARAMETERS cl_str,cl_row
   STORE 0 TO cl_left
   STORE 80 TO cl_right
ELSE
   PARAMETERS cl_str,cl_row,cl_left,cl_right
ENDIF
STORE (cl_right - cl_left) - LEN(cl_str) TO cl_col
IF cl_col > 0
   @ cl_row,cl_left+(cl_col/2) SAY cl_str
   RETURN .T.
ENDIF
RETURN .F.


*!*****************************************************************************
*!
*!       Function: LSTR()
*!
*!*****************************************************************************
FUNCTION Lstr
* Syntax: LSTR( <numeric> )
* Convert a numeric expression to a character string with no spaces
PARAMETER num2chr
RETURN LTRIM(STR(num2chr))


*: EOF: UTILS.PRG
