/*
 * File......: DISPMSG.PRG
 * Author....: Paul Ferrara
 * CIS ID....: 76702,556
 * Date......: $Date:   15 Aug 1991 23:05:14  $
 * Revision..: $Revision:   1.2  $
 * Log file..: $Logfile:   E:/nanfor/src/dispmsg.prv  $
 *
 * This function is an original work by Paul Ferrar and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/dispmsg.prv  $
 * 
 *    Rev 1.2   15 Aug 1991 23:05:14   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:51:36   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   01 Apr 1991 01:01:12   GLENN
 * Nanforum Toolkit
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FT_DISPMSG()
 *  $CATEGORY$
 *     Menus/Prompts
 *  $ONELINER$
 *     Display a message and optionally waits for a keypress
 *  $SYNTAX$
 *     FT_DISPMSG( <aMessageArray>, [ <cKey2Check> ],
 *                 [ <nTopBoxRow> ], [ <nLeftBoxColumn> ],
 *                 [ <cBoxType> ], [ <lShadow> ] ) -> lKeyMatch
 *  $ARGUMENTS$
 *     <aMessageArray> is a multidimensional array of messages to be
 *     displayed and the color attributes for each message.
 *
 *     The first dimension of the array contains one or more elements,
 *     each representing one line in the message box, up to the maximum
 *     number of rows on the screen.
 *
 *     The second dimension of the array contains a color attribute for
 *     the corresponding element in dimension one, plus one additional
 *     element for the color of the box border.  Dimension two will
 *     always contain one more element than dimension one.  If an
 *     attribute is omitted, the last color selected will be used.
 *
 *     <Key2Check> is a character string of one or more keys to check
 *     for.  If omitted, the message is displayed and control is returned
 *     to the calling procedure.  If one character is specified,
 *     FT_DISPMSG() waits for one keypress, restores the screen and
 *     returns.  If multiple characters are specified, FT_DISPMSG()
 *     remains in a loop until one of the specified keys has been
 *     pressed, then restores the screen and returns.
 *
 *     <nTopBoxRow> is the upper row for the message box.  If omitted, the
 *     box is centered vertically.
 *
 *     <nLeftBoxColumn> is the leftmost column for the box.  If omitted, the
 *     box is centered horizontally.
 *
 *     <cBoxType> is a string of characters or a variable for the box
 *     border.  See the @...BOX command.  If omitted, a double box is
 *     drawn.
 *
 *     <lShadow> is a logical variable.  If true (.T.) or omitted, it
 *     uses FT_SHADOW() to add a transparent shadow to the box.  If
 *     false (.F.), the box is drawn without the shadow.
 *  $RETURNS$
 *     If <Key2Check> is not specified, FT_DISPMSG() will return false
 *     (.F.).
 *
 *     If <Key2Check> is a one-character string, FT_DISPMSG() will return
 *     true (.T.) if the user presses that key, or false (.F.) if any
 *     other key is pressed.
 *
 *     If <Key2Check> consists of multiple characters, it will lock the
 *     user in a loop until one of those keys are pressed and return the
 *     INKEY() value of the keypress.
 *  $DESCRIPTION$
 *     FT_DISPMSG() is a multi-purpose pop-up for user messages.
 *     Multiple lines may be displayed, each with a different attribute.
 *     The box will be automatically centered on the screen, or the row
 *     and/or column can be specified by the programmer.  It also centers
 *     each line of the message within the box.
 *  $EXAMPLES$
 *     The following example displays a simple two-line message
 *     and returns immediately to the calling routine.
 *
 *        FT_DISPMSG( { { "Printing Report"                    , ;
 *                        "Press [ESC] To Interrupt" }         , ;
 *                      { "W+/B*", "W/B", "GR+/B" } } )
 *
 *     The next example displays a message and waits for a key press.
 *
 *        FT_DISPMSG( { { "Press [D] To Confirm Deletion"      , ;
 *                        "Or Any Other Key To Abort" }        , ;
 *                      { "W+/B", "W+/B", "GR+/B" } }          , ;
 *                      "D" )
 *
 *     The next example displays a one-line message centered on row 5
 *     and returns to the calling procedure.
 *
 *        FT_DISPMSG( { { "Please Do Not Interrupt" }   , ;
 *                      { "W+/B", "GR+/B" } }          , ;
 *                      , 5, )
 *  $END$
 */


#ifdef FT_TEST

   PROCEDURE DUMMY
   LOCAL X

   // EXAMPLE #1 - DISPLAYS BOX AND RETURNS
   SETCOLOR( "W/N" )
   CLS
   FT_DISPMSG( { { "This is message #1"                 , ;
                   "This is another message - line 2"   , ;
                   "This is the third line, etc" }      , ;
                 { "W+/B", "W/B", "R/BG*", "GR+/B" } } )

   FT_DISPMSG( { { "Press Any Key To Continue" }, { "W/B", "W+/B" } }," ",20,0 )

   // example #2 - displays box and waits for input
   // then restores the screen and returns
   IF FT_DISPMSG( { { "Press [D] To Delete"                , ;
                      "Or Any Other Key To Abort" }        , ;
                    { "W+/R*", "W/R", "W+/R" } }           , ;
                      "D", 5 , 5 )
      FT_DISPMSG( { { 'You Pressed "D"', "Press Any Key To Continue" }, { "W+/B*", "W/B", "W+/B" } }," ",19,0 )
   ELSE
      FT_DISPMSG( { { 'You Did NOT Press "D"', "Press Any Key To Continue" }, { "W+/B*", "W/B", "W+/B" } }," ",19,0 )
   ENDIF

   // example #3 - displays box and waits for input / multiple keys
   // then restores the screen and returns
   x= FT_DISPMSG( { { "Press [D] To Delete"                   , ;
                      "[A] To Add New Record"                 , ;
                      "[F] To Find A Record"                  , ;
                      "Or [ESCape] To Abort"  }               , ;
                    { "N/G",,,, "W+/G" } }                    , ;
                      "DAF"+CHR(27) )
   IF x == 27
      FT_DISPMSG( { { 'You Pressed ESCAPE', "Press Any Key To Continue" }, { "W+/B*", "W/B", "W+/B" } }," ",19,0 )
   ELSE
      FT_DISPMSG( { { 'You Pressed '+ CHR(x), "Press Any Key To Continue" }, { "W+/B*", "W/B", "W+/B" } }," ",19,0 )
   ENDIF

   QUIT

#endif



FUNCTION FT_DISPMSG( aInfo, cKey, nTop, nLeft, cBoxType, lShadow )

   LOCAL lRtnVal := .f., nWidest := 0, nRight, nBottom
   LOCAL cOldScreen, cOldCursor, cOldColor, i, nOption

   AEVAL( aInfo[1], {|x| nWidest := MAX( nWidest, LEN( x ) ) } )

   IF nLeft == NIL
      nLeft := (MAXCOL() - nWidest - 4) / 2
   ENDIF
   nRight := nLeft + nWidest + 5

   IF nTop == NIL
      nTop := (MAXROW() - LEN( aInfo[1] ) - 2) / 2 + 1
   ENDIF
   nBottom := nTop + LEN( aInfo[1] ) + 1

   cBoxType := IF( cBoxType == NIL, "ͻȺ ", cBoxType )

   cOldScreen := SAVESCREEN( nTop, nLeft, nBottom+1, nRight+2 )

   cOldCursor := SETCURSOR( 0 )

   IF lShadow == NIL .OR. lShadow
      FT_SHADOW( nTop, nLeft, nBottom, nRight )
   ENDIF

   // draw box
   cOldColor := SETCOLOR( aInfo[ 2, LEN( aInfo[2] ) ] )
   @ nTop, nLeft, nBottom, nRight BOX cBoxType

   // display messages
   FOR i := 1 TO LEN( aInfo[1] )
      IF aInfo[ 2, i ] != NIL
         SETCOLOR( aInfo[ 2, i ] )
      ENDIF
      @ nTop+i,                                       ;
        nLeft+( ( nWidest-LEN(aInfo[1,i]) ) / 2 ) + 3 ;
        SAY aInfo[1,i]
   NEXT

   IF cKey != NIL
      IF LEN( cKey ) == 1
         nOption := INKEY(0)
         IF UPPER( CHR( nOption) ) == cKey
            lRtnVal := .t.
         ENDIF
      ELSE
         nOption := 0
         DO WHILE AT( UPPER( CHR( nOption ) ), UPPER( cKey ) ) == 0
            nOption := INKEY(0)
         ENDDO
         lRtnVal := nOption  //TGFWT! (Thank God For Weak Typing)
      ENDIF
      RESTSCREEN( nTop, nLeft, nBottom+1, nRight+2, cOldScreen )
   ENDIF

   SETCOLOR( cOldColor )
   SETCURSOR( cOldCursor )
   RETURN lRtnVal
