; File......: SAVEATT.ASM
; Author....: Ted Means
; Date......: $Date:   03 Oct 1992 14:35:14  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   C:/nanfor/src/saveatt.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   C:/nanfor/src/saveatt.asv  $
;  
;     Rev 1.2   03 Oct 1992 14:35:14   GLENN
;  Ted Means made modifications to support use of dispBegin()/dispEnd().
;  
;     Rev 1.1   15 Aug 1991 23:07:58   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.0   12 Jun 1991 01:30:20   GLENN
;  Initial revision.
;


;  $DOC$
;  $FUNCNAME$
;     FT_SAVEATT()
;  $CATEGORY$
;     Video
;  $ONELINER$
;     Save the attribute bytes of a specified screen region.
;  $SYNTAX$
;     FT_SAVEATT( <nTop>, <nLeft>, <nBottom>, <nRight>  ) -> cAttributes
;  $ARGUMENTS$
;     <nTop>, <nLeft>, <nBottom>, and <nRight> define the screen region.
;  $RETURNS$
;     A character string containing the screen attribute bytes for the
;     specified region.  If the memory to store the return value could
;     not be allocated, the function returns NIL.
;  $DESCRIPTION$
;     This function is similar to Clipper's SaveScreen(), except that it only
;     saves the attribute bytes.  This is useful if you want to change the
;     screen color without affecting the text.
;
;     *** INTERNALS ALERT ***
;
;     This function calls the Clipper internal __gtMaxCol to obtain the
;     maximum column value for the current video mode.  If you're too gutless
;     to use internals, then this function isn't for you.
;  $EXAMPLES$
;     // Save attributes of row 4
;     cBuffer := FT_SAVEATT( 4, 0, 4, maxcol())
;
;     // Save attributes from middle of screen
;     cBuffer := FT_SAVEATT(10,20,14,59)
;  $SEEALSO$
;     FT_RESTATT()
;  $END$
;

IDEAL

Public   FT_SaveAtt

Extrn    __ParNI:Far
Extrn    __RetCLen:Far
Extrn    __xGrab:Far
Extrn    __xFree:Far
Extrn    __gtSave:Far                        ; ** INTERNAL **

nTop     EQU       Word Ptr BP - 2
nLeft    EQU       Word Ptr BP - 4
nBottom  EQU       Word Ptr BP - 6
nRight   EQU       Word Ptr BP - 8
nAttr    EQU       Byte Ptr BP - 10
nBufLen  EQU       Word Ptr BP - 12

cBuffer  EQU       DWord Ptr BP - 16
nBufOfs  EQU       Word Ptr BP - 16
nBufSeg  EQU       Word Ptr BP - 14

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_SaveAtt          Far

         Push      BP                        ; Save BP
         Mov       BP,SP                     ; Set up stack reference
         Sub       SP,16                     ; Allocate locals

         Mov       CX,4                      ; Set param count
@@Coord: Push      CX                        ; Put on stack
         Call      __ParNI                   ; Retrieve param
         Pop       CX                        ; Get count back
         Push      AX                        ; Put value on stack
         Loop      @@Coord                   ; Get next value

         Pop       [nTop]                    ; Store top coordinate
         Pop       [nLeft]                   ; Store left coordinate
         Pop       [nBottom]                 ; Store bottom coordinate
         Pop       [nRight]                  ; Store right coordinate

         Mov       AX,[nBottom]              ; Load bottom coordinate
         Sub       AX,[nTop]                 ; Subtract top
         Inc       AX                        ; Calc length

         Mov       CX,[nRight]               ; Load right coordinate
         Sub       CX,[nLeft]                ; Subtract left
         Inc       CX                        ; Calc width
         Mul       CX                        ; Multiply length by width
         SHL       AX,1                      ; Calc buffer size
         Mov       [nBufLen],AX              ; Store buffer size

@@Alloc: Push      AX                        ; Put size on stack
         Call      __xGrab                   ; Allocate memory
         Add       SP,2                      ; Realign stack
         Mov       [nBufSeg],DX              ; Store segment
         Mov       [nBufOfs],AX              ; Store offset

         Push      DX                        ; Load parameters for __gtSave
         Push      AX                        ; onto stack
         Push      [nRight]
         Push      [nBottom]
         Push      [nLeft]
         Push      [nTop]
         Call      __gtSave                  ; Grab screen image

         Push      DS                        ; Save required registers
         Push      SI
         Push      DI

         Mov       DS,[nBufSeg]              ; Load pointer to buffer
         Mov       SI,[nBufOfs]              ; into DS:SI

         Push      DS                        ; Duplicate pointer in ES:DI
         Push      SI
         Pop       DI
         Pop       ES
         Inc       SI                        ; Start with attribute byte

         Mov       CX,[nBufLen]              ; Load buffer length
         SHR       CX,1                      ; Divide by two
@@Attr:  Lodsw                               ; Grab a screen word
         Stosb                               ; Store attribute only
         Loop      @@Attr                    ; Do next

         Pop       DI                        ; Restore registers
         Pop       SI
         Pop       DS

Done:    Mov       AX,[nBufLen]              ; Load buffer length
         SHR       AX,1                      ; Divide by 2
         Push      AX                        ; Put length on stack
         Push      [nBufSeg]                 ; Put segment on stack
         Push      [nBufOfs]                 ; Put offset on stack
         Call      __RetClen                 ; Return attribute string
         Call      __xFree                   ; Free memory
         Mov       SP,BP                     ; Realign stack
         Pop       BP                        ; Restore BP
         Ret
Endp     FT_SaveAtt
Ends     _NanFor
End
