; File......: ADAPTER.ASM
; Author....: Ted Means
; Date......: $Date:   17 Aug 1993 19:25:38  $
; Revision..: $Revision:   1.3  $
; Log file..: $Logfile:   C:/nanfor/src/adapter.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   C:/nanfor/src/adapter.asv  $
;  
;     Rev 1.3   17 Aug 1993 19:25:38   GLENN
;  Ted modified so it would work in protected mode.
;  
;     Rev 1.2   15 Aug 1991 23:07:18   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:18   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:08   GLENN
;  Nanforum Toolkit
;  
;



;  $DOC$
;  $FUNCNAME$
;     FT_ADAPTER()
;  $CATEGORY$
;     Video
;  $ONELINER$
;     Report the type of video adapter installed
;  $SYNTAX$
;     FT_ADAPTER() -> nResult
;  $ARGUMENTS$
;     None
;  $RETURNS$
;     Integer representing type of video adapter
;
;        0 - monochrome
;        1 - CGA
;        2 - EGA
;        3 - VGA
;  $DESCRIPTION$
;     This function is valuable if you use a graphics library and need to
;     know what type of graphics adapter is installed.
;
;     The source code is written to adhere to Turbo Assembler's IDEAL mode.
;     To use another assembler, you will need to rearrange the PROC and
;     SEGMENT directives, and also the ENDP and ENDS directives (a very
;     minor task).
;  $EXAMPLES$
;     iVideo := FT_ADAPTER()
;
;     DO CASE
;        CASE iVideo == 0
;           QOUT( "You have a monochrome adapter." )
;        CASE iVideo == 1
;           QOUT( "You have a CGA adapter." )
;        CASE iVideo == 2
;           QOUT( "You have an EGA adapter." )
;        CASE iVideo == 3
;           QOUT( "You have a VGA adapter." )
;     ENDCASE
;  $SEEALSO$
;     FT_SETMODE()
;  $END$
;

IDEAL

Public   FT_ADAPTER

Extrn    __RetNI:Far

Segment  _NanFor   Word      "CODE"
         Assume    CS:_NanFor

Proc     FT_ADAPTER          Far

         Mov       AX,40h
         Mov       ES,AX
         Xor       AX,AX
         Cmp       [Word Ptr ES:63h],3B4h
         JE        Done

IsVGA:   Mov       AX,1A00h                  ; VGA-only BIOS call
         Int       10h                       ; Call video BIOS
         Cmp       AL,1Ah                    ; See if call supported
         JNE       IsEGA                     ; If not, try EGA
         Mov       AX,3                      ; Indicate VGA
         JMP       Short Done                ; Return to application

IsEGA:   Mov       AH,12h                    ; EGA-only BIOS call
         Mov       BL,10h                    ; Set BL to test value
         Int       10h                       ; Call video BIOS
         Cmp       BL,10h                    ; Did BL change?
         JE        IsCGA                     ; No, so it's a CGA
         Mov       AX,2                      ; Indicate EGA
         Jmp       Short Done                ; Return to application

IsCGA:   Mov       AX,1                      ; Indicate CGA

Done:    Push      AX                        ; Save adapter type on stack
         Call      __RetNI                   ; Return it
         Pop       AX
         RetF
Endp     FT_ADAPTER
Ends     _NanFor
End
