* AUTOREPL.prg - 08/05/88                                       by John Wright
* Create code to do a REPL to a database after using the UDF called AUTOMEM.
* The code will need to be included in the PRG files but it is an easier way
* than typing it in each time.
*
CLEAR
numfiles=ADIR("*.dbf")

IF numfiles > 0
 DECLARE files[numfiles]
 ADIR("*.dbf",files)
 ASORT(files)
ELSE
 CENTER("Cannot find any database files in the current directory.",10)
 @ 20,0
 WAIT "Unable to process...  press any key"
 RETURN
ENDIF

STORE 0 TO jdw_DONE
STORE 80 TO jdw_DFLT
STORE 2 TO jdw_IND
STORE "X " TO jdw_PREF
STORE "Y" TO ans

BOX_IT("MAKE PROGRAM CODE TO REPLACE DATABASE RECORDS",3)
@  8,19 SAY "Enter the prefix for memory variables: " GET jdw_PREF
@ 10,19 SAY "Enter number of columns to indent code: " GET jdw_IND PICT '9'
IF FILE("auto_rpl.txt")
 @ 14,19 SAY "Do you want to overwrite AUTO_RPL.TXT? " GET ans PICT 'Y'
 @ 16,19 SAY "This will erase any previous code in the file."
ENDIF
READ

IF ans <> "Y" .OR. LASTKEY() = 27
 RETURN
ENDIF

STORE LTRIM(TRIM(jdw_PREF)) TO jdw_PREF
STORE 7+numfiles TO b
IF b > 20
 STORE 20 TO b
ENDIF
SET ALTERNATE TO auto_rpl.txt

@  8,1 CLEAR TO 19,79
@  8,14 SAY "Press Enter to process a database."
IF numfiles > 1
 @ 10,14 SAY "Move through the list with the"
 @ 11,14 SAY "cursor keys."
 @ 13,14 SAY "Press [Esc] to exit."
ELSE
 @ 10,14 SAY "Press [Esc] to exit."
ENDIF
@ 7,54 TO b+1,67
DO WHILE LASTKEY() <> 27
  chosen=ACHOICE(8,55,b,66,files,.T.,"jdwrepl")
ENDDO

SET ALTERNATE TO
IF jdw_DONE = 0
 ERASE auto_rpl.txt
ENDIF

RETURN

******************************************************************************

FUNCTION jdwrepl
PARAMETERS mode, c_chosen, w_posit

IF mode = 3
 IF LASTKEY() = 27
  RETURN 0
 ENDIF
 IF LASTKEY() <> 13
  RETURN 2
 ENDIF
ELSE
 RETURN 2
ENDIF

STORE files[c_chosen] TO jdw_DBF
USE &jdw_DBF

STORE "REPL " TO linestr

SET CONSOLE OFF
SET ALTERNATE ON

FOR X = 1 TO FCOUNT()

  STORE FIELD(x)+" WITH "+jdw_PREF+FIELD(x)+", " TO smallstr

  IF LEN(linestr)+LEN(smallstr)+1 < jdw_DFLT-jdw_IND
     STORE linestr+smallstr TO linestr
  ELSE
     ?SPACE(jdw_IND)+linestr+";"
     STORE smallstr TO linestr
  ENDIF

NEXT

?SPACE(jdw_IND)+SUBSTR(linestr,1,LEN(linestr)-2)   && Strip off the last ", "
?""
?""

SET ALTERNATE OFF
SET CONSOLE ON

STORE jdw_DONE+1 TO jdw_DONE
@ 22,0
IF jdw_DONE = 1
 CENTER("1 database done!",22)
ELSE
 CENTER(LTRIM(STR(jdw_DONE))+" databases done!",22)
ENDIF

CLOSE DATABASE
RETURN 2

