* UTILS.prg - 08/06/88
* No-frill utilities to make programming in Clipper easier.
*
* Author: John Wright   (72377,1770 on Compuserve)
*         WRIGHTware
*
* Revised - 11/20/88 - added ability to create menu code for light bar
* Revised - 04/16/89 - view database records of more than 128 fields
*
STORE PCOUNT() TO cmd_args       && command line arguments to view a database
IF cmd_args > 0
 DO CASE
 CASE cmd_args = 3
  PARAMETERS cmd1,cmd2,cmd3
  DO UTIL_VEW WITH cmd1,cmd2,cmd3
 CASE cmd_args = 2
  PARAMETERS cmd1,cmd2
  STORE "1" TO cmd3
  DO UTIL_VEW WITH cmd1,cmd2,cmd3
 CASE cmd_args = 1
  PARAMETERS cmd1
  STORE "1" TO cmd2,cmd3
  DO UTIL_VEW WITH cmd1,cmd2,cmd3
 ENDCASE
 QUIT
ENDIF

STORE 0 TO choice
SET CONFIRM ON
SET WRAP ON

DO WHILE LASTKEY() <> 999

 SET MESSAGE TO 23 CENTER

 CLEAR
 BOX_IT("DATABASE PROGRAMMING UTILITES",3)
 @  8,30 PROMPT "1 - Creating databases";
  MESSAGE "Create code to make database files"
 @  9,30 PROMPT "2 - Replacing records";
  MESSAGE "Create code to replace records with variables created by LOAD_MEM"
 @ 10,30 PROMPT "3 - LOAD_MEM() UDF code";
  MESSAGE "Create a file containing the code for LOAD_MEM"
 @ 11,30 PROMPT "4 - Create menu code";
  MESSAGE "Have program create menu code spaced correctly"
 @ 12,30 PROMPT "5 - Index databases";
  MESSAGE "Create index files (NTX) for database files"
 @ 13,30 PROMPT "6 - Key pressed";
  MESSAGE "Find the values of INKEY() and LASTKEY()"
 @ 15,30 PROMPT "0 - Exit";
  MESSAGE "Exit this program and return to DOS"
 MENU TO choice

 DO CASE
 CASE choice = 1
  DO UTIL_DBF
 CASE choice = 2
  DO UTIL_RPL
 CASE choice = 3
  DO UTIL_UDF
 CASE choice = 4
  DO UTIL_MNU
 CASE choice = 5
  DO UTIL_NTX
 CASE choice = 6
  DO UTIL_KEY
 CASE choice = 7
  CLEAR
  QUIT
 ENDCASE

ENDDO

RETURN


************************>>>  USER DEFINED FUNCTIONS  <<<**********************

FUNCTION BOX_IT
* Center a message on the screen and put a box around it
PARAMETERS jdw_txt,jdw_row
SETCOLOR("N/W")
jdw_txt = LTRIM(TRIM(jdw_txt))
jdw_left = INT(LEN(jdw_txt) / 2)
* adjust box if it is not even
jdw_right = IF(LEN(jdw_txt) = jdw_left*2,jdw_left-1,jdw_left)
* the extra spaces fill in the screen color if it is different
@ jdw_row+1,39-jdw_left SAY " "+jdw_txt+" "
@ jdw_row,(38-jdw_left),jdw_row+2,(42+jdw_right) BOX "͸Գ"
SETCOLOR("W/N")
RETURN("")


FUNCTION CENTER
* Syntax: CENTER( <expC> , <expN1> [,<expN2>] [,<expN3>] )
* Variables: expC  = Character String to center, expN1 = Row
* Optional=>   expN2 = left-end column, expN3 = right-end column
* Returnd: @ say on expN1, between expN3 and expN2, the String ExpC.
* Example: CENTER("test",5,10,70) will display on line 5,
*          centered between 10 and 70 the word "test"
IF PCOUNT() = 2
 PARAMETERS cl_str,cl_row
 STORE 0 TO cl_left
 STORE 80 TO cl_right
ELSE
 PARAMETERS cl_str,cl_row,cl_left,cl_right
ENDIF
STORE (cl_right - cl_left) - len(cl_str) TO cl_col
IF cl_col > 0
 @ cl_row,cl_left+(cl_col/2) say cl_str
 RETURN .T.
ENDIF
RETURN .F.


FUNCTION LSTR
* Syntax: LSTR( <numeric> )
* Convert a numeric expression to a character string with no spaces
PARAMETER num2chr
RETURN LTRIM(STR(num2chr))


