* UTIL_DBF.prg - 08/06/88                                       by John Wright
* Create code to do a CREATE a database file if it is not found in the current
* directory.  This requires an actual database to copy the structure from.
*
* Modified - 03/28/89 - put the IF FILE statement in code too.
*
CLEAR

numfiles=ADIR("*.dbf")

IF numfiles > 0
 DECLARE files[numfiles]
 ADIR("*.dbf",files)
 ASORT(files)
ELSE
 CENTER("Cannot find any database files in the current directory.",10)
 @ 20,0
 WAIT "Unable to process...  press any key"
 RETURN
ENDIF

STORE 0 TO jdw_DONE
STORE 80 TO jdw_DFLT
STORE 2 TO jdw_IND
STORE "Y" TO ans

BOX_IT("MAKE PROGRAM CODE TO CREATE DATABASE FILES",3)
@  8,19 SAY "Enter number of columns to indent code: " GET jdw_IND PICT '9'
IF FILE("auto_dbf.txt")
 @ 14,19 SAY "Do you want to overwrite AUTO_DBF.TXT? " GET ans PICT 'Y'
 @ 16,19 SAY "This will erase any previous code in the file."
ENDIF
READ

IF ans <> "Y" .OR. LASTKEY() = 27
 RETURN
ENDIF

STORE 7+numfiles TO b
IF b > 20
 STORE 20 TO b
ENDIF
SET ALTERNATE TO auto_dbf.txt

@  8,1 CLEAR TO 19,79
@  8,14 SAY "Press Enter to process a database."
IF numfiles > 1
 @ 10,14 SAY "Move through the list with the"
 @ 11,14 SAY "cursor keys."
 @ 13,14 SAY "Press [Esc] to exit."
ELSE
 @ 10,14 SAY "Press [Esc] to exit."
ENDIF
@ 7,54 TO b+1,67
DO WHILE LASTKEY() <> 27
  chosen=ACHOICE(8,55,b,66,files,.T.,"jdwmake")
ENDDO

SET ALTERNATE TO
IF jdw_DONE = 0
 ERASE auto_dbf.txt
ENDIF

IF FILE("TEMPFILE.DBF")
  ERASE TEMPFILE.DBF
ENDIF

RETURN

******************************************************************************

FUNCTION jdwmake
PARAMETERS mode, c_chosen, w_posit

IF mode = 3
 IF LASTKEY() = 27
  RETURN 0
 ENDIF
 IF LASTKEY() <> 13
  RETURN 2
 ENDIF
ELSE
 RETURN 2
ENDIF

STORE files[c_chosen] TO jdw_DBF
USE &jdw_DBF
COPY TO TEMPFILE STRUCTURE EXTENDED
USE TEMPFILE

SET CONSOLE OFF
SET ALTERNATE ON

?SPACE(jdw_IND)+'IF .NOT. FILE("'+jdw_DBF+'")'
?SPACE(jdw_IND+1)+'CREATE TEMPFILE.DBF'

DO WHILE .NOT. EOF()

  ?SPACE(jdw_IND+1)+'APPEND BLANK'
  ?SPACE(jdw_IND+1)+'REPL FIELD_NAME WITH "'+TRIM(FIELD_NAME)+'"'
  ??', FIELD_TYPE WITH "'+FIELD_TYPE+'"'
  ??', FIELD_LEN WITH '+LTRIM(STR(FIELD_LEN))

  IF FIELD_DEC <> 0
   ??', ;'
   ?SPACE(jdw_IND+1)+'FIELD_DEC WITH '+LTRIM(STR(FIELD_DEC))
  ENDIF

  SKIP

ENDDO

?SPACE(jdw_IND+1)+'CLOSE DATABASE'
?SPACE(jdw_IND+1)+'CREATE '+jdw_DBF+' FROM TEMPFILE'
?SPACE(jdw_IND+1)+'ERASE TEMPFILE.DBF'
?SPACE(jdw_IND)+'ENDIF'
?""
?""

SET ALTERNATE OFF
SET CONSOLE ON

STORE jdw_DONE+1 TO jdw_DONE
@ 22,0
IF jdw_DONE = 1
 CENTER("1 database done!",22)
ELSE
 CENTER(LTRIM(STR(jdw_DONE))+" databases done!",22)
ENDIF

CLOSE DATABASE
RETURN 2

