* UTIL_UDF.prg
* Create a text file called LOADMEM.TXT that contains the following code
*
SET ALTERNATE TO loadmem.txt
SET ALTERNATE ON
SET CONSOLE OFF

TEXT

FUNCTION LOAD_MEM
* Load values to memory variables.  (inspired by "Reference Clipper" article)
* Works like SCATTER in Foxbase or APPEND AUTOMEM in dBXL.
* Syntax -  LOAD_MEM( <jw_add> , <jw_new> )
* jw_add -  add a unique prefix to the variables.  Easier to RELEASE later and
*           works with the UTIL_RPL section for "automatic" replaces.
* jw_new -  .T. for "new" blank variables; .F. to load current record values
* Example - LOAD_MEM("x_",.T.)      && loads blank values to variables
* The database MUST be in use in the current work area for this to work.
PARAMETERS jw_add,jw_new
PRIVATE x
FOR x = 1 TO FCOUNT()
 STORE FIELD(x) TO jw_fld
 STORE jw_add+jw_fld TO jw_tmp
 STORE TYPE("&jw_fld") TO jw_type
 PUBLIC &jw_tmp
 DO CASE
 CASE jw_type $ "CNDL" .AND. .NOT. jw_new
  STORE &jw_fld. TO &jw_tmp.
 CASE jw_type = "C"
  STORE SPACE(LEN(&jw_fld)) TO &jw_tmp.
 CASE jw_type = "N"
  STORE 0 TO &jw_tmp.
 CASE jw_type = "D"
  IF LEN(DTOC(DATE())) = 8      && check if CENTURY OFF
   STORE CTOD("  /  /  ") TO &jw_tmp.
  ELSE
   STORE CTOD("  /  /    ") TO &jw_tmp.
  ENDIF
 CASE jw_type = "L"
  STORE .F. TO &jw_tmp.
 OTHERWISE
  * skip MEMO fields or any unknowns
 ENDCASE
NEXT
RETURN ""

ENDTEXT

SET CONSOLE ON
SET ALTERNATE OFF
SET ALTERNATE TO

RETURN
