* Program..: Bar.PRG
* Author...: Jon Wind     (original dBASE code)
* Author 2.: John Wright  (modified for Clipper)
* Version..: Clipper - Summer '87  &  Autumn '86
* Note(s)..: This program generates a status bar, for use when
*            performing multiple searches, or lengthy calculations
*            to graphically illustrate program status to the user.
*
* To show indexing type:  BAR <dbf> <field list>
*
IF PCOUNT() = 2
 PARAMETERS dbf_ntx,fld_ntx
 IF .NOT. FILE(dbf_ntx+".DBF")
  ??"Database not found..."
  QUIT
 ENDIF
 STORE .T. TO data_ind
ELSE
 STORE .F. TO data_ind
ENDIF

SET CURSOR OFF
CLEAR

* change color and draw box
SETCOLOR("G/N")
BUILDBAR(15,"Percent Completed")
SETCOLOR("W/N")

IF data_ind
 SET DECIMALS TO 0
 SET FIXED ON
 * DO NOT show a bar while doing first index
 @ 05,10 SAY "Indexing "+UPPER(dbf_ntx)+" database - no bar"
 STORE TIME() TO tm1
 USE (dbf_ntx)
 STORE LASTREC() TO hmny
 INDEX ON &fld_ntx TO BARTEST
 STORE TIME() TO tm2
 CLOS DATA
 @ 07,10 SAY "No bar took "+ELAPSED(tm1,tm2)+" to index "+LSTR(hmny)+" records"

 * show a bar while indexing a database
 @ 10,10 SAY "Indexing "+UPPER(dbf_ntx)+" database - with bar"
 STORE TIME() TO tm1
 USE (dbf_ntx)
 STORE LASTREC() TO hmny
 INDEX ON &fld_ntx+BARSTAT(15,BAR_PCT()) TO BARTEST
 STORE TIME() TO tm2
 CLOS DATA
 @ 12,10 SAY "With bar took "+ELAPSED(tm1,tm2)+" to index "+LSTR(hmny)+" records"

 ERASE BARTEST.NTX

ELSE
 * show a simple bar if not command line arguments were given.
 cnt=0
 DO WHIL cnt<101
  BARSTAT(15,cnt,"w")
  INKEY(.1)
  cnt=cnt+1
 ENDDO
ENDIF

@ 23,0
SET CURSOR ON
RETURN

******************************************************************************

FUNCTION BUILDBAR
PARAMETERS row,title
@ row,(80-LEN(title))/2 SAY title
@ row+2,13 SAY "0    10   20   30   40   50   60   70   80   90   100"
@ row+3,12 TO row+5,65 DOUB
@ row+4,14 SAY ""
RETURN ""


FUNCTION BARSTAT
PARAMETERS row,cnt
IF cnt > 0
  @ row+4,14 SAY REPLICATE(CHR(219),cnt/2)
  IF cnt/2 > INT(cnt/2) && odd #'s
    ??CHR(221)
  ENDIF
ENDIF
RETURN ""


FUNCTION BAR_PCT
* Show the percentage done while indexing a database; used in BARSTAT.
* When an index starts the record pointer hits EOF first!
* Do not let this affect the display of percentage done.
RETURN IF(EOF(),0,INT((RECNO()/RECCOUNT())*100))


***********************>>>  Misc UDFs  <<<****************************

FUNCTION ELAPSED
* Syntax: ELAPSED( <time one>,<time two> )
* Given the two time strings: "12:30:45","13:46:17"
* elaptime = "1 hour, 15 minutes, 32 seconds"
PARAMETERS tc1,tc2

TH1=VAL(SUBSTR(TC1,1,2))
TM1=VAL(SUBSTR(TC1,4,2))
TS1=VAL(SUBSTR(TC1,7,2))
TT1=(TH1*3600)+(TM1*60)+TS1

TH2=VAL(SUBSTR(TC2,1,2))
IF TH2 < TH1    && after midnight...
 TH2=TH2+24
ENDIF
TM2=VAL(SUBSTR(TC2,4,2))
TS2=VAL(SUBSTR(TC2,7,2))
TT2=(TH2*3600)+(TM2*60)+TS2

TTT=TT2-TT1

TTH=TTT/3600
TTH=INT(TTH)
IF TTH > 0
  IF TTH = 1
   STORE "1 hour, " TO elaptime
  ELSE
   STORE LSTR(TTH)+" hours, " TO elaptime
  ENDIF
 TTT=TTT-(TTH*3600)
ELSE
 STORE "" TO elaptime
ENDIF

TTM=TTT/60
TTM=INT(TTM)
IF TTM > 0
  IF TTM = 1
   STORE elaptime+"1 minute, " TO elaptime
  ELSE
   STORE elaptime+LSTR(TTM)+" minutes, " TO elaptime
  ENDIF
 TTT=TTT-(TTM*60)
ENDIF

TTS=TTT
IF TTS = 1
 STORE elaptime+"1 second" TO elaptime
ELSE
 STORE elaptime+LTRIM(STR(TTS))+" seconds" TO elaptime
ENDIF

RETURN elaptime


FUNCTION LSTR
* Syntax: LSTR( <numeric> )
* Convert a numeric expression to a character string with no spaces
* A "faster" way of doing LTRIM(STR()).
PARAMETER num2chr
RETURN LTRIM(STR(num2chr))

