; Title:  NEWATTR.ASM
; Author: Jim Nickel
;         Dynamic Computer Systems
;         1019 Park Street
;         Regina, Sask.
;         S4N 5H4
;         (306)-569-2434
; Date:   July 22, 1988
; Syntax: DO SETATTR WITH <Expn1>,<Expn2>,<Expn3>,<Expn4>,<Expn5>
;         where <Expn1-4> are the Top,left,bottom,right corners of the box
;         and   <Expn5> is the color attribute to change the area to.
;
;                128 64 32 16 8 4 2 1    r+g+b = white
;                                        r+g+b+i = high intensity white
;                  B  R  G  B I R G B       r+i = high intensity red etc...
;                      
;                               Foreground Color
;                            Intensity
;                        Background Color
;                   Blinking
;
;         Just add up the numbers of the characteristics you want.
;         I.E.  Normal is W/N or White on Black which is r+g+b (Since no
;         background color represents black = 7
;         Reverse is W/N or Black on White which is 64+32+16 (White
;         background) = 112
;


  Name                 NEWATTR
  Public               SETATTR
  Extrn                __ParNI:Far                                ; Get Integer Parameter
  Extrn                __ret:far

  DGROUP GROUP         datasg                                    ; Clipper's Data Segment
  datasg segment       public '_DATA'

  Video_Segment        dw         0B800h

  Window_top           db         ?
  Window_left          db         ?
  Window_bottom        db         ?
  Window_right         db         ?
  Window_Attr          db         ?

  Window_Row           db         ?
  Window_Column        db         ?

  datasg               ends

  _Prog                Segment  'CODE'
                       Assume     CS:_Prog,DS:DGROUP,ES:DGROUP


  SETATTR              Proc       Far
                       Push       BP                             ; Save stack
                       Mov        BP,SP
                       Push       DS
                       Push       ES
                       Push       SI
                       Push       DI

  ;------------------- Check the current video mode to see if it's one of the 80-column text modes (2, 3, or 7).
  ;                    If it is, then continue.  If it's not, abort this routine.

                       Mov        AH,15                          ; Get video page and display mode
                       Int        10h
                       Cmp        AL,2                           ; Video mode 2?
                       Je         Par1                           ; Yes, then continue
                       Cmp        AL,3                           ; Mode 3?
                       Je         Par1                           ; Yes, then continue
                       Mov        Video_Segment,0B000h           ; Set VIDEO_SEGMENT for monochrome
                       Cmp        AL,7                           ; Mode 7 (monochrome)?
                       Je         Par1                           ; Yes, then continue
                       Jmp        Exit

  ;------------------- Get Parameters Sent By Caller
  Par1:
                       Mov        AX,01                          ; First parameter
                       Push       AX
                       Call       __PARNI                         ; Get Upper Left Row
                       Add        SP,2                           ; Fix up stack
                       Mov        Window_Row,AL                  ; Save Value
                       Mov        Window_top,AL
                       Cmp        AL,24                          ; Check for Valid Row
                       Jb         Par2                           ; Continue if OK
                       Jmp        Exit                           ; Leave procedure if not

  Par2:                Mov        AX,02                          ; Second parameter
                       Push       AX
                       Call       __PARNI                         ; Get Upper Left Column
                       Add        SP,2                           ; Fix up stack
                       Mov        Window_Column,AL               ; Save Value
                       Mov        Window_left,AL
                       Cmp        AL,79                          ; Check for Valid Column
                       Jb         Par3                           ; Continue if OK
                       Jmp        Exit                           ; Leave procedure if not

  Par3:                Mov        AX,03                          ; Third parameter
                       Push       AX
                       Call       __PARNI                         ; Get Window Width
                       Add        SP,2                           ; Fix up stack
                       Mov        Window_bottom,AL               ; Save Value
                       Cmp        AL,Window_top                  ; Check for Valid Width
                       JGE        Par4                           ; Continue if OK
                       Jmp        Exit                           ; Leave procedure if not

  Par4:                Mov        AX,04                          ; Fourth parameter
                       Push       AX
                       Call       __PARNI                         ; Get Window Height
                       Add        SP,2                           ; Fix up stack
                       Mov        Window_right,AL               ; Save Value
                       Cmp        AL,Window_left                ; Check for Valid Height
                       JGE        Par5                           ; Continue if OK
                       Jmp        Exit                           ; Leave procedure if not

  Par5:                Mov        AX,05                 ; Fifth parameter
                       Push       AX
                       Call       __PARNI                ; Get Attribute
                       Add        SP,2                    ; Fix up stack
                       Mov        Window_Attr,AL           ; Save Value

  loop:                mov        dh,Window_row
                       mov        dl,Window_column
                       mov        bh,0
                       mov        ah,02      ; request set cursor pos
                       int        10h
                       mov        ax,0800h
                       mov        bh,00       ;set video page to zero
                       int        10h         ;request read char at cursor pos
                       mov        ah,09h
                       mov        bh,00       ;set video page to zero
                       mov        cx,1
                       mov        bl,Window_Attr  ;set attribute
                       int        10h         ;request write char at cursor pos
                       inc        Window_column
                       mov        AL,Window_right    ;have we reached the rightmost
                       cmp        AL,Window_column   ;column?
                       JGE        loop               ;No? then loop back up for next char
                       mov        al,window_left     ;Yes? Set the column back to the start of the
                       mov        window_column,al   ;next line.
                       inc        window_row         ;Have we reached the bottom of the window?
                       mov        al,Window_bottom
                       cmp        AL,Window_row
                       JGE        loop               ;No? Then loop back up for next char
  Exit:
                       Pop        DI
                       Pop        SI
                       Pop        ES
                       Pop        DS
                       Pop        BP
                       call       __ret
                       Ret

  SETATTR              Endp
  _Prog                Ends
                       End
