/*************************************************************************
* REGTEST by Colin L. Feeser                                             *
*         of Development Orientation Software                            *
*                                                                        *
* Compile using /w/n                                                     *
* must link with the Nanforum Library                                    *
*                                                                        *
* Placed into Public Domain                                              *
*                                                                        *
* Note: Not having any familiarty with                                   *
*       registers, I needed an easy way to                               *
*       test the FT_int86() function in the                              *
*       Nanforum Library.  This routine has                              *
*       proven to be extremely beneficial in                             *
*       this regard.  I am placing it in the                             *
*       Public Domain in hopes that it can                               *
*       benefit someone else in the same way.                            *
*       Please keep in mind that this routine                            *
*       only works with numbers.  String data                            *
*       passed or recieved in the buffers will                           *
*       not be displayed.                                                *
*       Any questions, Please feel free to                               *
*       E-mail me at 72441,3362                                          *
*                                                                        *
**************************************************************************/


#include "FTINT86.CH"
#define DOS         33
STATIC getlist := {}
STATIC aRegs[ INT86_MAX_REGS ],bRegs[ INT86_MAX_REGS ],cRegs[ INT86_MAX_REGS ]
FUNCTION regtest()
LOCAL x

  WHILE LASTKEY()<>27
     CLS

     bRegs[1]  := "AX register   :"
     bRegs[2]  := "BX register   :"
     bRegs[3]  := "CX register   :"
     bRegs[4]  := "DX register   :"
     bRegs[5]  := "SI register   :"
     bRegs[6]  := "DI register   :"
     bRegs[7]  := "BP register   :"
     bRegs[8]  := "DS register   :"
     bRegs[9]  := "ES register   :"
     bRegs[10] := "Flags register:"
     cRegs[1]  := {val("000"),val("000")}
     cRegs[2]  := {val("000"),val("000")}
     cRegs[3]  := {val("000"),val("000")}
     cRegs[4]  := {val("000"),val("000")}
     cRegs[5]  := {val("000"),val("000")}
     cRegs[6]  := {val("000"),val("000")}
     cRegs[7]  := {val("000"),val("000")}
     cRegs[8]  := {val("000"),val("000")}
     cRegs[9]  := {val("000"),val("000")}
     cRegs[10] := {val("000"),val("000")}

     ? Padc("Escape Exits - Page Down Calculates",80,chr(32))
     @ 10, 19 Say " hi     low"
     FOR x = 1 TO 10
        @ 10 + x, 1 SAY bRegs[x]
        @ 10 + x, 1 + 18 GET cRegs[x,1] VALID sayhex(1)
        @ 10 + x, 1 + 26 GET cRegs[x,2] VALID sayhex(2)
     NEXT

     READ

     x=0
     FOR x = 1 TO 10
        aRegs[x] := makehi( cRegs[x,1] )+cRegs[x,2]
        @ 10 + x, 1 + 22 SAY ft_byt2hex(chr(cRegs[x,1]))
        @ 10 + x, 1 + 30 SAY ft_byt2hex(chr(cRegs[x,2]))
     NEXT

     IF LASTKEY()<>27
        ft_int86( DOS, aRegs )
     ELSE
        EXIT
     END

     @ 08, 37 Say "hi          low          hi    low"
     @ 09, 37 Say "byte  +256  byte  +256   hex   hex"
     @ 10, 37 Say "__________________________________"
     FOR x = 1 TO 10
        @ 10 + x, 10 + 25 SAY "=>"
        @ 10 + x, 10 + 27 SAY STR(highbyte(aRegs[x]),4)+SPACE(3);
                              +STR(highbyte(aRegs[x])+256,3)+SPACE(3);
                              +STR(lowbyte(aRegs[x]),3)+SPACE(3);
                              +STR(lowbyte(aRegs[x])+256,3)+SPACE(3);
                              +ft_byt2hex(chr(highbyte(aRegs[x])))+space(3);
                              +ft_byt2hex(chr(lowbyte(aRegs[x])))
     NEXT
     ?
     ?
     ? "Press any key to Continue..."
     INKEY (0)
  END
RETURN( NIL )

STATIC FUNCTION sayhex(w)
LOCAL x := (EVAL({||getactive():row})-10)
DO CASE
CASE w=1
   @ 10 + x, 1 + 22 SAY ft_byt2hex(chr(cRegs[x,1]))
CASE w=2
   @ 10 + x, 1 + 30 SAY ft_byt2hex(chr(cRegs[x,2]))
END
RETURN(.T.)
