/*
 * File......: REMJOB.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_REMJBQ()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Remove job from queue
 *  $SYNTAX$
 *
 *     fn_remJbQ( nQueueID, nJob ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJob>     is the job number
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call is successful.  If it isn't, check
 *     fn_error() for:
 *
 *
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_remJbQ( nQueueID, nJob )
  local cReq, cRep, lRes := .f.

  if pcount()            == 2   .and. ;
     valtype( nQueueID ) == "N" .and. ;
     valtype( nJob )     == "N"
        
        cReq :=  I2BYTE( 106 )       + ;    // 6Ah
                 L2HILO( nQueueID )  + ;
                 W2HILO( nJob )
        cRep :=  ""

        lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )
  else
     _fnSetErr( EBADPARM )
  endif

  return lRes
