/*
 * File......: QRIGHTS.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_chCliRi()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Change to client rights
 *  $SYNTAX$
 *
 *     fn_chCliRi( nQueueID, nJobNum ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJobNum>  is the job number 
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_chCliRi( nQueueID, nJob )
  local cReq, cRep, lRes := .f.

  if pcount() == 2 .and. ;
     valtype( nQueueID ) == "N" .and. ;
     valtype( nJob     ) == "N"

     cReq := I2BYTE( 116  ) + L2HILO( nQueueID ) + W2HILO( nJob )
     cRep := ""
     
     lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )

  else
     _fnSetErr( EBADPARM )
  endif

  return lRes



/*  $DOC$
 *  $FUNCNAME$
 *     fn_rstQSRi()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Restore Queue Server Rights
 *  $SYNTAX$
 *
 *     fn_rstQSRi() -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     None, believe it or not
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_rstQSRi()
  local cRep := ""
  return (  _fnReq( 227, I2BYTE( 117 ), @cRep ) == ESUCCESS )

