/*
 * File......: GETQUE.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_gPtrNam()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Get Printer Queue
 *  $SYNTAX$
 *
 *     fn_gPrtNam([<nDevice>]) -> <nPrintQueueId>
 *
 *  $ARGUMENTS$
 *
 *     <nDevice> 1, 2, 3 for LPT1,LPT2,LPT3
 *     Defaults to 1 [LPT1].
 *
 *  $RETURNS$
 *
 *     <nPrintQueueId> - bindery object id of the print queue
 *
 *  $DESCRIPTION$
 *
 *     Gets the bindery object id of the print queue for a
 *     specified device.
 *
 *  $EXAMPLES$
 *     nId := fn_gPtrName(1)
 *
 *  $SEEALSO$
 *  $END$
 */


#ifdef FT_TEST
    FUNCTION main()
    LOCAL nId := fn_gPtrName(1)
      @ 0,0 CLEAR
      ? nId
    RETURN (NIL)
#endif

function fn_gPtrNam( nDevice )
  local cRecv := space(4)

  default nDevice to 1

  _fnReq(224, I2BYTE(10) + I2BYTE((nDevice - 1)), @cRecv )
  return (HILO2L(cRecv))
