; File......: FNXOR.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    FN_XOR()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Perform a bitwise exclusive OR
; $SYNTAX$
;    
;    fn_xor( <nInt1> | <cInt1>, <nInt2> ) -> nResult
;
; $ARGUMENTS$
;
;    <nInt1> may either be a numeric integer, or a 16-bit character
;    string that is the binary representation of a numeric integer.
;
;    <nInt2> must be a numeric integer.
;
; $RETURNS$
;
;    <nResult>, a numeric
;
; $DESCRIPTION$
;
;     The value returned is obtained by performing a bitwise XOR
;     with <nInt1> and <nInt2> as operands. If any parameters are
;     invalid, the function will return zero.
;
; $EXAMPLES$
;
;      ? fn_xor( 11, 12 )       // 7
;
; $SEEALSO$
;
; $INCLUDE$
;
; $END$
;
;


IDEAL

PUBLIC   FN_XOR

EXTRN    __FNCBALL:FAR

SEGMENT  _FNNET  WORD      PUBLIC    "CODE"
         ASSUME    CS:_FNNET

PROC     FN_XOR       FAR

         MOV       AX,4631h
         MOV       DX,0CBFAh
         JMP       __FNCBALL

ENDP     FN_XOR
ENDS     _FNNET
END

