/*
 * File......: DEVTYPE.PRG
 * Author....: Michael A. Cohen
 * CIS ID....: 72007,276
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Michael Cohen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FN_Devtype()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get the Device type for any drive number (Network, Local, or Subst)
 *  $SYNTAX$
 *
 *     fn_Devtype( <nDrive> ) -> <nDevtype>
 *
 *  $ARGUMENTS$
 *
 *     <nDrive> Disk drive number (1 for A, etc.) or 0 for default drive
 *
 *  $RETURNS$
 *
 *     <nDevtype> returns 1 for Local, 2 for Remote (Network), 3 for Subst,
 *                0 for Invalid drive, -1 for Error.
 *
 *  $DESCRIPTION$
 *
 *   Get the device type of the logical device.  Uses DOS Int 21, Function 44
 *   (I/O Control for Devices)
 *
 *  $EXAMPLES$
 *
 *  Function main()
 *  // Print the drive types for all valid drives.
 *  LOCAL i,nType,aTypes:={"Local  ","Network","Subst  "}
 *  for i := 1 to 26
 *    nType:=Devtype(i)
 *    if nType > 0
 *       ? "Drive ",chr(64+i),aTypes[nType]
 *    endif
 *  next
 *  Return NIL
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
#include "Ftint86.ch"
#define INT21  33

#ifdef FT_TEST
Function main()
// Print the drive types for all valid drives.
LOCAL i,nType,aTypes:={"Local  ","Network","Subst  "}
for i:=1 to 26
  nType:=fn_Devtype(i)
  if nType > 0
     ? "Drive ",chr(64+i),aTypes[nType]
  endif
next
Return NIL
#endif

/***
*   FN_DEVTYPE()
*   Michael A. Cohen
*   10/27/92
*
*   Get the device type of the logical device.  Uses DOS Int 21, Function 44
*   (I/O Control for Devices)
*
*   nRetval = FN_DEVTYPE([nDrive])
*
*    nDrive      -   Disk Drive Number (1 for A, etc), or 0 for default drive.
*    nRetval     -   1 for local, 2 for Remote (Network), 3 for Subst,
*                    0 for Invalid Drive, -1 for Error.
*/
Function FN_DEVTYPE(nDrive)
local   aRegs[ INT86_MAX_REGS ], nRetval:=1
nDrive:=iif(nDrive==NIL,0,nDrive)   // Default to current drive.

aRegs[ AX ] := ft_hex2dec("4409")   // Get device type
aRegs[ BX ] := nDrive

if ft_int86( INT21, aRegs )
   if aRegs[ DX ]==0                  // Invalid Drive
      nRetval:=0
   elseif FT_ISBiton(aRegs[ DX ],12)  // Remote Drive
      nRetval:=2
   elseif FT_ISBiton(aRegs[ DX ],15)  // Subst drive
      nRetval:=3
   endif
else
   nretval:=-1
endif
Return (nRetval)
