/*
 * File......: CLSBIND.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_closBnd()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Close Bindery
 *  $SYNTAX$
 *
 *     FN_closBnd() => lClosed
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <lClosed> Returns true if bindery was successfully closed
 *		 and false if not.
 *
 *  $DESCRIPTION$
 *
 *     This function closes both bindery files NET$BIND.SYS and
 *     NET$BVAL.SYS.  You must have SUPERVISOR rights to close
 *     the bindery.  When the bindery is closed the network
 *     will not do much of anything.
 *
 *  $SEEALSO$
 *     fn_openBnd()
 *  $EXAMPLES$
 *
 *     // this will close the bindery
 *     lClosed :=  FN_closBnd()
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227

#ifdef FT_TEST
  FUNCTION MAIN()
    IF FN_closBnd()
      Qout("Bindery has been closed.")
    ELSE
      Qout("Bindery has not been closed.")
    ENDIF

  RETURN ( nil )

#endif

FUNCTION FN_closBnd()
RETURN _fnReq(NW_LOG,Chr(68),"") == ESUCCESS  // 44h API request code
