/*
 * File......: CHQJENT.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     fn_chQJbEn()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Change queue job entry
 *  $SYNTAX$
 *
 *     fn_chQJbEn( nQueueID, aJobStruct ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID>   is the bindery object ID of the queue
 *     <aJobStruct> is a queue job entry structure
 *
 *     Note that you can only change target server ID, target execution
 *     date/time, job type, job control flags, text job description, and
 *     client record area.
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it fails, check fn_error()
 *     for the error code, which can be one of:
 *
 *           150  =  Server out of memory
 *           208  =  Queue error
 *           209  =  No queue
 *           213  =  No queue job
 *           215  =  Queue servicing
 *           254  =  Server bindery locked
 *           255  =  Bindery failure
 *
 *  $DESCRIPTION$
 *
 *     Use this call to change parts of a queue job entry.  If the job
 *     is being serviced, you'll get an fn_error() of 215 ("Queue 
 *     servicing").  
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_chQJbEn( nQueueID, aJob ) 
  local cReq, cRep, lRes := .f.

  if pcount() == 2 .and. valtype( nQueueID ) == "N" .and. ;
     valtype( aJob ) == "A"
     cReq := I2BYTE( 109 ) + L2HILO( nQueueID ) + _fnJs2pkt( aJob )    // 6DH
     cRep := "" 
     lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )
  else
     _fnSetErr( EBADPARM )
  endif

  return lRes
