/*
 * File......: OPENBIND.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_openBnd()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Open Bindery
 *  $SYNTAX$
 *
 *     FN_openBnd() => lOpened
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <lOpened> Returns true if bindery was successfully opened
 *		 and false if not.
 *
 *  $DESCRIPTION$
 *
 *     This function opens both bindery files NET$BIND.SYS and
 *     NET$BVAL.SYS.  You must have SUPERVISOR rights to open
 *     the bindery.
 *
 *  $SEEALSO$
 *   fn_closBnd()
 *  $EXAMPLES$
 *
 *     lOpened := FN_openBnd()
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227

#ifdef TEST
  FUNCTION MAIN()
    IF FN_openBnd()
      Qout("Bindery has been opened.")
    ELSE
      Qout("Bindery has not been opened.")
    ENDIF

  RETURN ( nil )
#endif

FUNCTION FN_openBnd()
RETURN _fnReq(NW_LOG,Chr(69),"") == ESUCCESS   // 45h API Request Code
