/*
 * File......: DEFLPT.PRG
 * Author....: Christopher Shortt
 * CIS ID....: 72760,3271
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Christopher Shortt and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "ftint86.ch"
#include "netto.ch"

#define OP_GET      4     /* Don't change */
#define OP_SET      5     /* Don't change */

/*  $DOC$
 *  $FUNCNAME$
 *     fn_gDefLPT()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Gets Default Local Printer
 *  $SYNTAX$
 *
 *     nLocalLPT := fn_gDefLPT()
 *
 *  $ARGUMENTS$
 *
 *     None.
 *
 *  $RETURNS$
 *
 *	   <nLocalLPT> is the default local printer.
 *
 *  $DESCRIPTION$
 *
 *  This function returns number of the default local LPT.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *
 *     local   nResult:=0
 *     aResult := fn_gDefLPT(0)
 *	  QOut("Default Local Printer Is " + ALLTRIM(STR(nResult)) + ".")
 *     return NIL
 *
 *  $SEEALSO$
 *   fn_sDefLPT()
 *  $END$
 */


function fn_gDefLPT()
  return _fndeflpt( OP_GET )
  



/*  $DOC$
 *  $FUNCNAME$
 *     fn_sDefLpt()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Sets Default Local Printer
 *  $SYNTAX$
 *
 *     nResult := fn_sDefLpt()
 *
 *  $ARGUMENTS$
 *
 *     None.
 *
 *  $RETURNS$
 *
 *	   <nResult> is the completion code for the call.
 *
 *	   Completion Codes:
 *
 8			00 - Success
 *
 *  $DESCRIPTION$
 *
 *  This function sets the number of the default local LPT.
 *
 *  $EXAMPLES$
 *
 *  function main()
 *
 *     local   nResult:=0
 *     nResult := fn_sDefLpt(1)
 *  return NIL
 *
 *  $SEEALSO$
 *   fn_gDefLPT()
 *  $END$
 */


function fn_sDefLpt( nLPT )
  return _fndeflpt( OP_SET, nLPT )


/* ------------------------------------------------------------------------ */


static function _fndeflpt( nOp, nLPT )
  local aRegs[ INT86_MAX_REGS ], nResult 

  aRegs[ AX ] := makehi( 184 ) + nOp 

  if nOp == OP_SET
     aRegs[ DX ] := nLPT - 1
  endif

  _fnSetErr( iif( ft_int86( INT21, aRegs ), ESUCCESS, EINT86 ) )

  nResult := iif( nOp == OP_GET, ;
		    highbyte( aRegs[ DX ] ) + 1,;
                    lowbyte( aRegs[ AX ] );
                 )

  return nResult
