*  BOF: NETMODE.PRG

*  FILE.......: NETMODE.PRG
*  AUTHOR.....: Berend Tober
*  CIS id #...: 70541,1030
*  DATE.......: Wed  94/08/10 23:25:46

*  This is an original work by Berend M. Tober and is
*  placed in the public domain.
*

/* Modification History
*/


 * File......: NETMODE.PRG
 * Author....: Berend M. Tober
 * CIS ID....: 700541,1030
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Berend M. Tober
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     NETMODE()
 *  $CATEGORY$
 *     Networks
 *  $ONELINER$
 *     GET/SET EXCLUSIVE/SHARED mode.
 *  $SYNTAX$
 *     NETMODE( [<lNewMode>] ) --> lExclusive
 *  $ARGUMENTS$
 *     [<lNewMode>] The new EXCLUSIVE/SHARED mode to be set for the
 *     current work area.  If no area is in use, an alert box with
 *     an error message is displayed with a prompt.
 *  $RETURNS$
 *     Current EXCLUSIVE/SHARED mode for current alias. If no area
 *     is in use, an alert box with an error message is displayed
 *     with a prompt.
 *  $DESCRIPTION$
 *     This function is a GET/SET-type function for the network
 *     open mode of database files.  A static array is used to keep
 *     track of the open mode for each database that an application
 *     program uses. Calling this function with a parameter will
 *     set that parameter in the static array for the key value
 *     equal to the ALIAS of the currently active database.
 *
 *     Your application program should call this function after
 *     each time a database file is opened so as to set the current
 *     open mode, and you should maintain consistency in assignment
 *     of ALIAS names, on account that NetMode() uses the ALIAS
 *     name as the key to storing the open mode. Then, other
 *     routines can call this function to determine whether or not
 *     the file is opened in SHARED mode.
 *  $EXAMPLES$
 *     USE chief NEW SHARED
 *     NetMode( TRUE )
 *          ...
 *          ...
 *          ...
 *     IF NetMode()
 *        USE chief EXCLUSIVE
 *        PACK
 *        USE chief SHARED
 *     ELSE
 *        PACK
 *     ENDIF
 *
 *  $SEEALSO$
 *     NETAPPEN NETDEL NETFLOCK NETPACK NETRLOCK NETUSE NETUTILS
 *  $INCLUDE$
 *  $END$
 *
 */


#define NET_ALIAS     1
#define NET_MODE      2

#include "common.ch"

STATIC aMode := {}   // Array used to keep track of open mode.  Each
                     // element is an array as follows.
                     // [1] is the ALIAS of each database opened by
                     // the appliation program.
                     // [2] is the mode (SHARED/EXCLUSIVE) in which the
                     // file was opened.

********************************** NETMODE() ***********************************
FUNCTION NETMODE( lNewMode )
   LOCAL cAlias   := ALIAS()
   LOCAL nAlias   := IF(EMPTY( cAlias ), 0, ;
                        ASCAN( aMode, {|x| x[NET_ALIAS] == cAlias }))
   LOCAL lOldMode := IF( nAlias > 0, aMode[nAlias,NET_MODE], NIL )

   DEFAULT lNewMode  TO lOldMode

   DO CASE
   CASE !EMPTY( cAlias ) .AND. ( nAlias == 0 )
      AADD( aMode, { ALIAS(), lNewMode })
   CASE !EMPTY( cAlias )
      aMode[nAlias, NET_MODE] := IF( lNewMode <> NIL, lNewMode, lOldMode )
   OTHERWISE
      ALERT( "NETMODE() error: No work area in use")
   ENDCASE

   RETURN lOldMode
* end of NETMODE.PRG()

* EOF: NETMODE.PRG
