* NETIO - Network I/O Routines
*
* Copyright (c) 1986, 1987 - Ross Chappell Associates Inc.
*                            250 Consumers Road, Suite 1109
*                            Willowdale, Ontario   M2J 4V6
*                            (416) 495-1100
*
* Entered into the public domain July, 1987 by Ross Chappell Associates Inc.
*
* You may copy these routines and include them with programs which you develop
* provided that you do not remove this copyright notice.
*
* Note: RCA has tested and used all of these functions and believes they are
*       error free but does not warrant these routines in any way, represent
*       their fitness for any specific purpose, and will not accept
*       responsibility for any damages incurred through their use.
*
* Forward questions or comments to Source ID NA2642.
***

*------------------------------------------------------------------------------
* The following routines provide a "soft" interface to Clippers network
* file processing routines which add a level of user friendliness to
* application programs when processing USE, FLOCK, RLOCK, and APPEND BLANK
* functions.
*
* The intent behind these routines is to perform the requested function and
* return information back to the calling program as to the success or failure
* of the requested function. Should a file or record locking conflict occur,
* certain of these routines will handle the error by giving the user the
* opportunity to RETRY or CANCEL the requested function.
*
* Upon exit, appropriate memory variables are updated for use by the calling
* program. It is YOUR PROGRAMS responsibility to examine the code(s) returned
* and to handle (usually by "backing out" the requested function) any failure
* which occurs.
*
* Routines included are:
*
*  ZZUSE         -- USE a file,    fail immediately if unsuccessful.
*  ZZUSEP        -- USE a file,    request user action if unsuccessful.
*  ZZRLOCK       -- LOCK a record, request user action if unsuccessful.
*  ZZFLOCK       -- LOCK a file,   request user action if unsuccessful.
*  ZZADD         -- APPEND BLANK,  fail immediately if unsuccessful.
*  ZZADDP        -- APPEND BLANK,  request user action if unsuccessful.
*
*  USEF          -- FUNCTION version of ZZUSE
*  USEFP         -- FUNCTION version of ZZUSEP
*  RLOCKF        -- FUNCTION version of ZZRLOCK
*  FLOCKF        -- FUNCTION version of ZZFLOCK
*  ADDF          -- FUNCTION version of ZZADD
*  ADDFP         -- FUNCTION version of ZZADDP
*
*
* Routines and examples assume the use of certain standard RCA variable names
* (EXCLUSIVE, SHARE, CHOICE, ERRMSG, OPEN_OK, LOCK_OK, GET_OK, ADD_OK). 
*
* Most of these variables names should make sense within the context of their
* use, except for CHOICE, which we use as a result of coding standards
* followed by our programmers. In the context of these routines it represents
* a status code which can be returned to higher level programs to indicate
* (if its value is "\") that the called function is requesting cancelling of,
* or has cancelled, the process for which it is responsible.
*
* RCA programs usually use a standardized initialization routine which, among
* other things, creates & initializes these variables. We've extracted a
* portion of these routines for you and created an procedure called "NETINIT"
* (below) which you should call prior to using any of the routines described
* below.
***

* NETINIT   Initialize public memory variables used by NETIO & calling
* -------   programs.
*
*            ** CALL THIS ROUTINE BEFORE YOU USE ANY OTHER NETIO
*               PROCEDURES OR FUNCTIONS. **
*
* Sample usage:
*
*        DO NETINIT
*

PROCEDURE NETINIT

PUBLIC CHOICE, ERRMSG, EXCLUSIVE, SHARE
PUBLIC OPEN_OK, LOCK_OK, GET_OK, ADD_OK

CHOICE    = " "
ERRMSG    = ""
SHARE     = .F.
EXCLUSIVE = .T.
OPEN_OK   = .T.
LOCK_OK   = .T.
GET_OK    = .T.
ADD_OK    = .T.
RETURN



*
* ZZUSE   Network USE with immediate fail
* ------
*
* Sample usage:
*
*        DO ZZUSE WITH EXCLUSIVE,"&DDPROD.PRMAST"
*        IF OPEN_OK
*           SET INDEX TO &DDPROD.PRMAST
*        ELSE
*           RETURN
*           ENDIF
*
* Note: If     Successful... CHOICE  = " "
*                            OPEN_OK = .T.
*
*       If NOT Successful... CHOICE  = "\"
*                            OPEN_OK = .F.
*                            ERRMSG  = "Cancelled."
*

PROCEDURE  ZZUSE
PARAMETERS ZZEXCLU, ZZFILE

IF ZZEXCLU
   USE &ZZFILE EXCLUSIVE
ELSE
   USE &ZZFILE
   ENDIF

IF NETERR()
   CHOICE  = "\"
   ERRMSG  = "Cancelled."
   OPEN_OK = .F.
ELSE
   CHOICE  = " "
   OPEN_OK = .T.
   ENDIF

RETURN




*
* ZZUSEP   Network USE with Pause
* -------
*
* Sample usage:
*
*        DO ZZUSEP WITH EXCLUSIVE,"Product Master File","&DDPROD.PRMAST"
*        IF OPEN_OK
*           SET INDEX TO &DDPROD.PRMAST
*        ELSE
*           RETURN
*           ENDIF
*
* Note: If     Successful... CHOICE  = " "
*                            OPEN_OK = .T.
*
*       If NOT Successful... CHOICE  = "\"
*                            OPEN_OK = .F.
*                            ERRMSG  = "Cancelled."
*

PROCEDURE  ZZUSEP
PARAMETERS ZZEXCLU, ZZFID, ZZFILE

IF ZZEXCLU
   USE &ZZFILE EXCLUSIVE
ELSE
   USE &ZZFILE
   ENDIF

IF NETERR()
ELSE
   CHOICE  = " "
   OPEN_OK = .T.
   RETURN
   ENDIF

*
* Could not open... SAVE Screen & let user know... process accordingly
*
SAVE SCREEN
CLEAR GETS

@ 13,10 CLEAR TO 21,72
@ 14,11 TO 20,71 DOUBLE
@ 15,12 SAY LEFT("&ZZFID is in use by another user."+SPACE(60),58)
@ 17,12 SAY "Retry or Cancel (R/C)? "

DO WHILE .T.
   ZZ_CHOICE = GETINK("RC")
   IF ZZ_CHOICE = "C"
      ?? "Cancelling..."
      CHOICE   = "\"
      ERRMSG   = "Cancelled."
      OPEN_OK  = .F.
      RESTORE SCREEN
      RETURN
      ENDIF
   ?? "Retrying..."
   IF ZZEXCLU
      USE &ZZFILE EXCLUSIVE
   ELSE
      USE &ZZFILE
      ENDIF
   IF NETERR()
      @ 15,12 CLEAR TO 17,70
      @ 15,12 SAY "Retry failed! File is still in use by another."
      @ 17,12 SAY "Retry or Cancel (R/C)? "
   ELSE
      CHOICE   = " "
      OPEN_OK  = .T.
      RESTORE SCREEN
      RETURN
      ENDIF
   ENDDO

RETURN




*
* ZZRLOCK   Try to LOCK current record.
* -------
*
* Sample usage:
*
*        DO ZZRLOCK
*  or... DO ZZRLOCK WITH "Customer Number '123456'"
*

PROCEDURE ZZRLOCK
PARAMETERS ZZRID

PRIVATE ZZRIDX
LOCK_OK = .T.
IF RLOCK()
   RETURN
   ENDIF

IF PCOUNT() < 1
   ZZRIDX = "Record"
ELSE
   ZZRIDX = ZZRID
   ENDIF

SAVE SCREEN

@ 13,10 CLEAR TO 19,72
@ 14,11 TO 18,71 DOUBLE
@ 15,12 SAY LEFT("Trying to LOCK &ZZRIDX."+SPACE(60),58)
@ 17,12 SAY "Press ESCAPE to Cancel."
LOCK_OK = .T.
CLEAR TYPEAHEAD
DO WHILE .NOT. RLOCK()
   @ 17,12 SAY SPACE(30)
   IF INKEY() = 27
      @ 17,12 SAY "Cancelled..."
      LOCK_OK  = .F.
      CHOICE   = "\"
      ERRMSG   = "Cancelled."
      RESTORE SCREEN
      RETURN
   ELSE
      @ 17,12 SAY "Press ESCAPE to Cancel."
      ENDIF
   ENDDO

RESTORE SCREEN
RETURN




*
* ZZFLOCK   Try to LOCK current FILE.
* -------
*
* Sample usage:
*
*        DO ZZFLOCK
*  or... DO ZZFLOCK WITH "Customer Master File"
*

PROCEDURE ZZFLOCK
PARAMETERS ZZFID

PRIVATE ZZFIDX
LOCK_OK = .T.
IF FLOCK()
   RETURN
   ENDIF

IF PCOUNT() < 1
   ZZFIDX = "File"
ELSE
   ZZFIDX = ZZFID
   ENDIF

SAVE SCREEN

@ 13,10 CLEAR TO 19,72
@ 14,11 TO 18,71 DOUBLE
@ 15,12 SAY LEFT("Trying to LOCK &ZZFIDX."+SPACE(60),58)
@ 17,12 SAY "Press ESCAPE to Cancel."
LOCK_OK = .T.
CLEAR TYPEAHEAD
DO WHILE .NOT. FLOCK()
   @ 17,12 SAY SPACE(30)
   IF INKEY() = 27
      @ 17,12 SAY "Cancelled..."
      LOCK_OK  = .F.
      CHOICE   = "\"
      ERRMSG   = "Cancelled."
      RESTORE SCREEN
      RETURN
   ELSE
      @ 17,12 SAY "Press ESCAPE to Cancel."
      ENDIF
   ENDDO

RESTORE SCREEN
RETURN



*
* ZZADD   Add a Record to a File with immediate fail
* ------
*
* Sample usage:
*
*        DO ZZADD
*        IF ADD_OK
*        ELSE
*           RETURN
*           ENDIF
*
* Note: If     Successful... CHOICE  = " "
*                            ADD_OK = .T.
*
*       If NOT Successful... CHOICE  = "\"
*                            ADD_OK = .F.
*                            ERRMSG  = "9Cancelled."
*

PROCEDURE  ZZADD

ADD_OK = .T.
APPEND BLANK

IF NETERR()
   CHOICE = "\"
   ERRMSG = "Cancelled."
   ADD_OK = .F.
ELSE
   CHOICE = " "
   ADD_OK = .T.
   ENDIF

RETURN




*
* ZZADDP   APPEND a new record with Pause.
* ------
*
* Sample usage:
*
*        DO ZZADDP
* or...  DO ZZADDP WITH "Customer Record"
*
*        IF ADD_OK
*        ELSE
*           RETURN
*           ENDIF
*
* Note: If     Successful... CHOICE  = " "
*                            OPEN_OK = .T.
*
*       If NOT Successful... CHOICE  = "\"
*                            OPEN_OK = .F.
*                            ERRMSG  = "Cancelled."
*

PROCEDURE  ZZADDP
PARAMETERS ZZRID

ADD_OK = .T.
APPEND BLANK

IF NETERR()
ELSE
   CHOICE = " "
   ADD_OK = .T.
   RETURN
   ENDIF

*
* Could not open... SAVE Screen & let user know... process accordingly
*
SAVE SCREEN
CLEAR GETS

IF PCOUNT() < 1
   ZZRIDX = "New Record(s)"
ELSE
   ZZRIDX = ZZRID
   ENDIF


@ 13,10 CLEAR TO 21,72
@ 14,11 TO 20,71 DOUBLE
@ 15,12 SAY LEFT("Trying to ADD (Append) &ZZRIDX.."+SPACE(60),58)
@ 17,12 SAY "Retry or Cancel (R/C)? "

DO WHILE .T.
   ZZ_CHOICE = GETINK("RC")
   IF ZZ_CHOICE = "C"
      ?? "Cancelling..."
      CHOICE   = "\"
      ERRMSG   = "Cancelled."
      ADD_OK   = .F.
      RESTORE SCREEN
      RETURN
      ENDIF
   ?? "Retrying..."
   APPEND BLANK
   IF NETERR()
      @ 15,12 CLEAR TO 17,70
      @ 15,12 SAY "Retry failed! (File must be in use by another)."
      @ 17,12 SAY "Retry or Cancel (R/C)? "
   ELSE
      CHOICE   = " "
      ADD_OK   = .T.
      RESTORE SCREEN
      RETURN
      ENDIF
   ENDDO

RETURN



*---------------------------------------------------------------------------
* The following are FUNCTION entry points to all above routines, which
* allow programs to use IF <function> statements.
*---------------------------------------------------------------------------

*
* Function USEF
*
* Sample Usage:    IF USEF(EXCLUSIVE,"&DDPROD.PRMAST")
*                  ELSE
*                     RETURN
*                     ENDIF
*

FUNCTION USEF
PARAMETERS ZZEXCLU, ZZFILE

DO ZZUSE WITH ZZEXCLU, ZZFILE
RETURN(OPEN_OK)


*
* Function USEFP
*
* Sample Usage: IF USEFP(EXCLUSIVE,"Product Master File","&DDPROD.PRMAST"
*               ELSE
*                  RETURN
*                  ENDIF
*

FUNCTION USEFP
PARAMETERS ZZEXCLU, ZZFID, ZZFILE

DO ZZUSEP WITH ZZEXCLU, ZZFID, ZZFILE
RETURN(OPEN_OK)

*
* Function: RLOCKF
*
* Sample Usage: IF RLOCKF( ["Customer Number '123456'] )
*               ELSE
*                  RETURN
*                  ENDIF
*

FUNCTION RLOCKF
PARAMETERS ZZRID

IF PCOUNT() < 1
   DO ZZRLOCK
ELSE
   DO ZZRLOCK WITH ZZRID
   ENDIF

RETURN(LOCK_OK)


*
* Function: FLOCKF
*
* Sample Usage: IF FLOCKF( ["Customer Master File"] )
*               ELSE
*                 RETURN
*                 ENDIF
*

FUNCTION FLOCKF
PARAMETERS ZZFID

IF PCOUNT() < 1
   DO ZZFLOCK
ELSE
   DO ZZFLOCK WITH ZZFID
   ENDIF

RETURN(LOCK_OK)

*
* Function: ADDF
*
* Sample Usage: IF ADDF()
*               ELSE
*                 RETURN
*                 ENDIF

FUNCTION ADDF

DO ZZADD
RETURN(ADD_OK)

*
* Function: ADDFP
*
* Sample Usage: IF ADDFP( ["Customer Record"] )
*               ELSE
*                 RETURN
*                 ENDIF

FUNCTION ADDFP
PARAMETERS ZZRID

IF PCOUNT() < 1
   DO ZZADDP
ELSE
   DO ZZADDP WITH ZZRID
   ENDIF

RETURN(ADD_OK)
