/* NDX.c
 *
 * NDX.Com -- dBASE III / FoxBASE+  Index key lister
 *
 * Copyright (c) 1988, by Matrix Software Systems
 *                        All rights reserved
 *
 * This program will list the key for any any dBASE III / FoxBASE +
 * index file.  The program automatically distinguishes between FoxBASE
 * .IDX and dBASE .NDX formats and handles each appropriately.  In the
 * standard listing, FoxBASE-style index files are denoted (FB) while
 * dBASE style index files are denoted (DB).  By using the -C command
 * line option, the output is formatted in the dBASE command form:
 *
 *    index on <key> to <file>
 *
 * suitable for inclusion in dBASE/FoxBASE command files.  Note that the
 * command-line parser is NOT sophisticated and requires the -C option
 * to be the first argument on the command line, or else it will be
 * treated as a filename.
 *
 * This program is provided on an "as-is" basis.  No warranty, expressed
 * or implied, covers this program.  Matrix Software Systems disclaims
 * all conditions and warranties, whether express or implied with regard
 * to this program, including all implied conditions or warranties of
 * merchantibility and fitness for a particular purpose.
 *
 * This program is NOT public domain.  It may be freely distributed as
 * long as the following conditions are met:
 *
 *  1.  Any and all copies must include the above copyright notice.
 *  2.  The software must be distributed in its original ARC format
 *      which contains the files NDC.COM, NDC.C, and READ.ME.
 *  3.  No fee may be charged for any copy, aside from a possible small
 *      duplication and handling fee.  (I sincerely doubt you could sell
 *      this if you wanted to...)
 *
 *
 * To compile the source code, you will need Turbo C (V1.0).
 *
 *    tcc -Ic:\tc\include -Lc:\tc\lib -K -O -Z -d -f- -mt ndc.c
 *    exe2bin ndc.exe ndc.com
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <errno.h>
#include <dir.h>
#include <string.h>


/* A few typedefs from Amigaland.  Makes porting code a hell of a lot easier */
#define VOID   void
typedef unsigned char UBYTE;
typedef unsigned short UWORD;
typedef unsigned long ULONG;
typedef char BYTE;
typedef short WORD;
typedef char *STRPTR;


STRPTR usagemessage[] = {
   "NDX.Com -- Copyright (c) 1988, by Matrix Software Systems",
   "        -- All Rights Reserved --",
   " ",
   "List dBASE III / FoxBASE+ Index file keys/",
   "Usage:  NDX [-options] <filename.ext> [<filename.ext>...]",
   "        Filenames may include path and/or wildcards (* and ?)",
   "        If no extension is specified, '.NDX' and '.IDX' are assumed.",
   "        Options:",
   "           -C : Print key in dBASE command form ",
   "                ('Index on <key> to <filename>)",
   " ",
   "Please send comments/requests to the following locations:",
   "  CompuServe:  75126,2223",
   "  BIX:  dlove",
   ""
};

/* dBASE III database header size and offset information */
#define SIZEOF_FBNDX_HDR   16
#define SIZEOF_DBNDX_HDR   (24 - SIZEOF_FBNDX_HDR)
#define SIZEOF_NDX_KEY     100

#define TYPE_FOXBASE_PLUS  'F'
#define TYPE_DBASE_III     'D'
#define TYPE_UNKNOWN       '?'

#define EXTENSIONS   2

/* Prototypes */
WORD main(int, char**);
STRPTR fixname(STRPTR,struct ffblk *);
WORD listkeys(STRPTR, WORD);
VOID usage(void);


WORD
main(argc,argv)
WORD argc;
char *argv[];
{
   static char filename[256];
   static struct ffblk ffblk;
   static char *defext[EXTENSIONS] = {".IDX",".NDX"};
   register STRPTR st;                 /* Pointer to '.' in file spec */
   register WORD command = 0;          /* TRUE if command option -C given */
   register WORD i;                    /* loop variable */
   register WORD foundone;             /* Set if a matching file spec is found*/
   register WORD extensions;           /* Number of extensions to process */
 
   if (argc > 1 && *argv[1] == '-') {
      st = *(++argv)+1;
      command =  *st == 'C' || *st == 'c';
      argc--;
   }
   if (argc < 2) {               /* Show usage if no argument given */
      usage();
   } else {
      foundone = 1;
      while(--argc) {
         foundone = 0;
         ++argv;

         strcpy(filename,*argv);
         for (st = filename; *st != '\0' && *st != '.'; st++);

         if (*st) {
            st = NULL;
            extensions = 1;
         } else
            extensions = EXTENSIONS;

         for (i = 0; i < extensions; i++) {

            if (st) {
               if (i)                     /* Reset the filespec if necessary */
                  strcpy(filename,*argv);
                                        strcpy(st,defext[i]);
                                }
            /* Now check for a matching file.  If no match is found, assume
             * the argument is a directory name, append "\\*.dbf" and attempt
             * to match a file there.  If there are still no matches found,
             * print a warning message and skip to the next arg.            */

            if (findfirst(filename,&ffblk,0)) {
               sprintf(filename,"%s\\*d%s",*argv,defext[i]);
               if (findfirst(filename,&ffblk,0))
                  continue;
            }

            /* If we get here, findfirst() found a matching file.  So fix the
             * filename to eliminate any wildcards and attempt to process it.
             * loop until all matches have been handled.                       */
            do {
               listkeys(fixname(filename,&ffblk),command);
            } while (!findnext(&ffblk));
            foundone = 1;
         }
         if (!foundone)
            printf("Could not locate %s.",*argv);
      }
   }
}


STRPTR
fixname(filename,ffblk)
STRPTR filename;
struct ffblk *ffblk;
{
   static char drive[MAXDRIVE];
   static char dir[MAXDIR];
   static char file[MAXFILE];
   static char ext[MAXEXT];

   /* Tear the filename apart to get the drive and directory */
   fnsplit(filename,drive,dir,file,ext);
 
   /* Then reassemble it with the correct filename */
   sprintf(filename,"%s%s%s",drive,dir,ffblk->ff_name);
 
   /* For convenience, return a pointer to the fixed filename */
   return(filename);
}


WORD
listkeys(filename,prg_format)
STRPTR filename;
WORD prg_format;
{
   static char header[SIZEOF_FBNDX_HDR+SIZEOF_DBNDX_HDR];
   static char key[SIZEOF_NDX_KEY];
   static char error_message[] = "Unrecognized Index File Format : %s(%c)\n";
   register int fp;
   register char type = 0;
   register STRPTR error = error_message;

   /* Attempt to open the file (Note that O_BINARY MUST be present!) */
   fp = open(filename,O_RDONLY|O_BINARY|O_DENYNONE);
   if (fp) {
      /* Attempt to read the index header */
      if (read(fp,&header[0],SIZEOF_FBNDX_HDR) == SIZEOF_FBNDX_HDR) {
         /* Got it, so no attempt to determine the index file type (ndx or idx).
            This is where the whole thing can fall apart.  No specs are
            published (as far as I am aware) on index file internal formats.
            The following routine has been tested with dBASE (III and III Plus)
            and FoxBASE Plus (V1.21 and V2.0.).  For any other systems, all
            bets are off... */
         if (*((long *)&header[4]) != 0xFFFFFFFFL) { /* Not a FoxBase Header */
            if (read(fp,&header[0],SIZEOF_DBNDX_HDR) == SIZEOF_DBNDX_HDR
               && (header[0] != 0 || header[0] != 1))
               type = TYPE_DBASE_III;
         } else
            type = TYPE_FOXBASE_PLUS;
         if (type) {
            if (read(fp,&key[0],SIZEOF_NDX_KEY) == SIZEOF_NDX_KEY) {
               if (prg_format) {
                  printf("index on %s to %s\n",key,filename);
               } else {
                  printf("%s (%cB):  %s\n",filename,type,key);
               }
               error = NULL;
            }
         }
      }
      close(fp);
   } else
      error = "Couldn't open database : %s\n";

   if (error)
         printf(error,filename);
}


void usage()
{
   register STRPTR *st;
   for(st = usagemessage; **st; st++)
      puts(*st);
}
