//͸
//  Program .....: G_Main                                
//  CopyRight ...: 1993 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "g_menu.ch"
#include "inkey.ch"
#include "g_event.ch"
#include "Mouse.ch"


Function Main(p1,p2,p3,p4,p5)

    local oldblink   := SetBlink( .f. )                            , ;
          Event      := 0                                          , ;
          nKey       := 0                                          , ;
          vTemp      := NIL                                        , ;
          Bar                                                      , ;
          Mouse                                                    , ;
          mForce                                                   , ;
          i


    Set Wrap On
    Set Score Off
    SetCancel( .f. )


    i := GETENV("USE")
    IF ! empty(i)
      p5 := '@'+i

    END

    ParamPlace(p1)
    ParamPlace(p2)
    ParamPlace(p3)
    ParamPlace(p4)
    ParamPlace(p5)

    IF ".INI" $ uppe(DosParamList(5))
      config()
    END

    SaveMode( DisplayMode( ) )
    if ! Empty( dosParamList(3) )
      DisplayMode( dosParamList(3) )
    endif
    ColorSetup(dosParamList(3))


    if '/C1' $ uppe(dosparamlist(3))
      bar_color( 'N/BG*,GR+/RB')
    elseif '/C2' $ uppe(dosparamlist(3))
      bar_color( 'N/W*,R+/BG*')
    elseif '/C3' $ uppe(dosparamlist(3))
      bar_color( 'W+/B*,G+/N')
    elseif '/C4' $ uppe(dosparamlist(3))
      bar_color( 'N/G*, GR+/GR')
    endif



    set cursor off
    messageSet()
    scroll()
    SetColor( "W+/B" )
    @0,0
    NccMesg( 'NccViews Version 1.0', 0, 'center' )
    @0,1 say cDate( date() )
    @0,maxcol()-7 say clock( 'on' )
    setColor( 'B/W')
    @12,00 say 'Initializing... Shareware version'
    SetColor( bar_color() )
    Bar := MenuSys()


    @maxrow(),00
    set color to

    Showbackground()
    Bar:Display()
    Mouse := MouseSys()
    Mouse:Activate()
    Mouse:Hide()

    vTemp := ''
    if ! Empty( dosParamList(1) )
      vTemp :=  vTemp + 'F1' + dosParamList(1) + Chr( K_ENTER )
    endif
    if ! Empty( dosParamList(2) )
      vTemp := vTemp + 'I' + dosParamList(2) + Chr( K_ENTER )
    endif
    if ! Empty( dosParamList(4) )
      vTemp := vTemp + 'V' + subs(dosParamList(4),2) + Chr( K_ENTER )
    endif

    if Empty( vTemp )
      Bar:MenusActive := .t.
      Bar:BarChoice( 2, .f. )
      Bar:MenuChoice( 1, .f. )
      mForce := .t.
    else
      Keyboard vTemp
      mForce := .f.
    endif


    While Event # ev_SysExit                   //  Process while ! request to
                                               //  terminate
       if RedisplayBar()
          RedisplayBar(.f.)
         Bar:Display()
       endif
                                               //
       Event := 0                              //
       if Window_Active()                      //
         Mouse:Hide()                          //
         WinObj():Stabilize()                  //
         Mouse:Show()                          //
       endif                                   //
                                               //

       if ! Empty(WinObj())
         nKey := ( WinObj():UserSlot[2] == NIL )
         MenuSys():PromptActive( VIEW_VERT, nKey )
         MenuSys():PromptActive( VIEW_HORI, (! nKey) )
       endif

       if ! mForce
         Mouse:MouseRead()                     //  Get Event
         nKey := Mouse:Ascii                   //
       else
         nKey := NIL
         mForce := .f.
       endif

       if nKey == NIL .or. nKey # 0            //
         vTemp := Bar:Activate(nKey)           //  nKey
         if vTemp # 0                          //  if Menu Action taken
           Event := MenuEvent( vTemp )         //    Translate Menu event
           nKey := vTemp                       //    nKey := Menu key
         endif                                 //
       else                                    //
         nKey := Bar:Activate()                //  Test if mouse activates bar
         if nKey # 0                           //
           Event := MenuEvent( nKey )          //    Translate Menu event
         endif                                 //
       endif                                   //    redisplay menu bar
                                               //
       if Event == 0                           //
         if Mouse:Button # 0                   //
           Event := MouseEvent()               //    Translate Mouse event
         endif                                 //
       endif                                   //
                                               //
       if Event == 0                           //
         Event := KeyboardEvent( nKey )        //    Translate Keyboard event
       endif                                   //
                                               //
       EventProcess( Event )                   //   Event Processing
                                               //
    enddo                                      //

    clock( 'off' )
    mouse:Hide()
    Bar:Hide()
    SetBlink( oldblink )
    ResetDisplayMode( SaveMode() )
    Set Color to
    scroll(1,0)
    setpos( (maxrow()/2) -1,0 )
    qout( "" )
    Set Cursor on

Return( NIL )


//Ŀ
//  Set Message 
//
Function messageSet()

    Set message to maxrow()

Return( NIL )


//Ŀ
// System flag: Request bar redisplay 
//
Function RedisplayBar( x )
  static bar := .f.

Return( if( x == NIL, bar, bar := x ) )

//Ŀ
// Set up display size 
//
STATIC Function DisplayMode( ScreenMode )

    LOCAL CurrentMode := maxrow()+1

    scroll()
    if ScreenMode # NIL
      if '/43' $ ScreenMode
        setmode(43,maxcol()+1)
      elseif '/50' $ ScreenMode
        setmode(50,maxcol()+1)
      elseif '/25' $ ScreenMode
        setmode(25,maxcol()+1)
      endif
    endif

Return( CurrentMode )


//Ŀ
// Reset Display 
//
STATIC Function ResetDisplayMode( ScreenMode )

    if ScreenMode # NIL
      if ScreenMode == 43
        setmode(43,maxcol()+1)
      elseif ScreenMode == 50
        setmode(50,maxcol()+1)
      elseif ScreenMode == 25
        setmode(25,maxcol()+1)
      endif
    endif

Return( NIL )


//Ŀ
//  Background 
//
Function Showbackground()

    local sColor := SetColor( desktop_color() )


    WinBox( 2,0,maxrow()-1,maxcol(),, repl(DeskTop_char(),9) )
    @maxrow(),00  say space( maxcol()+1 ) color message_color()
    SetColor( sColor )

Return( NIL )


Function MenuSys()

    static menusys := NIL


    if menusys == NIL
      MenuSys := g_menu()
    endif

Return( menusys )


Function GrayBar()

    local o := MenuSys()


    aeval( o:Prompts, { |x| x:active := .f. } )
    o:Display()

Return( NIL )


Function UnGrayBar()

    local o := MenuSys()

    aeval( o:Prompts, { |x| x:active := .t. } )

    o:Display()

Return( NIL )
