//͸
//  Program .....: G_Event                               
//  CopyRight ...: 1993 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "g_event.ch"
#include "g_menu.ch"
#include "inkey.ch"
#include "mouse.ch"

#define TO_SAVE  1
#define TO_OPEN  2

//Ŀ
//  Mouse Event Translation 
//
Function MouseEvent()

    LOCAL Event  := 0                                   , ;
          Mouse  := MouseSys()                          , ;
          x      := Current_Window()                    , ;
          Window := WinObj()                            , ;
          nRow                                          , ;
          nCol                                          , ;
          xwin                                          , ;
          i                                             , ;
          p


    nRow   := Mouse:Row
    nCol   := Mouse:Column

    if Mouse:Button == RIGHT_BUTTON
      Return( Event )
    endif

    if ! Window_Active()
      Return( Event )
    endif

    Do Case

      Case ( nRow == Window:TopRow - 1 .and. ;
           (nCol >= Window:RightColumn + 1 .and. ;
            nCol <= Window:RightColumn + 1))

           Event := ev_Up

      Case ( nRow == Window:BottomRow .and. ;
           (nCol >= Window:RightColumn + 1 .and. ;
            nCol <= Window:RightColumn + 1 ))

           Event := ev_Down

/*
      Case ( nRow == Window:BottomRow +1.and. ;
            ( nCol >= Window:LeftColumn .and. ;
              nCol <= Window:LeftColumn ;
            ) ;
           )

           Event := ev_Left
      Case  ( nRow == Window:BottomRow +1 .and. ;
           ( nCol >= Window:RightColumn .and. ;
            nCol <= Window:RightColumn ))

           Event := ev_Right
*/

      Case ( nRow == Window:TopRow - 1 .and. ;
            ( nCol >= Window:LeftColumn .and. ;
              nCol <= Window:LeftColumn+1 ;
            ) ;
           )

           Event := ev_Left

      Case  ( nRow == Window:TopRow - 1 .and. ;
           ( nCol >= Window:RightColumn -1 .and. ;
            nCol <= Window:RightColumn ))

           Event := ev_Right

      Case ( nRow == Window:TopRow -4 .and. ;
            ( nCol >= Window:LeftColumn .and. ;
              nCol <= Window:LeftColumn ))

           Event := ev_DataClose

      Case ( nRow == Window:TopRow -4 .and. ;
            ( nCol >= Window:LeftColumn -1 .and. ;
              nCol <= Window:RightColumn +1 ))

           Event := ev_WindowMoveResize

      Case ( nRow == Window:BottomRow +1 .and. ;
            ( nCol == Window:LeftColumn -1 .or. ;
              nCol == Window:RightColumn +1 ;
            ) ;
           )
          Event := ev_WindowMoveResize

      Case (  nRow >= Window:TopRow-4 .and. ;
                    nRow <= Window:BottomRow+1 .and. ;
                    nCol >= Window:LeftColumn-1 .and. ;
                    nCol <= Window:RightColumn+1 ;
           ) .and. Mouse:Button == BOTH_BUTTONS

          Event := ev_WindowZoom

      Case (  nRow >= Window:TopRow .and. ;
                    nRow <= Window:BottomRow .and. ;
                    nCol >= Window:LeftColumn .and. ;
                    nCol <= Window:RightColumn ;
           ) .and. Mouse:Button == LEFT_BUTTON

         if Window:CurrentRow > nRow
           Window:Up(Window:CurrentRow - nRow)
           WinVSBar()
         else
           Window:Down(nRow - Window:CurrentRow)
           WinVSBar()
         endif

      Otherwise

         xwin := x
         p := len(win_stack())
         for i = 1 to Len(windows())
           if ! empty(WinFilename(xWin)).and.;
              (  nRow >= WinObj(xWin):TopRow-4 .and. ;
                 nRow <= WinObj(xWin):BottomRow+1 .and. ;
                 nCol >= WinObj(xWin):LeftColumn-1 .and. ;
                 nCol <= WinObj(xWin):RightColumn+1 ;
              )
              if xWin # x
                if ! empty(WinFilename(xWin))
                  DeHighLightWindow(x)
                else
                  loop
                endif
                HighLightWindow(xWin)
              endif
             exit
           Endif

           if p # 1
             xwin := win_stack()[--p]
           endif

         next

    EndCase

Return( Event )


//Ŀ
//  Menu Bar Event Translation 
//
Function MenuEvent( x )

    local Event := 0

    x := if( x == NIL, 0, x )

    Do Case

      Case x == ABOUT_ABOUT       ; Event := ev_About

      Case x == DATABASE_NEW      ; Event := ev_DataNew
      Case x == DATABASE_OPEN     ; Event := ev_DataOpen
      Case x == DATABASE_CLOSE    ; Event := ev_DataClose
      Case x == TEXTFILE_OPEN     ; Event := ev_TextView
      Case x == STRUCTURE_DISPLAY ; Event := ev_DataStructure
      Case x == DATABASE_MODIFY   ; Event := ev_DataModify
      Case x == ENV_SUMMARY       ; Event := ev_EnvSummary

      Case x == PRINT_FILE       ; Event := ev_PrintFile
      Case x == PRINT_STRUCTURE  ; Event := ev_PrintStructure

      Case x == INDEX_NEW        ; Event := ev_IndexNew
      Case x == INDEX_OPEN       ; Event := ev_IndexOpen
      Case x == INDEX_CLOSE      ; Event := ev_IndexClose
      Case x == INDEX_MODIFY     ; Event := ev_IndexModify
      Case x == INDEX_REORDER    ; Event := ev_IndexReorder
      Case x == INDEX_REINDEX    ; Event := ev_IndexReindex
      Case x == INDEX_RELATION   ; Event := ev_IndexRelation

      Case x == VIEW_MODIFY       ; Event := ev_ViewModify

      Case x == SYS_EXIT          ; Event := ev_SysExit

      Case x == CHANGE_RECORD     ; Event := ev_ChangeRecord
      Case x == ADD_RECORD        ; Event := ev_AddRecord
      Case x == DUPE_RECORD       ; Event := ev_DupeRecord
      Case x == INS_BLANK         ; Event := ev_InsertBlank
      Case x == DELE_RECORD       ; Event := ev_DeleRecord
      Case x == REPLACE_REC       ; Event := ev_ReplRecord
      Case x == PACK_FILE         ; Event := ev_PackFile
      Case x == ZAP_FILE          ; Event := ev_ZapFile

      Case x == GO_REC            ; Event := ev_GoToRec
      Case x == LOCA_REC          ; Event := ev_LocateRec
      Case x == SEEK_REC          ; Event := ev_SeekRec

      Case x == WIN_NEXT          ; Event := ev_WindowNext
      Case x == WIN_PREV          ; Event := ev_WindowPrev
      Case x == WIN_MOVE          ; Event := ev_WindowMoveResize
      Case x == WIN_ZOOM          ; Event := ev_WindowZoom
      Case x == VIEW_VERT         ; Event := ev_WindowVertical
      Case x == VIEW_HORI         ; Event := ev_WindowHorizontal

      Case x == HELP_GEN          ; Event := ev_GenHelp
      Case x == HELP_KEY          ; Event := ev_KeyHelp

    EndCase

Return( Event )



//Ŀ
// KeyBoard Event Translation 
//
Function KeyBoardEvent(x)

    LOCAL Event := 0, msColor := SetColor()

    x := if( x == NIL, 0, x )

    Do Case
      Case x == K_TAB            ;    Event := ev_WindowNext
      Case x == K_SH_TAB         ;    Event := ev_WindowPrev
      Case x == K_UP             ;    Event := ev_Up
      Case x == K_DOWN           ;    Event := ev_Down
      Case x == K_LEFT           ;    Event := ev_Left
      Case x == K_RIGHT          ;    Event := ev_Right
      Case x == K_CTRL_LEFT      ;    Event := ev_Left
      Case x == K_CTRL_RIGHT     ;    Event := ev_Right
      Case x == K_HOME           ;    Event := ev_Home
      Case x == K_END            ;    Event := ev_End
      Case x == K_CTRL_PGUP      ;    Event := ev_GoTop
      Case x == K_CTRL_PGDN      ;    Event := ev_GoBottom
      Case x == K_PGUP           ;    Event := ev_PageUp
      Case x == K_PGDN           ;    Event := ev_PageDown
      Case x == K_CTRL_HOME      ;    Event := ev_PanHome
      Case x == K_CTRL_END       ;    Event := ev_PanEnd
      Case x == K_INS            ;    Event := ev_QuickInsertBlank
      Case x == K_DEL            ;    Event := ev_QuickDelete

      Case x == K_ALT_1          ;    Event := x
      Case x == K_ALT_2          ;    Event := x
      Case x == K_ALT_3          ;    Event := x
      Case x == K_ALT_4          ;    Event := x
      Case x == K_ALT_5          ;    Event := x
      Case x == K_ALT_6          ;    Event := x
      Case x == K_ALT_7          ;    Event := x
      Case x == K_ALT_8          ;    Event := x
      Case x == K_ALT_9          ;    Event := x

      Case uppe(chr(x)) == 'F'   ;    Event := ev_DataOpen
      Case uppe(chr(x)) == 'I'   ;    Event := ev_IndexOpen
      Case uppe(chr(x)) == 'A'   ;    Event := ev_AddRecord
      Case uppe(chr(x)) == 'D'   ;    Event := ev_DeleRecord
      Case uppe(chr(x)) == 'R'   ;    Event := ev_ReplRecord
      Case uppe(chr(x)) == 'P'   ;    Event := ev_PackFile
      Case uppe(chr(x)) == 'Z'   ;    Event := ev_ZapFile
      Case uppe(chr(x)) == 'G'   ;    Event := ev_GoToRec
      Case uppe(chr(x)) == 'L'   ;    Event := ev_LocateRec
      Case uppe(chr(x)) == 'S'   ;    Event := ev_SeekRec

      Case x == K_F1             ;    Event := ev_KeyHelp
      Case x == K_ALT_U          ;    Event := ev_EnvSummary

      Case x == K_ALT_F1         ;    Event := x

        SetColor("W+/R")
        WinBox( 8, 15, 16, 64,,5, .t. )
        @  9,18 say 'Garbage Collection..............:' + str(memory( -1  )) + "K"
        @ 10,18 say 'Fixed Head......................:' + str(memory( 101 )) + "K"
        @ 11,18 say 'Character Space.................:' + str(memory( 0 )) + "K"
        @ 12,18 say 'Largest Block...................:' + str(memory( 1 )) + "K"
        @ 13,18 say '................................:' + str(memory( 2 )) + "K"
        @ 14,18 say 'EMS Available to VMM............:' + str(memory( 3 )) + "K"
        @ 15,18 say 'EMS and Disk Available to VMM...:' + str(memory( 4 )) + "K"
        inkey(0)
        SetColor(msColor)
        ShowDeskTop()

    EndCase

Return( Event )


//Ŀ
//   Event Processing 
//
Function EventProcess( Event )

    local Window := WinObj(), Mouse := MouseSys(), mHelp := .t., mNew := .f.

    Event := if( Event == NIL, 0, Event )

    Mouse:Hide()
    Do Case
      Case Event == ev_About
        GrayBar()
        g_about()
        UnGrayBar()

      Case Event == ev_DataNew
        mNew := .t.
        GrayBar()
//        g_DataNew( mNew )
        UnGrayBar()

      Case Event == ev_DataOpen
        DehighlightWindow()
        GrayBar()
        g_DataOpen()
        UnGrayBar()
        OpenWindow()

      Case Event == ev_DataClose
        g_Dataclose()
        UnGrayBar()

      Case Event == ev_KeyHelp
        GrayBar()
        gen_Help()
        UnGrayBar()

      Case Event == ev_GenHelp
        GrayBar()
        gen_Help( "" )
        UnGrayBar()

      Case Event == ev_TextView
        mHelp := .f.
        GrayBar()
        g_FView( "","" ,"512" ,"10" , ,mHelp )
        UnGrayBar()

    EndCase

    if ! Window_Active()
      Mouse:Hide()
      Return( Event )
    endif

    Do Case

      Case Event == ev_DataModify
        mNew := .f.
        GrayBar()
        g_DataNew( mNew )
        UnGrayBar()

      Case Event == ev_WindowNext        ;       WinNext()
      Case Event == ev_WindowPrev        ;       WinPrev()
      Case Event == ev_WindowZoom        ;       WinZoom()

      Case Event == ev_WindowMoveResize
        WinResize()

      Case Event == ev_ViewModify
        GrayBar()
        g_ViewCreate()
        UnGrayBar()
        OpenWindow()

      Case Event == ev_WindowVertical    ;  g_Record()

      Case Event == ev_WindowHorizontal  ;  g_Browse()


      Case Event == ev_Left
        if Window:UserSlot[2] == NIL
          Window:Left()
        endif

      Case Event == ev_Right     
        if Window:UserSlot[2] == NIL
          Window:Right()
        endif

      Case Event == ev_PanHome
        if Window:UserSlot[2] == NIL
          Window:PanHome()
        endif

      Case Event == ev_PanEnd
        if Window:UserSlot[2] == NIL
          Window:PanEnd()
        endif

      Case Event == ev_Up        ;  Window:Up()       ; WinVSBar()
      Case Event == ev_Down      ;  Window:Down()     ; WinVSBar()
      Case Event == ev_Home      ;  Window:Home()     ; WinVSBar()
      Case Event == ev_End       ;  Window:End()      ; WinVSBar()
      Case Event == ev_GoTop     ;  Window:GoTop()    ; WinVSBar()
      Case Event == ev_GoBottom  ;  Window:GoBottom() ; WinVSBar()
      Case Event == ev_PageUp    ;  Window:PageUp()   ; WinVSBar()
      Case Event == ev_PageDown  ;  Window:PageDown() ; WinVSBar()

      Case Event == K_ALT_1    ;  GotoWin(1)
      Case Event == K_ALT_2    ;  GotoWin(2)
      Case Event == K_ALT_3    ;  GotoWin(3)
      Case Event == K_ALT_4    ;  GotoWin(4)
      Case Event == K_ALT_5    ;  GotoWin(5)
      Case Event == K_ALT_6    ;  GotoWin(6)
      Case Event == K_ALT_7    ;  GotoWin(7)
      Case Event == K_ALT_8    ;  GotoWin(8)
      Case Event == K_ALT_9    ;  GotoWin(9)

      Case Event == ev_DataStructure      ; GrayBar() ; g_DispStrue()   ; UnGrayBar()
      Case Event == ev_PrintStructure     ; GrayBar() ; g_PrintStru()   ; UnGrayBar()
      Case Event == ev_PrintFile          ; GrayBar() ; g_PrintFile()   ; UnGrayBar()
      Case Event == ev_IndexNew           ; GrayBar() ; g_indexcreate() ; UnGrayBar()
      Case Event == ev_IndexOpen          ; GrayBar() ; g_indexopen()   ; UnGrayBar()
      Case Event == ev_IndexReorder       ; GrayBar() ; g_indexorder()  ; UnGrayBar()
      Case Event == ev_IndexClose         ; GrayBar() ; g_indexClose()  ; UnGrayBar()
      Case Event == ev_IndexReindex       ; GrayBar() ; g_reindex()     ; UnGrayBar()
      Case Event == ev_IndexRelation
      Case Event == ev_IndexModify        ; GrayBar() ; g_indexOne()    ; UnGrayBar()
      Case Event == ev_QuickInsertBlank   ; GrayBar() ; g_insert()      ; UnGrayBar()
      Case Event == ev_DupeRecord         ; GrayBar() ; g_duplicate()   ; UnGrayBar()
      Case Event == ev_QuickDelete        ; GrayBar() ; g_quickdelete() ; UnGrayBar()
      Case Event == ev_DeleRecord         ; GrayBar() ; g_delete()      ; UnGrayBar()
      Case Event == ev_EnvSummary         ; GrayBar() ; g_summary()     ; UnGrayBar()
      Case Event == ev_InsertBlank        ; GrayBar() ; g_insert()      ; UnGrayBar()
      Case Event == ev_ChangeRecord       ; GrayBar() ; g_editRec()     ; UnGrayBar()
      Case Event == ev_AddRecord          ; GrayBar() ; g_add()         ; UnGrayBar()
      Case Event == ev_ReplRecord         ; GrayBar() ; g_replace()     ; UnGrayBar()
      Case Event == ev_PackFile           ; GrayBar() ; g_pack()        ; UnGrayBar()
      Case Event == ev_ZapFile            ; GrayBar() ; g_zap()         ; UnGrayBar()

      Case Event == ev_GoToRec
         GrayBar()
         g_Goto()
         WinVSBar()
         UnGrayBar()
      Case Event == ev_LocateRec
         GrayBar()
         g_Locate()
         WinVSBar()
         UnGrayBar()
      Case Event == ev_SeekRec
         GrayBar()
         g_seek()
         WinVSBar()
         UnGrayBar()


    EndCase

    Mouse:Show()
    Window_Active( ! Empty(alias()) )

Return( NIL )


static function GotoWin( x )

    if ! Empty(Winfilename(x))
      DeHighLightWindow()
      Current_Window(x)
      HighLightWindow()
    endif

Return( NIL )
